/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDashboardEmbedUrlRequest extends QuickSightRequest implements
        ToCopyableBuilder<GetDashboardEmbedUrlRequest.Builder, GetDashboardEmbedUrlRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(GetDashboardEmbedUrlRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(GetDashboardEmbedUrlRequest::dashboardId))
            .setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()).build();

    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityType").getter(getter(GetDashboardEmbedUrlRequest::identityTypeAsString))
            .setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("creds-type").build()).build();

    private static final SdkField<Long> SESSION_LIFETIME_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SessionLifetimeInMinutes").getter(getter(GetDashboardEmbedUrlRequest::sessionLifetimeInMinutes))
            .setter(setter(Builder::sessionLifetimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("session-lifetime").build())
            .build();

    private static final SdkField<Boolean> UNDO_REDO_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UndoRedoDisabled").getter(getter(GetDashboardEmbedUrlRequest::undoRedoDisabled))
            .setter(setter(Builder::undoRedoDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("undo-redo-disabled").build())
            .build();

    private static final SdkField<Boolean> RESET_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ResetDisabled").getter(getter(GetDashboardEmbedUrlRequest::resetDisabled))
            .setter(setter(Builder::resetDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reset-disabled").build())
            .build();

    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserArn").getter(getter(GetDashboardEmbedUrlRequest::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("user-arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DASHBOARD_ID_FIELD, IDENTITY_TYPE_FIELD, SESSION_LIFETIME_IN_MINUTES_FIELD, UNDO_REDO_DISABLED_FIELD,
            RESET_DISABLED_FIELD, USER_ARN_FIELD));

    private final String awsAccountId;

    private final String dashboardId;

    private final String identityType;

    private final Long sessionLifetimeInMinutes;

    private final Boolean undoRedoDisabled;

    private final Boolean resetDisabled;

    private final String userArn;

    private GetDashboardEmbedUrlRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.identityType = builder.identityType;
        this.sessionLifetimeInMinutes = builder.sessionLifetimeInMinutes;
        this.undoRedoDisabled = builder.undoRedoDisabled;
        this.resetDisabled = builder.resetDisabled;
        this.userArn = builder.userArn;
    }

    /**
     * <p>
     * The ID for the AWS account that contains the dashboard that you're embedding.
     * </p>
     * 
     * @return The ID for the AWS account that contains the dashboard that you're embedding.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the dashboard, also added to the IAM policy.
     * </p>
     * 
     * @return The ID for the dashboard, also added to the IAM policy.
     */
    public String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The authentication method that the user uses to sign in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The authentication method that the user uses to sign in.
     * @see IdentityType
     */
    public IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * The authentication method that the user uses to sign in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The authentication method that the user uses to sign in.
     * @see IdentityType
     */
    public String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * How many minutes the session is valid. The session lifetime must be 15-600 minutes.
     * </p>
     * 
     * @return How many minutes the session is valid. The session lifetime must be 15-600 minutes.
     */
    public Long sessionLifetimeInMinutes() {
        return sessionLifetimeInMinutes;
    }

    /**
     * <p>
     * Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button.
     * </p>
     * 
     * @return Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo
     *         button.
     */
    public Boolean undoRedoDisabled() {
        return undoRedoDisabled;
    }

    /**
     * <p>
     * Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.
     * </p>
     * 
     * @return Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.
     */
    public Boolean resetDisabled() {
        return resetDisabled;
    }

    /**
     * <p>
     * The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You
     * can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one
     * of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Active Directory (AD) users or group members
     * </p>
     * </li>
     * <li>
     * <p>
     * Invited nonfederated users
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect,
     * or IAM federation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
     * </p>
     * 
     * @return The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity
     *         type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins)
     *         authenticated as one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Active Directory (AD) users or group members
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Invited nonfederated users
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID
     *         Connect, or IAM federation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
     */
    public String userArn() {
        return userArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sessionLifetimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(undoRedoDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(resetDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashboardEmbedUrlRequest)) {
            return false;
        }
        GetDashboardEmbedUrlRequest other = (GetDashboardEmbedUrlRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dashboardId(), other.dashboardId())
                && Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(sessionLifetimeInMinutes(), other.sessionLifetimeInMinutes())
                && Objects.equals(undoRedoDisabled(), other.undoRedoDisabled())
                && Objects.equals(resetDisabled(), other.resetDisabled()) && Objects.equals(userArn(), other.userArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDashboardEmbedUrlRequest").add("AwsAccountId", awsAccountId())
                .add("DashboardId", dashboardId()).add("IdentityType", identityTypeAsString())
                .add("SessionLifetimeInMinutes", sessionLifetimeInMinutes()).add("UndoRedoDisabled", undoRedoDisabled())
                .add("ResetDisabled", resetDisabled()).add("UserArn", userArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "IdentityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "SessionLifetimeInMinutes":
            return Optional.ofNullable(clazz.cast(sessionLifetimeInMinutes()));
        case "UndoRedoDisabled":
            return Optional.ofNullable(clazz.cast(undoRedoDisabled()));
        case "ResetDisabled":
            return Optional.ofNullable(clazz.cast(resetDisabled()));
        case "UserArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDashboardEmbedUrlRequest, T> g) {
        return obj -> g.apply((GetDashboardEmbedUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDashboardEmbedUrlRequest> {
        /**
         * <p>
         * The ID for the AWS account that contains the dashboard that you're embedding.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the AWS account that contains the dashboard that you're embedding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the dashboard, also added to the IAM policy.
         * </p>
         * 
         * @param dashboardId
         *        The ID for the dashboard, also added to the IAM policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The authentication method that the user uses to sign in.
         * </p>
         * 
         * @param identityType
         *        The authentication method that the user uses to sign in.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The authentication method that the user uses to sign in.
         * </p>
         * 
         * @param identityType
         *        The authentication method that the user uses to sign in.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * How many minutes the session is valid. The session lifetime must be 15-600 minutes.
         * </p>
         * 
         * @param sessionLifetimeInMinutes
         *        How many minutes the session is valid. The session lifetime must be 15-600 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes);

        /**
         * <p>
         * Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo
         * button.
         * </p>
         * 
         * @param undoRedoDisabled
         *        Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the
         *        undo/redo button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder undoRedoDisabled(Boolean undoRedoDisabled);

        /**
         * <p>
         * Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.
         * </p>
         * 
         * @param resetDisabled
         *        Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset
         *        button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetDisabled(Boolean resetDisabled);

        /**
         * <p>
         * The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type.
         * You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated
         * as one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Active Directory (AD) users or group members
         * </p>
         * </li>
         * <li>
         * <p>
         * Invited nonfederated users
         * </p>
         * </li>
         * <li>
         * <p>
         * IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID
         * Connect, or IAM federation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
         * </p>
         * 
         * @param userArn
         *        The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity
         *        type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins)
         *        authenticated as one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Active Directory (AD) users or group members
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Invited nonfederated users
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML,
         *        OpenID Connect, or IAM federation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dashboardId;

        private String identityType;

        private Long sessionLifetimeInMinutes;

        private Boolean undoRedoDisabled;

        private Boolean resetDisabled;

        private String userArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashboardEmbedUrlRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dashboardId(model.dashboardId);
            identityType(model.identityType);
            sessionLifetimeInMinutes(model.sessionLifetimeInMinutes);
            undoRedoDisabled(model.undoRedoDisabled);
            resetDisabled(model.resetDisabled);
            userArn(model.userArn);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        public final String getIdentityType() {
            return identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public final Long getSessionLifetimeInMinutes() {
            return sessionLifetimeInMinutes;
        }

        @Override
        public final Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
            return this;
        }

        public final void setSessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
        }

        public final Boolean getUndoRedoDisabled() {
            return undoRedoDisabled;
        }

        @Override
        public final Builder undoRedoDisabled(Boolean undoRedoDisabled) {
            this.undoRedoDisabled = undoRedoDisabled;
            return this;
        }

        public final void setUndoRedoDisabled(Boolean undoRedoDisabled) {
            this.undoRedoDisabled = undoRedoDisabled;
        }

        public final Boolean getResetDisabled() {
            return resetDisabled;
        }

        @Override
        public final Builder resetDisabled(Boolean resetDisabled) {
            this.resetDisabled = resetDisabled;
            return this;
        }

        public final void setResetDisabled(Boolean resetDisabled) {
            this.resetDisabled = resetDisabled;
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDashboardEmbedUrlRequest build() {
            return new GetDashboardEmbedUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
