/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIamPolicyAssignmentRequest extends QuickSightRequest implements
        ToCopyableBuilder<DescribeIamPolicyAssignmentRequest.Builder, DescribeIamPolicyAssignmentRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(DescribeIamPolicyAssignmentRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ASSIGNMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentName").getter(getter(DescribeIamPolicyAssignmentRequest::assignmentName))
            .setter(setter(Builder::assignmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AssignmentName").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(DescribeIamPolicyAssignmentRequest::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            ASSIGNMENT_NAME_FIELD, NAMESPACE_FIELD));

    private final String awsAccountId;

    private final String assignmentName;

    private final String namespace;

    private DescribeIamPolicyAssignmentRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.assignmentName = builder.assignmentName;
        this.namespace = builder.namespace;
    }

    /**
     * <p>
     * The ID of the AWS account that contains the assignment that you want to describe.
     * </p>
     * 
     * @return The ID of the AWS account that contains the assignment that you want to describe.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The name of the assignment, also called a rule.
     * </p>
     * 
     * @return The name of the assignment, also called a rule.
     */
    public String assignmentName() {
        return assignmentName;
    }

    /**
     * <p>
     * The namespace that contains the assignment.
     * </p>
     * 
     * @return The namespace that contains the assignment.
     */
    public String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentName());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIamPolicyAssignmentRequest)) {
            return false;
        }
        DescribeIamPolicyAssignmentRequest other = (DescribeIamPolicyAssignmentRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(assignmentName(), other.assignmentName())
                && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeIamPolicyAssignmentRequest").add("AwsAccountId", awsAccountId())
                .add("AssignmentName", assignmentName()).add("Namespace", namespace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AssignmentName":
            return Optional.ofNullable(clazz.cast(assignmentName()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIamPolicyAssignmentRequest, T> g) {
        return obj -> g.apply((DescribeIamPolicyAssignmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeIamPolicyAssignmentRequest> {
        /**
         * <p>
         * The ID of the AWS account that contains the assignment that you want to describe.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the AWS account that contains the assignment that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The name of the assignment, also called a rule.
         * </p>
         * 
         * @param assignmentName
         *        The name of the assignment, also called a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentName(String assignmentName);

        /**
         * <p>
         * The namespace that contains the assignment.
         * </p>
         * 
         * @param namespace
         *        The namespace that contains the assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String assignmentName;

        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIamPolicyAssignmentRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            assignmentName(model.assignmentName);
            namespace(model.namespace);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getAssignmentName() {
            return assignmentName;
        }

        @Override
        public final Builder assignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
            return this;
        }

        public final void setAssignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeIamPolicyAssignmentRequest build() {
            return new DescribeIamPolicyAssignmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
