/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The row-level security configuration for the dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowLevelPermissionDataSet implements SdkPojo, Serializable,
        ToCopyableBuilder<RowLevelPermissionDataSet.Builder, RowLevelPermissionDataSet> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(RowLevelPermissionDataSet::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(RowLevelPermissionDataSet::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> PERMISSION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionPolicy").getter(getter(RowLevelPermissionDataSet::permissionPolicyAsString))
            .setter(setter(Builder::permissionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, ARN_FIELD,
            PERMISSION_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String namespace;

    private final String arn;

    private final String permissionPolicy;

    private RowLevelPermissionDataSet(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.arn = builder.arn;
        this.permissionPolicy = builder.permissionPolicy;
    }

    /**
     * <p>
     * The namespace associated with the row-level permissions dataset.
     * </p>
     * 
     * @return The namespace associated with the row-level permissions dataset.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the permission dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the permission dataset.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * Permission policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionPolicy}
     * will return {@link RowLevelPermissionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionPolicyAsString}.
     * </p>
     * 
     * @return Permission policy.
     * @see RowLevelPermissionPolicy
     */
    public RowLevelPermissionPolicy permissionPolicy() {
        return RowLevelPermissionPolicy.fromValue(permissionPolicy);
    }

    /**
     * <p>
     * Permission policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionPolicy}
     * will return {@link RowLevelPermissionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionPolicyAsString}.
     * </p>
     * 
     * @return Permission policy.
     * @see RowLevelPermissionPolicy
     */
    public String permissionPolicyAsString() {
        return permissionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionPolicyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowLevelPermissionDataSet)) {
            return false;
        }
        RowLevelPermissionDataSet other = (RowLevelPermissionDataSet) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(arn(), other.arn())
                && Objects.equals(permissionPolicyAsString(), other.permissionPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RowLevelPermissionDataSet").add("Namespace", namespace()).add("Arn", arn())
                .add("PermissionPolicy", permissionPolicyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "PermissionPolicy":
            return Optional.ofNullable(clazz.cast(permissionPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RowLevelPermissionDataSet, T> g) {
        return obj -> g.apply((RowLevelPermissionDataSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowLevelPermissionDataSet> {
        /**
         * <p>
         * The namespace associated with the row-level permissions dataset.
         * </p>
         * 
         * @param namespace
         *        The namespace associated with the row-level permissions dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the permission dataset.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the permission dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Permission policy.
         * </p>
         * 
         * @param permissionPolicy
         *        Permission policy.
         * @see RowLevelPermissionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RowLevelPermissionPolicy
         */
        Builder permissionPolicy(String permissionPolicy);

        /**
         * <p>
         * Permission policy.
         * </p>
         * 
         * @param permissionPolicy
         *        Permission policy.
         * @see RowLevelPermissionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RowLevelPermissionPolicy
         */
        Builder permissionPolicy(RowLevelPermissionPolicy permissionPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String namespace;

        private String arn;

        private String permissionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(RowLevelPermissionDataSet model) {
            namespace(model.namespace);
            arn(model.arn);
            permissionPolicy(model.permissionPolicy);
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPermissionPolicy() {
            return permissionPolicy;
        }

        @Override
        public final Builder permissionPolicy(String permissionPolicy) {
            this.permissionPolicy = permissionPolicy;
            return this;
        }

        @Override
        public final Builder permissionPolicy(RowLevelPermissionPolicy permissionPolicy) {
            this.permissionPolicy(permissionPolicy == null ? null : permissionPolicy.toString());
            return this;
        }

        public final void setPermissionPolicy(String permissionPolicy) {
            this.permissionPolicy = permissionPolicy;
        }

        @Override
        public RowLevelPermissionDataSet build() {
            return new RowLevelPermissionDataSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
