/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dashboard summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DashboardSummary.Builder, DashboardSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DashboardSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(DashboardSummary::dashboardId)).setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DashboardSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DashboardSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DashboardSummary::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Long> PUBLISHED_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PublishedVersionNumber").getter(getter(DashboardSummary::publishedVersionNumber))
            .setter(setter(Builder::publishedVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishedVersionNumber").build())
            .build();

    private static final SdkField<Instant> LAST_PUBLISHED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastPublishedTime").getter(getter(DashboardSummary::lastPublishedTime))
            .setter(setter(Builder::lastPublishedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastPublishedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DASHBOARD_ID_FIELD,
            NAME_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, PUBLISHED_VERSION_NUMBER_FIELD, LAST_PUBLISHED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String dashboardId;

    private final String name;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final Long publishedVersionNumber;

    private final Instant lastPublishedTime;

    private DashboardSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dashboardId = builder.dashboardId;
        this.name = builder.name;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.publishedVersionNumber = builder.publishedVersionNumber;
        this.lastPublishedTime = builder.lastPublishedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * Dashboard ID.
     * </p>
     * 
     * @return Dashboard ID.
     */
    public String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * A display name for the dashboard.
     * </p>
     * 
     * @return A display name for the dashboard.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The time that this dashboard was created.
     * </p>
     * 
     * @return The time that this dashboard was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The last time that this dashboard was updated.
     * </p>
     * 
     * @return The last time that this dashboard was updated.
     */
    public Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Published version number.
     * </p>
     * 
     * @return Published version number.
     */
    public Long publishedVersionNumber() {
        return publishedVersionNumber;
    }

    /**
     * <p>
     * The last time that this dashboard was published.
     * </p>
     * 
     * @return The last time that this dashboard was published.
     */
    public Instant lastPublishedTime() {
        return lastPublishedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(publishedVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(lastPublishedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardSummary)) {
            return false;
        }
        DashboardSummary other = (DashboardSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(dashboardId(), other.dashboardId())
                && Objects.equals(name(), other.name()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(publishedVersionNumber(), other.publishedVersionNumber())
                && Objects.equals(lastPublishedTime(), other.lastPublishedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DashboardSummary").add("Arn", arn()).add("DashboardId", dashboardId()).add("Name", name())
                .add("CreatedTime", createdTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("PublishedVersionNumber", publishedVersionNumber()).add("LastPublishedTime", lastPublishedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "PublishedVersionNumber":
            return Optional.ofNullable(clazz.cast(publishedVersionNumber()));
        case "LastPublishedTime":
            return Optional.ofNullable(clazz.cast(lastPublishedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardSummary, T> g) {
        return obj -> g.apply((DashboardSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Dashboard ID.
         * </p>
         * 
         * @param dashboardId
         *        Dashboard ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * A display name for the dashboard.
         * </p>
         * 
         * @param name
         *        A display name for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time that this dashboard was created.
         * </p>
         * 
         * @param createdTime
         *        The time that this dashboard was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The last time that this dashboard was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last time that this dashboard was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Published version number.
         * </p>
         * 
         * @param publishedVersionNumber
         *        Published version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishedVersionNumber(Long publishedVersionNumber);

        /**
         * <p>
         * The last time that this dashboard was published.
         * </p>
         * 
         * @param lastPublishedTime
         *        The last time that this dashboard was published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastPublishedTime(Instant lastPublishedTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String dashboardId;

        private String name;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private Long publishedVersionNumber;

        private Instant lastPublishedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardSummary model) {
            arn(model.arn);
            dashboardId(model.dashboardId);
            name(model.name);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            publishedVersionNumber(model.publishedVersionNumber);
            lastPublishedTime(model.lastPublishedTime);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final Long getPublishedVersionNumber() {
            return publishedVersionNumber;
        }

        @Override
        public final Builder publishedVersionNumber(Long publishedVersionNumber) {
            this.publishedVersionNumber = publishedVersionNumber;
            return this;
        }

        public final void setPublishedVersionNumber(Long publishedVersionNumber) {
            this.publishedVersionNumber = publishedVersionNumber;
        }

        public final Instant getLastPublishedTime() {
            return lastPublishedTime;
        }

        @Override
        public final Builder lastPublishedTime(Instant lastPublishedTime) {
            this.lastPublishedTime = lastPublishedTime;
            return this;
        }

        public final void setLastPublishedTime(Instant lastPublishedTime) {
            this.lastPublishedTime = lastPublishedTime;
        }

        @Override
        public DashboardSummary build() {
            return new DashboardSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
