/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountSettingsRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateAccountSettingsRequest.Builder, UpdateAccountSettingsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateAccountSettingsRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DEFAULT_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultNamespace").getter(getter(UpdateAccountSettingsRequest::defaultNamespace))
            .setter(setter(Builder::defaultNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultNamespace").build()).build();

    private static final SdkField<String> NOTIFICATION_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationEmail").getter(getter(UpdateAccountSettingsRequest::notificationEmail))
            .setter(setter(Builder::notificationEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationEmail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DEFAULT_NAMESPACE_FIELD, NOTIFICATION_EMAIL_FIELD));

    private final String awsAccountId;

    private final String defaultNamespace;

    private final String notificationEmail;

    private UpdateAccountSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.defaultNamespace = builder.defaultNamespace;
        this.notificationEmail = builder.notificationEmail;
    }

    /**
     * <p>
     * The ID for the AWS account that contains the QuickSight settings that you want to list.
     * </p>
     * 
     * @return The ID for the AWS account that contains the QuickSight settings that you want to list.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The default namespace for this AWS account. Currently, the default is <code>default</code>. AWS Identity and
     * Access Management (IAM) users that register for the first time with QuickSight provide an email that becomes
     * associated with the default namespace.
     * </p>
     * 
     * @return The default namespace for this AWS account. Currently, the default is <code>default</code>. AWS Identity
     *         and Access Management (IAM) users that register for the first time with QuickSight provide an email that
     *         becomes associated with the default namespace.
     */
    public String defaultNamespace() {
        return defaultNamespace;
    }

    /**
     * <p>
     * The email address that you want QuickSight to send notifications to regarding your AWS account or QuickSight
     * subscription.
     * </p>
     * 
     * @return The email address that you want QuickSight to send notifications to regarding your AWS account or
     *         QuickSight subscription.
     */
    public String notificationEmail() {
        return notificationEmail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(notificationEmail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsRequest)) {
            return false;
        }
        UpdateAccountSettingsRequest other = (UpdateAccountSettingsRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(defaultNamespace(), other.defaultNamespace())
                && Objects.equals(notificationEmail(), other.notificationEmail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateAccountSettingsRequest").add("AwsAccountId", awsAccountId())
                .add("DefaultNamespace", defaultNamespace()).add("NotificationEmail", notificationEmail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DefaultNamespace":
            return Optional.ofNullable(clazz.cast(defaultNamespace()));
        case "NotificationEmail":
            return Optional.ofNullable(clazz.cast(notificationEmail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsRequest, T> g) {
        return obj -> g.apply((UpdateAccountSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAccountSettingsRequest> {
        /**
         * <p>
         * The ID for the AWS account that contains the QuickSight settings that you want to list.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the AWS account that contains the QuickSight settings that you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The default namespace for this AWS account. Currently, the default is <code>default</code>. AWS Identity and
         * Access Management (IAM) users that register for the first time with QuickSight provide an email that becomes
         * associated with the default namespace.
         * </p>
         * 
         * @param defaultNamespace
         *        The default namespace for this AWS account. Currently, the default is <code>default</code>. AWS
         *        Identity and Access Management (IAM) users that register for the first time with QuickSight provide an
         *        email that becomes associated with the default namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultNamespace(String defaultNamespace);

        /**
         * <p>
         * The email address that you want QuickSight to send notifications to regarding your AWS account or QuickSight
         * subscription.
         * </p>
         * 
         * @param notificationEmail
         *        The email address that you want QuickSight to send notifications to regarding your AWS account or
         *        QuickSight subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEmail(String notificationEmail);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String defaultNamespace;

        private String notificationEmail;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            defaultNamespace(model.defaultNamespace);
            notificationEmail(model.notificationEmail);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDefaultNamespace() {
            return defaultNamespace;
        }

        @Override
        public final Builder defaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
            return this;
        }

        public final void setDefaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
        }

        public final String getNotificationEmail() {
            return notificationEmail;
        }

        @Override
        public final Builder notificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
            return this;
        }

        public final void setNotificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountSettingsRequest build() {
            return new UpdateAccountSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
