/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIamPolicyAssignmentRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateIamPolicyAssignmentRequest.Builder, UpdateIamPolicyAssignmentRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateIamPolicyAssignmentRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ASSIGNMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentName").getter(getter(UpdateIamPolicyAssignmentRequest::assignmentName))
            .setter(setter(Builder::assignmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AssignmentName").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(UpdateIamPolicyAssignmentRequest::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()).build();

    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentStatus").getter(getter(UpdateIamPolicyAssignmentRequest::assignmentStatusAsString))
            .setter(setter(Builder::assignmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatus").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyArn").getter(getter(UpdateIamPolicyAssignmentRequest::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()).build();

    private static final SdkField<Map<String, List<String>>> IDENTITIES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Identities")
            .getter(getter(UpdateIamPolicyAssignmentRequest::identities))
            .setter(setter(Builder::identities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identities").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            ASSIGNMENT_NAME_FIELD, NAMESPACE_FIELD, ASSIGNMENT_STATUS_FIELD, POLICY_ARN_FIELD, IDENTITIES_FIELD));

    private final String awsAccountId;

    private final String assignmentName;

    private final String namespace;

    private final String assignmentStatus;

    private final String policyArn;

    private final Map<String, List<String>> identities;

    private UpdateIamPolicyAssignmentRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.assignmentName = builder.assignmentName;
        this.namespace = builder.namespace;
        this.assignmentStatus = builder.assignmentStatus;
        this.policyArn = builder.policyArn;
        this.identities = builder.identities;
    }

    /**
     * <p>
     * The ID of the AWS account that contains the IAM policy assignment.
     * </p>
     * 
     * @return The ID of the AWS account that contains the IAM policy assignment.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The name of the assignment, also called a rule. This name must be unique within an AWS account.
     * </p>
     * 
     * @return The name of the assignment, also called a rule. This name must be unique within an AWS account.
     */
    public String assignmentName() {
        return assignmentName;
    }

    /**
     * <p>
     * The namespace of the assignment.
     * </p>
     * 
     * @return The namespace of the assignment.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The status of the assignment. Possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - This assignment isn't used when creating the data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return The status of the assignment. Possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - This assignment isn't used when creating the data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
     *         </p>
     *         </li>
     * @see AssignmentStatus
     */
    public AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(assignmentStatus);
    }

    /**
     * <p>
     * The status of the assignment. Possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - This assignment isn't used when creating the data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return The status of the assignment. Possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - This assignment isn't used when creating the data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
     *         </p>
     *         </li>
     * @see AssignmentStatus
     */
    public String assignmentStatusAsString() {
        return assignmentStatus;
    }

    /**
     * <p>
     * The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment.
     * </p>
     * 
     * @return The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment.
     */
    public String policyArn() {
        return policyArn;
    }

    /**
     * Returns true if the Identities property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIdentities() {
        return identities != null && !(identities instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The QuickSight users, groups, or both that you want to assign the policy to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIdentities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The QuickSight users, groups, or both that you want to assign the policy to.
     */
    public Map<String, List<String>> identities() {
        return identities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentName());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentities() ? identities() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIamPolicyAssignmentRequest)) {
            return false;
        }
        UpdateIamPolicyAssignmentRequest other = (UpdateIamPolicyAssignmentRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(assignmentName(), other.assignmentName())
                && Objects.equals(namespace(), other.namespace())
                && Objects.equals(assignmentStatusAsString(), other.assignmentStatusAsString())
                && Objects.equals(policyArn(), other.policyArn()) && hasIdentities() == other.hasIdentities()
                && Objects.equals(identities(), other.identities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateIamPolicyAssignmentRequest").add("AwsAccountId", awsAccountId())
                .add("AssignmentName", assignmentName()).add("Namespace", namespace())
                .add("AssignmentStatus", assignmentStatusAsString()).add("PolicyArn", policyArn())
                .add("Identities", hasIdentities() ? identities() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AssignmentName":
            return Optional.ofNullable(clazz.cast(assignmentName()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "AssignmentStatus":
            return Optional.ofNullable(clazz.cast(assignmentStatusAsString()));
        case "PolicyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "Identities":
            return Optional.ofNullable(clazz.cast(identities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIamPolicyAssignmentRequest, T> g) {
        return obj -> g.apply((UpdateIamPolicyAssignmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIamPolicyAssignmentRequest> {
        /**
         * <p>
         * The ID of the AWS account that contains the IAM policy assignment.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the AWS account that contains the IAM policy assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The name of the assignment, also called a rule. This name must be unique within an AWS account.
         * </p>
         * 
         * @param assignmentName
         *        The name of the assignment, also called a rule. This name must be unique within an AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentName(String assignmentName);

        /**
         * <p>
         * The namespace of the assignment.
         * </p>
         * 
         * @param namespace
         *        The namespace of the assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The status of the assignment. Possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - This assignment isn't used when creating the data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assignmentStatus
         *        The status of the assignment. Possible values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - This assignment isn't used when creating the data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data
         *        source.
         *        </p>
         *        </li>
         * @see AssignmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatus
         */
        Builder assignmentStatus(String assignmentStatus);

        /**
         * <p>
         * The status of the assignment. Possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - This assignment isn't used when creating the data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assignmentStatus
         *        The status of the assignment. Possible values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - This assignment isn't used when creating the data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data
         *        source.
         *        </p>
         *        </li>
         * @see AssignmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatus
         */
        Builder assignmentStatus(AssignmentStatus assignmentStatus);

        /**
         * <p>
         * The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment.
         * </p>
         * 
         * @param policyArn
         *        The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The QuickSight users, groups, or both that you want to assign the policy to.
         * </p>
         * 
         * @param identities
         *        The QuickSight users, groups, or both that you want to assign the policy to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(Map<String, ? extends Collection<String>> identities);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String assignmentName;

        private String namespace;

        private String assignmentStatus;

        private String policyArn;

        private Map<String, List<String>> identities = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIamPolicyAssignmentRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            assignmentName(model.assignmentName);
            namespace(model.namespace);
            assignmentStatus(model.assignmentStatus);
            policyArn(model.policyArn);
            identities(model.identities);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getAssignmentName() {
            return assignmentName;
        }

        @Override
        public final Builder assignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
            return this;
        }

        public final void setAssignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getAssignmentStatus() {
            return assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final Map<String, ? extends Collection<String>> getIdentities() {
            if (identities instanceof SdkAutoConstructMap) {
                return null;
            }
            return identities;
        }

        @Override
        public final Builder identities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
            return this;
        }

        public final void setIdentities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIamPolicyAssignmentRequest build() {
            return new UpdateIamPolicyAssignmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
