/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dashboard version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<DashboardVersion.Builder, DashboardVersion> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DashboardVersion::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<List<DashboardError>> ERRORS_FIELD = SdkField
            .<List<DashboardError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(DashboardVersion::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DashboardError> builder(MarshallingType.SDK_POJO)
                                            .constructor(DashboardError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(DashboardVersion::versionNumber)).setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DashboardVersion::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DashboardVersion::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> SOURCE_ENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceEntityArn").getter(getter(DashboardVersion::sourceEntityArn))
            .setter(setter(Builder::sourceEntityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntityArn").build()).build();

    private static final SdkField<List<String>> DATA_SET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DataSetArns")
            .getter(getter(DashboardVersion::dataSetArns))
            .setter(setter(Builder::dataSetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DashboardVersion::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> THEME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeArn").getter(getter(DashboardVersion::themeArn)).setter(setter(Builder::themeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()).build();

    private static final SdkField<List<Sheet>> SHEETS_FIELD = SdkField
            .<List<Sheet>> builder(MarshallingType.LIST)
            .memberName("Sheets")
            .getter(getter(DashboardVersion::sheets))
            .setter(setter(Builder::sheets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sheets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Sheet> builder(MarshallingType.SDK_POJO)
                                            .constructor(Sheet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD,
            ERRORS_FIELD, VERSION_NUMBER_FIELD, STATUS_FIELD, ARN_FIELD, SOURCE_ENTITY_ARN_FIELD, DATA_SET_ARNS_FIELD,
            DESCRIPTION_FIELD, THEME_ARN_FIELD, SHEETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdTime;

    private final List<DashboardError> errors;

    private final Long versionNumber;

    private final String status;

    private final String arn;

    private final String sourceEntityArn;

    private final List<String> dataSetArns;

    private final String description;

    private final String themeArn;

    private final List<Sheet> sheets;

    private DashboardVersion(BuilderImpl builder) {
        this.createdTime = builder.createdTime;
        this.errors = builder.errors;
        this.versionNumber = builder.versionNumber;
        this.status = builder.status;
        this.arn = builder.arn;
        this.sourceEntityArn = builder.sourceEntityArn;
        this.dataSetArns = builder.dataSetArns;
        this.description = builder.description;
        this.themeArn = builder.themeArn;
        this.sheets = builder.sheets;
    }

    /**
     * <p>
     * The time that this dashboard version was created.
     * </p>
     * 
     * @return The time that this dashboard version was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Errors associated with this dashboard version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Errors associated with this dashboard version.
     */
    public List<DashboardError> errors() {
        return errors;
    }

    /**
     * <p>
     * Version number for this version of the dashboard.
     * </p>
     * 
     * @return Version number for this version of the dashboard.
     */
    public Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The HTTP status of the request.
     * @see ResourceStatus
     */
    public ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The HTTP status of the request.
     * @see ResourceStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * Source entity ARN.
     * </p>
     * 
     * @return Source entity ARN.
     */
    public String sourceEntityArn() {
        return sourceEntityArn;
    }

    /**
     * Returns true if the DataSetArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDataSetArns() {
        return dataSetArns != null && !(dataSetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Numbers (ARNs) for the datasets that are associated with this version of the dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDataSetArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Numbers (ARNs) for the datasets that are associated with this version of the
     *         dashboard.
     */
    public List<String> dataSetArns() {
        return dataSetArns;
    }

    /**
     * <p>
     * Description.
     * </p>
     * 
     * @return Description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the theme associated with a version of the dashboard.
     * </p>
     * 
     * @return The ARN of the theme associated with a version of the dashboard.
     */
    public String themeArn() {
        return themeArn;
    }

    /**
     * Returns true if the Sheets property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSheets() {
        return sheets != null && !(sheets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the associated sheets with the unique identifier and name of each sheet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSheets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the associated sheets with the unique identifier and name of each sheet.
     */
    public List<Sheet> sheets() {
        return sheets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEntityArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSetArns() ? dataSetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSheets() ? sheets() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardVersion)) {
            return false;
        }
        DashboardVersion other = (DashboardVersion) obj;
        return Objects.equals(createdTime(), other.createdTime()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors()) && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(arn(), other.arn())
                && Objects.equals(sourceEntityArn(), other.sourceEntityArn()) && hasDataSetArns() == other.hasDataSetArns()
                && Objects.equals(dataSetArns(), other.dataSetArns()) && Objects.equals(description(), other.description())
                && Objects.equals(themeArn(), other.themeArn()) && hasSheets() == other.hasSheets()
                && Objects.equals(sheets(), other.sheets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DashboardVersion").add("CreatedTime", createdTime())
                .add("Errors", hasErrors() ? errors() : null).add("VersionNumber", versionNumber())
                .add("Status", statusAsString()).add("Arn", arn()).add("SourceEntityArn", sourceEntityArn())
                .add("DataSetArns", hasDataSetArns() ? dataSetArns() : null).add("Description", description())
                .add("ThemeArn", themeArn()).add("Sheets", hasSheets() ? sheets() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "SourceEntityArn":
            return Optional.ofNullable(clazz.cast(sourceEntityArn()));
        case "DataSetArns":
            return Optional.ofNullable(clazz.cast(dataSetArns()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ThemeArn":
            return Optional.ofNullable(clazz.cast(themeArn()));
        case "Sheets":
            return Optional.ofNullable(clazz.cast(sheets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardVersion, T> g) {
        return obj -> g.apply((DashboardVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardVersion> {
        /**
         * <p>
         * The time that this dashboard version was created.
         * </p>
         * 
         * @param createdTime
         *        The time that this dashboard version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * Errors associated with this dashboard version.
         * </p>
         * 
         * @param errors
         *        Errors associated with this dashboard version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<DashboardError> errors);

        /**
         * <p>
         * Errors associated with this dashboard version.
         * </p>
         * 
         * @param errors
         *        Errors associated with this dashboard version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(DashboardError... errors);

        /**
         * <p>
         * Errors associated with this dashboard version.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DashboardError>.Builder} avoiding the need
         * to create one manually via {@link List<DashboardError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DashboardError>.Builder#build()} is called immediately and
         * its result is passed to {@link #errors(List<DashboardError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<DashboardError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<DashboardError>)
         */
        Builder errors(Consumer<DashboardError.Builder>... errors);

        /**
         * <p>
         * Version number for this version of the dashboard.
         * </p>
         * 
         * @param versionNumber
         *        Version number for this version of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Source entity ARN.
         * </p>
         * 
         * @param sourceEntityArn
         *        Source entity ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEntityArn(String sourceEntityArn);

        /**
         * <p>
         * The Amazon Resource Numbers (ARNs) for the datasets that are associated with this version of the dashboard.
         * </p>
         * 
         * @param dataSetArns
         *        The Amazon Resource Numbers (ARNs) for the datasets that are associated with this version of the
         *        dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetArns(Collection<String> dataSetArns);

        /**
         * <p>
         * The Amazon Resource Numbers (ARNs) for the datasets that are associated with this version of the dashboard.
         * </p>
         * 
         * @param dataSetArns
         *        The Amazon Resource Numbers (ARNs) for the datasets that are associated with this version of the
         *        dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetArns(String... dataSetArns);

        /**
         * <p>
         * Description.
         * </p>
         * 
         * @param description
         *        Description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the theme associated with a version of the dashboard.
         * </p>
         * 
         * @param themeArn
         *        The ARN of the theme associated with a version of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeArn(String themeArn);

        /**
         * <p>
         * A list of the associated sheets with the unique identifier and name of each sheet.
         * </p>
         * 
         * @param sheets
         *        A list of the associated sheets with the unique identifier and name of each sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheets(Collection<Sheet> sheets);

        /**
         * <p>
         * A list of the associated sheets with the unique identifier and name of each sheet.
         * </p>
         * 
         * @param sheets
         *        A list of the associated sheets with the unique identifier and name of each sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheets(Sheet... sheets);

        /**
         * <p>
         * A list of the associated sheets with the unique identifier and name of each sheet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Sheet>.Builder} avoiding the need to create
         * one manually via {@link List<Sheet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Sheet>.Builder#build()} is called immediately and its result
         * is passed to {@link #sheets(List<Sheet>)}.
         * 
         * @param sheets
         *        a consumer that will call methods on {@link List<Sheet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sheets(List<Sheet>)
         */
        Builder sheets(Consumer<Sheet.Builder>... sheets);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdTime;

        private List<DashboardError> errors = DefaultSdkAutoConstructList.getInstance();

        private Long versionNumber;

        private String status;

        private String arn;

        private String sourceEntityArn;

        private List<String> dataSetArns = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String themeArn;

        private List<Sheet> sheets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardVersion model) {
            createdTime(model.createdTime);
            errors(model.errors);
            versionNumber(model.versionNumber);
            status(model.status);
            arn(model.arn);
            sourceEntityArn(model.sourceEntityArn);
            dataSetArns(model.dataSetArns);
            description(model.description);
            themeArn(model.themeArn);
            sheets(model.sheets);
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Collection<DashboardError.Builder> getErrors() {
            if (errors instanceof SdkAutoConstructList) {
                return null;
            }
            return errors != null ? errors.stream().map(DashboardError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<DashboardError> errors) {
            this.errors = DashboardErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(DashboardError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<DashboardError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> DashboardError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<DashboardError.BuilderImpl> errors) {
            this.errors = DashboardErrorListCopier.copyFromBuilder(errors);
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSourceEntityArn() {
            return sourceEntityArn;
        }

        @Override
        public final Builder sourceEntityArn(String sourceEntityArn) {
            this.sourceEntityArn = sourceEntityArn;
            return this;
        }

        public final void setSourceEntityArn(String sourceEntityArn) {
            this.sourceEntityArn = sourceEntityArn;
        }

        public final Collection<String> getDataSetArns() {
            if (dataSetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return dataSetArns;
        }

        @Override
        public final Builder dataSetArns(Collection<String> dataSetArns) {
            this.dataSetArns = DataSetArnsListCopier.copy(dataSetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetArns(String... dataSetArns) {
            dataSetArns(Arrays.asList(dataSetArns));
            return this;
        }

        public final void setDataSetArns(Collection<String> dataSetArns) {
            this.dataSetArns = DataSetArnsListCopier.copy(dataSetArns);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getThemeArn() {
            return themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        public final Collection<Sheet.Builder> getSheets() {
            if (sheets instanceof SdkAutoConstructList) {
                return null;
            }
            return sheets != null ? sheets.stream().map(Sheet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sheets(Collection<Sheet> sheets) {
            this.sheets = SheetListCopier.copy(sheets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(Sheet... sheets) {
            sheets(Arrays.asList(sheets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(Consumer<Sheet.Builder>... sheets) {
            sheets(Stream.of(sheets).map(c -> Sheet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSheets(Collection<Sheet.BuilderImpl> sheets) {
            this.sheets = SheetListCopier.copyFromBuilder(sheets);
        }

        @Override
        public DashboardVersion build() {
            return new DashboardVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
