/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <i>sheet</i>, which is an object that contains a set of visuals that are viewed together on one page in the Amazon
 * QuickSight console. Every analysis and dashboard contains at least one sheet. Each sheet contains at least one
 * visualization widget, for example a chart, pivot table, or narrative insight. Sheets can be associated with other
 * components, such as controls, filters, and so on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Sheet implements SdkPojo, Serializable, ToCopyableBuilder<Sheet.Builder, Sheet> {
    private static final SdkField<String> SHEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SheetId").getter(getter(Sheet::sheetId)).setter(setter(Builder::sheetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Sheet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_ID_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sheetId;

    private final String name;

    private Sheet(BuilderImpl builder) {
        this.sheetId = builder.sheetId;
        this.name = builder.name;
    }

    /**
     * <p>
     * The unique identifier associated with a sheet.
     * </p>
     * 
     * @return The unique identifier associated with a sheet.
     */
    public String sheetId() {
        return sheetId;
    }

    /**
     * <p>
     * The name of a sheet. This name is displayed on the sheet's tab in the QuickSight console.
     * </p>
     * 
     * @return The name of a sheet. This name is displayed on the sheet's tab in the QuickSight console.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sheetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sheet)) {
            return false;
        }
        Sheet other = (Sheet) obj;
        return Objects.equals(sheetId(), other.sheetId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Sheet").add("SheetId", sheetId()).add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SheetId":
            return Optional.ofNullable(clazz.cast(sheetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Sheet, T> g) {
        return obj -> g.apply((Sheet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Sheet> {
        /**
         * <p>
         * The unique identifier associated with a sheet.
         * </p>
         * 
         * @param sheetId
         *        The unique identifier associated with a sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetId(String sheetId);

        /**
         * <p>
         * The name of a sheet. This name is displayed on the sheet's tab in the QuickSight console.
         * </p>
         * 
         * @param name
         *        The name of a sheet. This name is displayed on the sheet's tab in the QuickSight console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String sheetId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Sheet model) {
            sheetId(model.sheetId);
            name(model.name);
        }

        public final String getSheetId() {
            return sheetId;
        }

        @Override
        public final Builder sheetId(String sheetId) {
            this.sheetId = sheetId;
            return this;
        }

        public final void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Sheet build() {
            return new Sheet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
