/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataSourceResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeDataSourceResponse.Builder, DescribeDataSourceResponse> {
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(DescribeDataSourceResponse::dataSource)).setter(setter(Builder::dataSource))
            .constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeDataSourceResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeDataSourceResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            REQUEST_ID_FIELD, STATUS_FIELD));

    private final DataSource dataSource;

    private final String requestId;

    private final Integer status;

    private DescribeDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.dataSource = builder.dataSource;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The information on the data source.
     * </p>
     * 
     * @return The information on the data source.
     */
    public DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSourceResponse)) {
            return false;
        }
        DescribeDataSourceResponse other = (DescribeDataSourceResponse) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDataSourceResponse").add("DataSource", dataSource()).add("RequestId", requestId())
                .add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataSourceResponse, T> g) {
        return obj -> g.apply((DescribeDataSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDataSourceResponse> {
        /**
         * <p>
         * The information on the data source.
         * </p>
         * 
         * @param dataSource
         *        The information on the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The information on the data source.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSource.Builder} avoiding the need to create
         * one manually via {@link DataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private DataSource dataSource;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSourceResponse model) {
            super(model);
            dataSource(model.dataSource);
            requestId(model.requestId);
            status(model.status);
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public DescribeDataSourceResponse build() {
            return new DescribeDataSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
