/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIamPolicyAssignmentsResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListIamPolicyAssignmentsResponse.Builder, ListIamPolicyAssignmentsResponse> {
    private static final SdkField<List<IAMPolicyAssignmentSummary>> IAM_POLICY_ASSIGNMENTS_FIELD = SdkField
            .<List<IAMPolicyAssignmentSummary>> builder(MarshallingType.LIST)
            .memberName("IAMPolicyAssignments")
            .getter(getter(ListIamPolicyAssignmentsResponse::iamPolicyAssignments))
            .setter(setter(Builder::iamPolicyAssignments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMPolicyAssignments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IAMPolicyAssignmentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IAMPolicyAssignmentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIamPolicyAssignmentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ListIamPolicyAssignmentsResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(ListIamPolicyAssignmentsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_POLICY_ASSIGNMENTS_FIELD,
            NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final List<IAMPolicyAssignmentSummary> iamPolicyAssignments;

    private final String nextToken;

    private final String requestId;

    private final Integer status;

    private ListIamPolicyAssignmentsResponse(BuilderImpl builder) {
        super(builder);
        this.iamPolicyAssignments = builder.iamPolicyAssignments;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * Returns true if the IAMPolicyAssignments property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasIamPolicyAssignments() {
        return iamPolicyAssignments != null && !(iamPolicyAssignments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information describing the IAM policy assignments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIamPolicyAssignments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information describing the IAM policy assignments.
     */
    public List<IAMPolicyAssignmentSummary> iamPolicyAssignments() {
        return iamPolicyAssignments;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIamPolicyAssignments() ? iamPolicyAssignments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIamPolicyAssignmentsResponse)) {
            return false;
        }
        ListIamPolicyAssignmentsResponse other = (ListIamPolicyAssignmentsResponse) obj;
        return hasIamPolicyAssignments() == other.hasIamPolicyAssignments()
                && Objects.equals(iamPolicyAssignments(), other.iamPolicyAssignments())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListIamPolicyAssignmentsResponse")
                .add("IAMPolicyAssignments", hasIamPolicyAssignments() ? iamPolicyAssignments() : null)
                .add("NextToken", nextToken()).add("RequestId", requestId()).add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IAMPolicyAssignments":
            return Optional.ofNullable(clazz.cast(iamPolicyAssignments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIamPolicyAssignmentsResponse, T> g) {
        return obj -> g.apply((ListIamPolicyAssignmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIamPolicyAssignmentsResponse> {
        /**
         * <p>
         * Information describing the IAM policy assignments.
         * </p>
         * 
         * @param iamPolicyAssignments
         *        Information describing the IAM policy assignments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamPolicyAssignments(Collection<IAMPolicyAssignmentSummary> iamPolicyAssignments);

        /**
         * <p>
         * Information describing the IAM policy assignments.
         * </p>
         * 
         * @param iamPolicyAssignments
         *        Information describing the IAM policy assignments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamPolicyAssignments(IAMPolicyAssignmentSummary... iamPolicyAssignments);

        /**
         * <p>
         * Information describing the IAM policy assignments.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IAMPolicyAssignmentSummary>.Builder}
         * avoiding the need to create one manually via {@link List<IAMPolicyAssignmentSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IAMPolicyAssignmentSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #iamPolicyAssignments(List<IAMPolicyAssignmentSummary>)}.
         * 
         * @param iamPolicyAssignments
         *        a consumer that will call methods on {@link List<IAMPolicyAssignmentSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamPolicyAssignments(List<IAMPolicyAssignmentSummary>)
         */
        Builder iamPolicyAssignments(Consumer<IAMPolicyAssignmentSummary.Builder>... iamPolicyAssignments);

        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<IAMPolicyAssignmentSummary> iamPolicyAssignments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIamPolicyAssignmentsResponse model) {
            super(model);
            iamPolicyAssignments(model.iamPolicyAssignments);
            nextToken(model.nextToken);
            requestId(model.requestId);
            status(model.status);
        }

        public final Collection<IAMPolicyAssignmentSummary.Builder> getIamPolicyAssignments() {
            if (iamPolicyAssignments instanceof SdkAutoConstructList) {
                return null;
            }
            return iamPolicyAssignments != null ? iamPolicyAssignments.stream().map(IAMPolicyAssignmentSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder iamPolicyAssignments(Collection<IAMPolicyAssignmentSummary> iamPolicyAssignments) {
            this.iamPolicyAssignments = IAMPolicyAssignmentSummaryListCopier.copy(iamPolicyAssignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamPolicyAssignments(IAMPolicyAssignmentSummary... iamPolicyAssignments) {
            iamPolicyAssignments(Arrays.asList(iamPolicyAssignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamPolicyAssignments(Consumer<IAMPolicyAssignmentSummary.Builder>... iamPolicyAssignments) {
            iamPolicyAssignments(Stream.of(iamPolicyAssignments)
                    .map(c -> IAMPolicyAssignmentSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIamPolicyAssignments(Collection<IAMPolicyAssignmentSummary.BuilderImpl> iamPolicyAssignments) {
            this.iamPolicyAssignments = IAMPolicyAssignmentSummaryListCopier.copyFromBuilder(iamPolicyAssignments);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public ListIamPolicyAssignmentsResponse build() {
            return new ListIamPolicyAssignmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
