/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.JoinInstruction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogicalTableSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogicalTableSource> {
    private static final SdkField<JoinInstruction> JOIN_INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JoinInstruction").getter(LogicalTableSource.getter(LogicalTableSource::joinInstruction)).setter(LogicalTableSource.setter(Builder::joinInstruction)).constructor(JoinInstruction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinInstruction").build()}).build();
    private static final SdkField<String> PHYSICAL_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhysicalTableId").getter(LogicalTableSource.getter(LogicalTableSource::physicalTableId)).setter(LogicalTableSource.setter(Builder::physicalTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalTableId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOIN_INSTRUCTION_FIELD, PHYSICAL_TABLE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final JoinInstruction joinInstruction;
    private final String physicalTableId;

    private LogicalTableSource(BuilderImpl builder) {
        this.joinInstruction = builder.joinInstruction;
        this.physicalTableId = builder.physicalTableId;
    }

    public JoinInstruction joinInstruction() {
        return this.joinInstruction;
    }

    public String physicalTableId() {
        return this.physicalTableId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.joinInstruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalTableId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogicalTableSource)) {
            return false;
        }
        LogicalTableSource other = (LogicalTableSource)obj;
        return Objects.equals(this.joinInstruction(), other.joinInstruction()) && Objects.equals(this.physicalTableId(), other.physicalTableId());
    }

    public String toString() {
        return ToString.builder((String)"LogicalTableSource").add("JoinInstruction", (Object)this.joinInstruction()).add("PhysicalTableId", (Object)this.physicalTableId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JoinInstruction": {
                return Optional.ofNullable(clazz.cast(this.joinInstruction()));
            }
            case "PhysicalTableId": {
                return Optional.ofNullable(clazz.cast(this.physicalTableId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogicalTableSource, T> g) {
        return obj -> g.apply((LogicalTableSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JoinInstruction joinInstruction;
        private String physicalTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(LogicalTableSource model) {
            this.joinInstruction(model.joinInstruction);
            this.physicalTableId(model.physicalTableId);
        }

        public final JoinInstruction.Builder getJoinInstruction() {
            return this.joinInstruction != null ? this.joinInstruction.toBuilder() : null;
        }

        @Override
        public final Builder joinInstruction(JoinInstruction joinInstruction) {
            this.joinInstruction = joinInstruction;
            return this;
        }

        public final void setJoinInstruction(JoinInstruction.BuilderImpl joinInstruction) {
            this.joinInstruction = joinInstruction != null ? joinInstruction.build() : null;
        }

        public final String getPhysicalTableId() {
            return this.physicalTableId;
        }

        @Override
        public final Builder physicalTableId(String physicalTableId) {
            this.physicalTableId = physicalTableId;
            return this;
        }

        public final void setPhysicalTableId(String physicalTableId) {
            this.physicalTableId = physicalTableId;
        }

        public LogicalTableSource build() {
            return new LogicalTableSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogicalTableSource> {
        public Builder joinInstruction(JoinInstruction var1);

        default public Builder joinInstruction(Consumer<JoinInstruction.Builder> joinInstruction) {
            return this.joinInstruction((JoinInstruction)((JoinInstruction.Builder)JoinInstruction.builder().applyMutation(joinInstruction)).build());
        }

        public Builder physicalTableId(String var1);
    }
}

