/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIamPolicyAssignmentsForUserResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListIamPolicyAssignmentsForUserResponse.Builder, ListIamPolicyAssignmentsForUserResponse> {
    private static final SdkField<List<ActiveIAMPolicyAssignment>> ACTIVE_ASSIGNMENTS_FIELD = SdkField
            .<List<ActiveIAMPolicyAssignment>> builder(MarshallingType.LIST)
            .memberName("ActiveAssignments")
            .getter(getter(ListIamPolicyAssignmentsForUserResponse::activeAssignments))
            .setter(setter(Builder::activeAssignments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveAssignments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActiveIAMPolicyAssignment> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActiveIAMPolicyAssignment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ListIamPolicyAssignmentsForUserResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIamPolicyAssignmentsForUserResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(ListIamPolicyAssignmentsForUserResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_ASSIGNMENTS_FIELD,
            REQUEST_ID_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD));

    private final List<ActiveIAMPolicyAssignment> activeAssignments;

    private final String requestId;

    private final String nextToken;

    private final Integer status;

    private ListIamPolicyAssignmentsForUserResponse(BuilderImpl builder) {
        super(builder);
        this.activeAssignments = builder.activeAssignments;
        this.requestId = builder.requestId;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
    }

    /**
     * Returns true if the ActiveAssignments property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasActiveAssignments() {
        return activeAssignments != null && !(activeAssignments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The active assignments for this user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActiveAssignments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The active assignments for this user.
     */
    public List<ActiveIAMPolicyAssignment> activeAssignments() {
        return activeAssignments;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActiveAssignments() ? activeAssignments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIamPolicyAssignmentsForUserResponse)) {
            return false;
        }
        ListIamPolicyAssignmentsForUserResponse other = (ListIamPolicyAssignmentsForUserResponse) obj;
        return hasActiveAssignments() == other.hasActiveAssignments()
                && Objects.equals(activeAssignments(), other.activeAssignments())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListIamPolicyAssignmentsForUserResponse")
                .add("ActiveAssignments", hasActiveAssignments() ? activeAssignments() : null).add("RequestId", requestId())
                .add("NextToken", nextToken()).add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveAssignments":
            return Optional.ofNullable(clazz.cast(activeAssignments()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIamPolicyAssignmentsForUserResponse, T> g) {
        return obj -> g.apply((ListIamPolicyAssignmentsForUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIamPolicyAssignmentsForUserResponse> {
        /**
         * <p>
         * The active assignments for this user.
         * </p>
         * 
         * @param activeAssignments
         *        The active assignments for this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeAssignments(Collection<ActiveIAMPolicyAssignment> activeAssignments);

        /**
         * <p>
         * The active assignments for this user.
         * </p>
         * 
         * @param activeAssignments
         *        The active assignments for this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeAssignments(ActiveIAMPolicyAssignment... activeAssignments);

        /**
         * <p>
         * The active assignments for this user.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ActiveIAMPolicyAssignment>.Builder}
         * avoiding the need to create one manually via {@link List<ActiveIAMPolicyAssignment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ActiveIAMPolicyAssignment>.Builder#build()} is called
         * immediately and its result is passed to {@link #activeAssignments(List<ActiveIAMPolicyAssignment>)}.
         * 
         * @param activeAssignments
         *        a consumer that will call methods on {@link List<ActiveIAMPolicyAssignment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeAssignments(List<ActiveIAMPolicyAssignment>)
         */
        Builder activeAssignments(Consumer<ActiveIAMPolicyAssignment.Builder>... activeAssignments);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<ActiveIAMPolicyAssignment> activeAssignments = DefaultSdkAutoConstructList.getInstance();

        private String requestId;

        private String nextToken;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIamPolicyAssignmentsForUserResponse model) {
            super(model);
            activeAssignments(model.activeAssignments);
            requestId(model.requestId);
            nextToken(model.nextToken);
            status(model.status);
        }

        public final Collection<ActiveIAMPolicyAssignment.Builder> getActiveAssignments() {
            if (activeAssignments instanceof SdkAutoConstructList) {
                return null;
            }
            return activeAssignments != null ? activeAssignments.stream().map(ActiveIAMPolicyAssignment::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activeAssignments(Collection<ActiveIAMPolicyAssignment> activeAssignments) {
            this.activeAssignments = ActiveIAMPolicyAssignmentListCopier.copy(activeAssignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeAssignments(ActiveIAMPolicyAssignment... activeAssignments) {
            activeAssignments(Arrays.asList(activeAssignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeAssignments(Consumer<ActiveIAMPolicyAssignment.Builder>... activeAssignments) {
            activeAssignments(Stream.of(activeAssignments).map(c -> ActiveIAMPolicyAssignment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActiveAssignments(Collection<ActiveIAMPolicyAssignment.BuilderImpl> activeAssignments) {
            this.activeAssignments = ActiveIAMPolicyAssignmentListCopier.copyFromBuilder(activeAssignments);
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public ListIamPolicyAssignmentsForUserResponse build() {
            return new ListIamPolicyAssignmentsForUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
