/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;
import software.amazon.awssdk.services.quicksight.model.ResourcePermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDashboardPermissionsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateDashboardPermissionsResponse> {
    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardArn").getter(UpdateDashboardPermissionsResponse.getter(UpdateDashboardPermissionsResponse::dashboardArn)).setter(UpdateDashboardPermissionsResponse.setter(Builder::dashboardArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()}).build();
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(UpdateDashboardPermissionsResponse.getter(UpdateDashboardPermissionsResponse::dashboardId)).setter(UpdateDashboardPermissionsResponse.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()}).build();
    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(UpdateDashboardPermissionsResponse.getter(UpdateDashboardPermissionsResponse::permissions)).setter(UpdateDashboardPermissionsResponse.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateDashboardPermissionsResponse.getter(UpdateDashboardPermissionsResponse::requestId)).setter(UpdateDashboardPermissionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(UpdateDashboardPermissionsResponse.getter(UpdateDashboardPermissionsResponse::status)).setter(UpdateDashboardPermissionsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ARN_FIELD, DASHBOARD_ID_FIELD, PERMISSIONS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final String dashboardArn;
    private final String dashboardId;
    private final List<ResourcePermission> permissions;
    private final String requestId;
    private final Integer status;

    private UpdateDashboardPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardArn = builder.dashboardArn;
        this.dashboardId = builder.dashboardId;
        this.permissions = builder.permissions;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public String dashboardArn() {
        return this.dashboardArn;
    }

    public String dashboardId() {
        return this.dashboardId;
    }

    public boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public List<ResourcePermission> permissions() {
        return this.permissions;
    }

    public String requestId() {
        return this.requestId;
    }

    public Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardPermissionsResponse)) {
            return false;
        }
        UpdateDashboardPermissionsResponse other = (UpdateDashboardPermissionsResponse)((Object)obj);
        return Objects.equals(this.dashboardArn(), other.dashboardArn()) && Objects.equals(this.dashboardId(), other.dashboardId()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDashboardPermissionsResponse").add("DashboardArn", (Object)this.dashboardArn()).add("DashboardId", (Object)this.dashboardId()).add("Permissions", this.hasPermissions() ? this.permissions() : null).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardArn": {
                return Optional.ofNullable(clazz.cast(this.dashboardArn()));
            }
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardPermissionsResponse, T> g) {
        return obj -> g.apply((UpdateDashboardPermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String dashboardArn;
        private String dashboardId;
        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardPermissionsResponse model) {
            super(model);
            this.dashboardArn(model.dashboardArn);
            this.dashboardId(model.dashboardId);
            this.permissions(model.permissions);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getDashboardArn() {
            return this.dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        public final Collection<ResourcePermission.Builder> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions != null ? (Collection)this.permissions.stream().map(ResourcePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder> ... permissions) {
            this.permissions(Stream.of(permissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public UpdateDashboardPermissionsResponse build() {
            return new UpdateDashboardPermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDashboardPermissionsResponse> {
        public Builder dashboardArn(String var1);

        public Builder dashboardId(String var1);

        public Builder permissions(Collection<ResourcePermission> var1);

        public Builder permissions(ResourcePermission ... var1);

        public Builder permissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

