/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source analysis of the template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateSourceAnalysis implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateSourceAnalysis.Builder, TemplateSourceAnalysis> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(TemplateSourceAnalysis::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<List<DataSetReference>> DATA_SET_REFERENCES_FIELD = SdkField
            .<List<DataSetReference>> builder(MarshallingType.LIST)
            .memberName("DataSetReferences")
            .getter(getter(TemplateSourceAnalysis::dataSetReferences))
            .setter(setter(Builder::dataSetReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSetReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSetReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            DATA_SET_REFERENCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<DataSetReference> dataSetReferences;

    private TemplateSourceAnalysis(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dataSetReferences = builder.dataSetReferences;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public String arn() {
        return arn;
    }

    /**
     * Returns true if the DataSetReferences property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDataSetReferences() {
        return dataSetReferences != null && !(dataSetReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure containing information about the dataset references used as placeholders in the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDataSetReferences()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A structure containing information about the dataset references used as placeholders in the template.
     */
    public List<DataSetReference> dataSetReferences() {
        return dataSetReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSetReferences() ? dataSetReferences() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateSourceAnalysis)) {
            return false;
        }
        TemplateSourceAnalysis other = (TemplateSourceAnalysis) obj;
        return Objects.equals(arn(), other.arn()) && hasDataSetReferences() == other.hasDataSetReferences()
                && Objects.equals(dataSetReferences(), other.dataSetReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TemplateSourceAnalysis").add("Arn", arn())
                .add("DataSetReferences", hasDataSetReferences() ? dataSetReferences() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DataSetReferences":
            return Optional.ofNullable(clazz.cast(dataSetReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateSourceAnalysis, T> g) {
        return obj -> g.apply((TemplateSourceAnalysis) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateSourceAnalysis> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A structure containing information about the dataset references used as placeholders in the template.
         * </p>
         * 
         * @param dataSetReferences
         *        A structure containing information about the dataset references used as placeholders in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetReferences(Collection<DataSetReference> dataSetReferences);

        /**
         * <p>
         * A structure containing information about the dataset references used as placeholders in the template.
         * </p>
         * 
         * @param dataSetReferences
         *        A structure containing information about the dataset references used as placeholders in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetReferences(DataSetReference... dataSetReferences);

        /**
         * <p>
         * A structure containing information about the dataset references used as placeholders in the template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSetReference>.Builder} avoiding the
         * need to create one manually via {@link List<DataSetReference>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSetReference>.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSetReferences(List<DataSetReference>)}.
         * 
         * @param dataSetReferences
         *        a consumer that will call methods on {@link List<DataSetReference>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSetReferences(List<DataSetReference>)
         */
        Builder dataSetReferences(Consumer<DataSetReference.Builder>... dataSetReferences);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<DataSetReference> dataSetReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateSourceAnalysis model) {
            arn(model.arn);
            dataSetReferences(model.dataSetReferences);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<DataSetReference.Builder> getDataSetReferences() {
            if (dataSetReferences instanceof SdkAutoConstructList) {
                return null;
            }
            return dataSetReferences != null ? dataSetReferences.stream().map(DataSetReference::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSetReferences(Collection<DataSetReference> dataSetReferences) {
            this.dataSetReferences = DataSetReferenceListCopier.copy(dataSetReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetReferences(DataSetReference... dataSetReferences) {
            dataSetReferences(Arrays.asList(dataSetReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetReferences(Consumer<DataSetReference.Builder>... dataSetReferences) {
            dataSetReferences(Stream.of(dataSetReferences).map(c -> DataSetReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDataSetReferences(Collection<DataSetReference.BuilderImpl> dataSetReferences) {
            this.dataSetReferences = DataSetReferenceListCopier.copyFromBuilder(dataSetReferences);
        }

        @Override
        public TemplateSourceAnalysis build() {
            return new TemplateSourceAnalysis(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
