/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataSourcePermissionsRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateDataSourcePermissionsRequest.Builder, UpdateDataSourcePermissionsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateDataSourcePermissionsRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(UpdateDataSourcePermissionsRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSourceId").build()).build();

    private static final SdkField<List<ResourcePermission>> GRANT_PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("GrantPermissions")
            .getter(getter(UpdateDataSourcePermissionsRequest::grantPermissions))
            .setter(setter(Builder::grantPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourcePermission>> REVOKE_PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("RevokePermissions")
            .getter(getter(UpdateDataSourcePermissionsRequest::revokePermissions))
            .setter(setter(Builder::revokePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokePermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DATA_SOURCE_ID_FIELD, GRANT_PERMISSIONS_FIELD, REVOKE_PERMISSIONS_FIELD));

    private final String awsAccountId;

    private final String dataSourceId;

    private final List<ResourcePermission> grantPermissions;

    private final List<ResourcePermission> revokePermissions;

    private UpdateDataSourcePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dataSourceId = builder.dataSourceId;
        this.grantPermissions = builder.grantPermissions;
        this.revokePermissions = builder.revokePermissions;
    }

    /**
     * <p>
     * The AWS account ID.
     * </p>
     * 
     * @return The AWS account ID.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the data source. This ID is unique per AWS Region for each AWS account.
     * </p>
     * 
     * @return The ID of the data source. This ID is unique per AWS Region for each AWS account.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * Returns true if the GrantPermissions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasGrantPermissions() {
        return grantPermissions != null && !(grantPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource permissions that you want to grant on the data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGrantPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of resource permissions that you want to grant on the data source.
     */
    public final List<ResourcePermission> grantPermissions() {
        return grantPermissions;
    }

    /**
     * Returns true if the RevokePermissions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRevokePermissions() {
        return revokePermissions != null && !(revokePermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource permissions that you want to revoke on the data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRevokePermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of resource permissions that you want to revoke on the data source.
     */
    public final List<ResourcePermission> revokePermissions() {
        return revokePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasGrantPermissions() ? grantPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRevokePermissions() ? revokePermissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourcePermissionsRequest)) {
            return false;
        }
        UpdateDataSourcePermissionsRequest other = (UpdateDataSourcePermissionsRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && hasGrantPermissions() == other.hasGrantPermissions()
                && Objects.equals(grantPermissions(), other.grantPermissions())
                && hasRevokePermissions() == other.hasRevokePermissions()
                && Objects.equals(revokePermissions(), other.revokePermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataSourcePermissionsRequest").add("AwsAccountId", awsAccountId())
                .add("DataSourceId", dataSourceId()).add("GrantPermissions", hasGrantPermissions() ? grantPermissions() : null)
                .add("RevokePermissions", hasRevokePermissions() ? revokePermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "GrantPermissions":
            return Optional.ofNullable(clazz.cast(grantPermissions()));
        case "RevokePermissions":
            return Optional.ofNullable(clazz.cast(revokePermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourcePermissionsRequest, T> g) {
        return obj -> g.apply((UpdateDataSourcePermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDataSourcePermissionsRequest> {
        /**
         * <p>
         * The AWS account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the data source. This ID is unique per AWS Region for each AWS account.
         * </p>
         * 
         * @param dataSourceId
         *        The ID of the data source. This ID is unique per AWS Region for each AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * A list of resource permissions that you want to grant on the data source.
         * </p>
         * 
         * @param grantPermissions
         *        A list of resource permissions that you want to grant on the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantPermissions(Collection<ResourcePermission> grantPermissions);

        /**
         * <p>
         * A list of resource permissions that you want to grant on the data source.
         * </p>
         * 
         * @param grantPermissions
         *        A list of resource permissions that you want to grant on the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantPermissions(ResourcePermission... grantPermissions);

        /**
         * <p>
         * A list of resource permissions that you want to grant on the data source.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #grantPermissions(List<ResourcePermission>)}.
         * 
         * @param grantPermissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grantPermissions(List<ResourcePermission>)
         */
        Builder grantPermissions(Consumer<ResourcePermission.Builder>... grantPermissions);

        /**
         * <p>
         * A list of resource permissions that you want to revoke on the data source.
         * </p>
         * 
         * @param revokePermissions
         *        A list of resource permissions that you want to revoke on the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokePermissions(Collection<ResourcePermission> revokePermissions);

        /**
         * <p>
         * A list of resource permissions that you want to revoke on the data source.
         * </p>
         * 
         * @param revokePermissions
         *        A list of resource permissions that you want to revoke on the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokePermissions(ResourcePermission... revokePermissions);

        /**
         * <p>
         * A list of resource permissions that you want to revoke on the data source.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #revokePermissions(List<ResourcePermission>)}.
         * 
         * @param revokePermissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revokePermissions(List<ResourcePermission>)
         */
        Builder revokePermissions(Consumer<ResourcePermission.Builder>... revokePermissions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dataSourceId;

        private List<ResourcePermission> grantPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<ResourcePermission> revokePermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourcePermissionsRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dataSourceId(model.dataSourceId);
            grantPermissions(model.grantPermissions);
            revokePermissions(model.revokePermissions);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final Collection<ResourcePermission.Builder> getGrantPermissions() {
            if (grantPermissions instanceof SdkAutoConstructList) {
                return null;
            }
            return grantPermissions != null ? grantPermissions.stream().map(ResourcePermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder grantPermissions(Collection<ResourcePermission> grantPermissions) {
            this.grantPermissions = ResourcePermissionListCopier.copy(grantPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(ResourcePermission... grantPermissions) {
            grantPermissions(Arrays.asList(grantPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(Consumer<ResourcePermission.Builder>... grantPermissions) {
            grantPermissions(Stream.of(grantPermissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGrantPermissions(Collection<ResourcePermission.BuilderImpl> grantPermissions) {
            this.grantPermissions = ResourcePermissionListCopier.copyFromBuilder(grantPermissions);
        }

        public final Collection<ResourcePermission.Builder> getRevokePermissions() {
            if (revokePermissions instanceof SdkAutoConstructList) {
                return null;
            }
            return revokePermissions != null ? revokePermissions.stream().map(ResourcePermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revokePermissions(Collection<ResourcePermission> revokePermissions) {
            this.revokePermissions = ResourcePermissionListCopier.copy(revokePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(ResourcePermission... revokePermissions) {
            revokePermissions(Arrays.asList(revokePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(Consumer<ResourcePermission.Builder>... revokePermissions) {
            revokePermissions(Stream.of(revokePermissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRevokePermissions(Collection<ResourcePermission.BuilderImpl> revokePermissions) {
            this.revokePermissions = ResourcePermissionListCopier.copyFromBuilder(revokePermissions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSourcePermissionsRequest build() {
            return new UpdateDataSourcePermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
