/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A physical table type for relational data sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelationalTable implements SdkPojo, Serializable, ToCopyableBuilder<RelationalTable.Builder, RelationalTable> {
    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceArn").getter(getter(RelationalTable::dataSourceArn)).setter(setter(Builder::dataSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceArn").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(RelationalTable::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Schema")
            .getter(getter(RelationalTable::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RelationalTable::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<InputColumn>> INPUT_COLUMNS_FIELD = SdkField
            .<List<InputColumn>> builder(MarshallingType.LIST)
            .memberName("InputColumns")
            .getter(getter(RelationalTable::inputColumns))
            .setter(setter(Builder::inputColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ARN_FIELD,
            CATALOG_FIELD, SCHEMA_FIELD, NAME_FIELD, INPUT_COLUMNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSourceArn;

    private final String catalog;

    private final String schema;

    private final String name;

    private final List<InputColumn> inputColumns;

    private RelationalTable(BuilderImpl builder) {
        this.dataSourceArn = builder.dataSourceArn;
        this.catalog = builder.catalog;
        this.schema = builder.schema;
        this.name = builder.name;
        this.inputColumns = builder.inputColumns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the data source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the data source.
     */
    public final String dataSourceArn() {
        return dataSourceArn;
    }

    /**
     * <p>
     * The catalog associated with a table.
     * </p>
     * 
     * @return The catalog associated with a table.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The schema name. This name applies to certain relational database engines.
     * </p>
     * 
     * @return The schema name. This name applies to certain relational database engines.
     */
    public final String schema() {
        return schema;
    }

    /**
     * <p>
     * The name of the relational table.
     * </p>
     * 
     * @return The name of the relational table.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the InputColumns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInputColumns() {
        return inputColumns != null && !(inputColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The column schema of the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputColumns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The column schema of the table.
     */
    public final List<InputColumn> inputColumns() {
        return inputColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputColumns() ? inputColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalTable)) {
            return false;
        }
        RelationalTable other = (RelationalTable) obj;
        return Objects.equals(dataSourceArn(), other.dataSourceArn()) && Objects.equals(catalog(), other.catalog())
                && Objects.equals(schema(), other.schema()) && Objects.equals(name(), other.name())
                && hasInputColumns() == other.hasInputColumns() && Objects.equals(inputColumns(), other.inputColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelationalTable").add("DataSourceArn", dataSourceArn()).add("Catalog", catalog())
                .add("Schema", schema()).add("Name", name()).add("InputColumns", hasInputColumns() ? inputColumns() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceArn":
            return Optional.ofNullable(clazz.cast(dataSourceArn()));
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "InputColumns":
            return Optional.ofNullable(clazz.cast(inputColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalTable, T> g) {
        return obj -> g.apply((RelationalTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelationalTable> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the data source.
         * </p>
         * 
         * @param dataSourceArn
         *        The Amazon Resource Name (ARN) for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceArn(String dataSourceArn);

        /**
         * <p>
         * The catalog associated with a table.
         * </p>
         * 
         * @param catalog
         *        The catalog associated with a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The schema name. This name applies to certain relational database engines.
         * </p>
         * 
         * @param schema
         *        The schema name. This name applies to certain relational database engines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * The name of the relational table.
         * </p>
         * 
         * @param name
         *        The name of the relational table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The column schema of the table.
         * </p>
         * 
         * @param inputColumns
         *        The column schema of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputColumns(Collection<InputColumn> inputColumns);

        /**
         * <p>
         * The column schema of the table.
         * </p>
         * 
         * @param inputColumns
         *        The column schema of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputColumns(InputColumn... inputColumns);

        /**
         * <p>
         * The column schema of the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InputColumn>.Builder} avoiding the need to
         * create one manually via {@link List<InputColumn>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputColumn>.Builder#build()} is called immediately and its
         * result is passed to {@link #inputColumns(List<InputColumn>)}.
         * 
         * @param inputColumns
         *        a consumer that will call methods on {@link List<InputColumn>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputColumns(List<InputColumn>)
         */
        Builder inputColumns(Consumer<InputColumn.Builder>... inputColumns);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceArn;

        private String catalog;

        private String schema;

        private String name;

        private List<InputColumn> inputColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalTable model) {
            dataSourceArn(model.dataSourceArn);
            catalog(model.catalog);
            schema(model.schema);
            name(model.name);
            inputColumns(model.inputColumns);
        }

        public final String getDataSourceArn() {
            return dataSourceArn;
        }

        @Override
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        public final String getCatalog() {
            return catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public final String getSchema() {
            return schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<InputColumn.Builder> getInputColumns() {
            if (inputColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return inputColumns != null ? inputColumns.stream().map(InputColumn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputColumns(Collection<InputColumn> inputColumns) {
            this.inputColumns = InputColumnListCopier.copy(inputColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(InputColumn... inputColumns) {
            inputColumns(Arrays.asList(inputColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(Consumer<InputColumn.Builder>... inputColumns) {
            inputColumns(Stream.of(inputColumns).map(c -> InputColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputColumns(Collection<InputColumn.BuilderImpl> inputColumns) {
            this.inputColumns = InputColumnListCopier.copyFromBuilder(inputColumns);
        }

        @Override
        public RelationalTable build() {
            return new RelationalTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
