/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListThemesRequest extends QuickSightRequest implements
        ToCopyableBuilder<ListThemesRequest.Builder, ListThemesRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(ListThemesRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListThemesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListThemesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListThemesRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, TYPE_FIELD));

    private final String awsAccountId;

    private final String nextToken;

    private final Integer maxResults;

    private final String type;

    private ListThemesRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID of the AWS account that contains the themes that you're listing.
     * </p>
     * 
     * @return The ID of the AWS account that contains the themes that you're listing.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to be returned per request.
     * </p>
     * 
     * @return The maximum number of results to be returned per request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The type of themes that you want to list. Valid options include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL (default)</code>- Display all existing themes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUICKSIGHT</code> - Display only the starting themes defined by QuickSight.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThemeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of themes that you want to list. Valid options include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL (default)</code>- Display all existing themes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUICKSIGHT</code> - Display only the starting themes defined by QuickSight.
     *         </p>
     *         </li>
     * @see ThemeType
     */
    public final ThemeType type() {
        return ThemeType.fromValue(type);
    }

    /**
     * <p>
     * The type of themes that you want to list. Valid options include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL (default)</code>- Display all existing themes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUICKSIGHT</code> - Display only the starting themes defined by QuickSight.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThemeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of themes that you want to list. Valid options include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL (default)</code>- Display all existing themes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUICKSIGHT</code> - Display only the starting themes defined by QuickSight.
     *         </p>
     *         </li>
     * @see ThemeType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThemesRequest)) {
            return false;
        }
        ListThemesRequest other = (ListThemesRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListThemesRequest").add("AwsAccountId", awsAccountId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThemesRequest, T> g) {
        return obj -> g.apply((ListThemesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListThemesRequest> {
        /**
         * <p>
         * The ID of the AWS account that contains the themes that you're listing.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the AWS account that contains the themes that you're listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to be returned per request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The type of themes that you want to list. Valid options include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL (default)</code>- Display all existing themes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUICKSIGHT</code> - Display only the starting themes defined by QuickSight.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of themes that you want to list. Valid options include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL (default)</code>- Display all existing themes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUICKSIGHT</code> - Display only the starting themes defined by QuickSight.
         *        </p>
         *        </li>
         * @see ThemeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThemeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of themes that you want to list. Valid options include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL (default)</code>- Display all existing themes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUICKSIGHT</code> - Display only the starting themes defined by QuickSight.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of themes that you want to list. Valid options include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL (default)</code>- Display all existing themes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUICKSIGHT</code> - Display only the starting themes defined by QuickSight.
         *        </p>
         *        </li>
         * @see ThemeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThemeType
         */
        Builder type(ThemeType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String nextToken;

        private Integer maxResults;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThemesRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            type(model.type);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ThemeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListThemesRequest build() {
            return new ListThemesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
