/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenameColumnOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RenameColumnOperation> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnName").getter(RenameColumnOperation.getter(RenameColumnOperation::columnName)).setter(RenameColumnOperation.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()}).build();
    private static final SdkField<String> NEW_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewColumnName").getter(RenameColumnOperation.getter(RenameColumnOperation::newColumnName)).setter(RenameColumnOperation.setter(Builder::newColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewColumnName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, NEW_COLUMN_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final String newColumnName;

    private RenameColumnOperation(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.newColumnName = builder.newColumnName;
    }

    public String columnName() {
        return this.columnName;
    }

    public String newColumnName() {
        return this.newColumnName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newColumnName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenameColumnOperation)) {
            return false;
        }
        RenameColumnOperation other = (RenameColumnOperation)obj;
        return Objects.equals(this.columnName(), other.columnName()) && Objects.equals(this.newColumnName(), other.newColumnName());
    }

    public String toString() {
        return ToString.builder((String)"RenameColumnOperation").add("ColumnName", (Object)this.columnName()).add("NewColumnName", (Object)this.newColumnName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "NewColumnName": {
                return Optional.ofNullable(clazz.cast(this.newColumnName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenameColumnOperation, T> g) {
        return obj -> g.apply((RenameColumnOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String columnName;
        private String newColumnName;

        private BuilderImpl() {
        }

        private BuilderImpl(RenameColumnOperation model) {
            this.columnName(model.columnName);
            this.newColumnName(model.newColumnName);
        }

        public final String getColumnName() {
            return this.columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public final String getNewColumnName() {
            return this.newColumnName;
        }

        @Override
        public final Builder newColumnName(String newColumnName) {
            this.newColumnName = newColumnName;
            return this;
        }

        public final void setNewColumnName(String newColumnName) {
            this.newColumnName = newColumnName;
        }

        public RenameColumnOperation build() {
            return new RenameColumnOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RenameColumnOperation> {
        public Builder columnName(String var1);

        public Builder newColumnName(String var1);
    }
}

