/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the SPICE ingestion for a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ingestion implements SdkPojo, Serializable, ToCopyableBuilder<Ingestion.Builder, Ingestion> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Ingestion::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> INGESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngestionId").getter(getter(Ingestion::ingestionId)).setter(setter(Builder::ingestionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionId").build()).build();

    private static final SdkField<String> INGESTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngestionStatus").getter(getter(Ingestion::ingestionStatusAsString))
            .setter(setter(Builder::ingestionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionStatus").build()).build();

    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.<ErrorInfo> builder(MarshallingType.SDK_POJO)
            .memberName("ErrorInfo").getter(getter(Ingestion::errorInfo)).setter(setter(Builder::errorInfo))
            .constructor(ErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorInfo").build()).build();

    private static final SdkField<RowInfo> ROW_INFO_FIELD = SdkField.<RowInfo> builder(MarshallingType.SDK_POJO)
            .memberName("RowInfo").getter(getter(Ingestion::rowInfo)).setter(setter(Builder::rowInfo))
            .constructor(RowInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowInfo").build()).build();

    private static final SdkField<QueueInfo> QUEUE_INFO_FIELD = SdkField.<QueueInfo> builder(MarshallingType.SDK_POJO)
            .memberName("QueueInfo").getter(getter(Ingestion::queueInfo)).setter(setter(Builder::queueInfo))
            .constructor(QueueInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueInfo").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Ingestion::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Long> INGESTION_TIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("IngestionTimeInSeconds").getter(getter(Ingestion::ingestionTimeInSeconds))
            .setter(setter(Builder::ingestionTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionTimeInSeconds").build())
            .build();

    private static final SdkField<Long> INGESTION_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("IngestionSizeInBytes").getter(getter(Ingestion::ingestionSizeInBytes))
            .setter(setter(Builder::ingestionSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionSizeInBytes").build())
            .build();

    private static final SdkField<String> REQUEST_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestSource").getter(getter(Ingestion::requestSourceAsString)).setter(setter(Builder::requestSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestSource").build()).build();

    private static final SdkField<String> REQUEST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestType").getter(getter(Ingestion::requestTypeAsString)).setter(setter(Builder::requestType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, INGESTION_ID_FIELD,
            INGESTION_STATUS_FIELD, ERROR_INFO_FIELD, ROW_INFO_FIELD, QUEUE_INFO_FIELD, CREATED_TIME_FIELD,
            INGESTION_TIME_IN_SECONDS_FIELD, INGESTION_SIZE_IN_BYTES_FIELD, REQUEST_SOURCE_FIELD, REQUEST_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String ingestionId;

    private final String ingestionStatus;

    private final ErrorInfo errorInfo;

    private final RowInfo rowInfo;

    private final QueueInfo queueInfo;

    private final Instant createdTime;

    private final Long ingestionTimeInSeconds;

    private final Long ingestionSizeInBytes;

    private final String requestSource;

    private final String requestType;

    private Ingestion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.ingestionId = builder.ingestionId;
        this.ingestionStatus = builder.ingestionStatus;
        this.errorInfo = builder.errorInfo;
        this.rowInfo = builder.rowInfo;
        this.queueInfo = builder.queueInfo;
        this.createdTime = builder.createdTime;
        this.ingestionTimeInSeconds = builder.ingestionTimeInSeconds;
        this.ingestionSizeInBytes = builder.ingestionSizeInBytes;
        this.requestSource = builder.requestSource;
        this.requestType = builder.requestType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Ingestion ID.
     * </p>
     * 
     * @return Ingestion ID.
     */
    public final String ingestionId() {
        return ingestionId;
    }

    /**
     * <p>
     * Ingestion status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionStatus}
     * will return {@link IngestionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ingestionStatusAsString}.
     * </p>
     * 
     * @return Ingestion status.
     * @see IngestionStatus
     */
    public final IngestionStatus ingestionStatus() {
        return IngestionStatus.fromValue(ingestionStatus);
    }

    /**
     * <p>
     * Ingestion status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionStatus}
     * will return {@link IngestionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ingestionStatusAsString}.
     * </p>
     * 
     * @return Ingestion status.
     * @see IngestionStatus
     */
    public final String ingestionStatusAsString() {
        return ingestionStatus;
    }

    /**
     * <p>
     * Error information for this ingestion.
     * </p>
     * 
     * @return Error information for this ingestion.
     */
    public final ErrorInfo errorInfo() {
        return errorInfo;
    }

    /**
     * Returns the value of the RowInfo property for this object.
     * 
     * @return The value of the RowInfo property for this object.
     */
    public final RowInfo rowInfo() {
        return rowInfo;
    }

    /**
     * Returns the value of the QueueInfo property for this object.
     * 
     * @return The value of the QueueInfo property for this object.
     */
    public final QueueInfo queueInfo() {
        return queueInfo;
    }

    /**
     * <p>
     * The time that this ingestion started.
     * </p>
     * 
     * @return The time that this ingestion started.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The time that this ingestion took, measured in seconds.
     * </p>
     * 
     * @return The time that this ingestion took, measured in seconds.
     */
    public final Long ingestionTimeInSeconds() {
        return ingestionTimeInSeconds;
    }

    /**
     * <p>
     * The size of the data ingested, in bytes.
     * </p>
     * 
     * @return The size of the data ingested, in bytes.
     */
    public final Long ingestionSizeInBytes() {
        return ingestionSizeInBytes;
    }

    /**
     * <p>
     * Event source for this ingestion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestSource}
     * will return {@link IngestionRequestSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #requestSourceAsString}.
     * </p>
     * 
     * @return Event source for this ingestion.
     * @see IngestionRequestSource
     */
    public final IngestionRequestSource requestSource() {
        return IngestionRequestSource.fromValue(requestSource);
    }

    /**
     * <p>
     * Event source for this ingestion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestSource}
     * will return {@link IngestionRequestSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #requestSourceAsString}.
     * </p>
     * 
     * @return Event source for this ingestion.
     * @see IngestionRequestSource
     */
    public final String requestSourceAsString() {
        return requestSource;
    }

    /**
     * <p>
     * Type of this ingestion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestType} will
     * return {@link IngestionRequestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestTypeAsString}.
     * </p>
     * 
     * @return Type of this ingestion.
     * @see IngestionRequestType
     */
    public final IngestionRequestType requestType() {
        return IngestionRequestType.fromValue(requestType);
    }

    /**
     * <p>
     * Type of this ingestion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestType} will
     * return {@link IngestionRequestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestTypeAsString}.
     * </p>
     * 
     * @return Type of this ingestion.
     * @see IngestionRequestType
     */
    public final String requestTypeAsString() {
        return requestType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionId());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(rowInfo());
        hashCode = 31 * hashCode + Objects.hashCode(queueInfo());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(requestSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requestTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ingestion)) {
            return false;
        }
        Ingestion other = (Ingestion) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(ingestionId(), other.ingestionId())
                && Objects.equals(ingestionStatusAsString(), other.ingestionStatusAsString())
                && Objects.equals(errorInfo(), other.errorInfo()) && Objects.equals(rowInfo(), other.rowInfo())
                && Objects.equals(queueInfo(), other.queueInfo()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(ingestionTimeInSeconds(), other.ingestionTimeInSeconds())
                && Objects.equals(ingestionSizeInBytes(), other.ingestionSizeInBytes())
                && Objects.equals(requestSourceAsString(), other.requestSourceAsString())
                && Objects.equals(requestTypeAsString(), other.requestTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ingestion").add("Arn", arn()).add("IngestionId", ingestionId())
                .add("IngestionStatus", ingestionStatusAsString()).add("ErrorInfo", errorInfo()).add("RowInfo", rowInfo())
                .add("QueueInfo", queueInfo()).add("CreatedTime", createdTime())
                .add("IngestionTimeInSeconds", ingestionTimeInSeconds()).add("IngestionSizeInBytes", ingestionSizeInBytes())
                .add("RequestSource", requestSourceAsString()).add("RequestType", requestTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "IngestionId":
            return Optional.ofNullable(clazz.cast(ingestionId()));
        case "IngestionStatus":
            return Optional.ofNullable(clazz.cast(ingestionStatusAsString()));
        case "ErrorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        case "RowInfo":
            return Optional.ofNullable(clazz.cast(rowInfo()));
        case "QueueInfo":
            return Optional.ofNullable(clazz.cast(queueInfo()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "IngestionTimeInSeconds":
            return Optional.ofNullable(clazz.cast(ingestionTimeInSeconds()));
        case "IngestionSizeInBytes":
            return Optional.ofNullable(clazz.cast(ingestionSizeInBytes()));
        case "RequestSource":
            return Optional.ofNullable(clazz.cast(requestSourceAsString()));
        case "RequestType":
            return Optional.ofNullable(clazz.cast(requestTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ingestion, T> g) {
        return obj -> g.apply((Ingestion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ingestion> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Ingestion ID.
         * </p>
         * 
         * @param ingestionId
         *        Ingestion ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionId(String ingestionId);

        /**
         * <p>
         * Ingestion status.
         * </p>
         * 
         * @param ingestionStatus
         *        Ingestion status.
         * @see IngestionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionStatus
         */
        Builder ingestionStatus(String ingestionStatus);

        /**
         * <p>
         * Ingestion status.
         * </p>
         * 
         * @param ingestionStatus
         *        Ingestion status.
         * @see IngestionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionStatus
         */
        Builder ingestionStatus(IngestionStatus ingestionStatus);

        /**
         * <p>
         * Error information for this ingestion.
         * </p>
         * 
         * @param errorInfo
         *        Error information for this ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(ErrorInfo errorInfo);

        /**
         * <p>
         * Error information for this ingestion.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorInfo.Builder} avoiding the need to create
         * one manually via {@link ErrorInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #errorInfo(ErrorInfo)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link ErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(ErrorInfo)
         */
        default Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return errorInfo(ErrorInfo.builder().applyMutation(errorInfo).build());
        }

        /**
         * Sets the value of the RowInfo property for this object.
         *
         * @param rowInfo
         *        The new value for the RowInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowInfo(RowInfo rowInfo);

        /**
         * Sets the value of the RowInfo property for this object.
         *
         * This is a convenience that creates an instance of the {@link RowInfo.Builder} avoiding the need to create one
         * manually via {@link RowInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link RowInfo.Builder#build()} is called immediately and its result is
         * passed to {@link #rowInfo(RowInfo)}.
         * 
         * @param rowInfo
         *        a consumer that will call methods on {@link RowInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowInfo(RowInfo)
         */
        default Builder rowInfo(Consumer<RowInfo.Builder> rowInfo) {
            return rowInfo(RowInfo.builder().applyMutation(rowInfo).build());
        }

        /**
         * Sets the value of the QueueInfo property for this object.
         *
         * @param queueInfo
         *        The new value for the QueueInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueInfo(QueueInfo queueInfo);

        /**
         * Sets the value of the QueueInfo property for this object.
         *
         * This is a convenience that creates an instance of the {@link QueueInfo.Builder} avoiding the need to create
         * one manually via {@link QueueInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueueInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #queueInfo(QueueInfo)}.
         * 
         * @param queueInfo
         *        a consumer that will call methods on {@link QueueInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueInfo(QueueInfo)
         */
        default Builder queueInfo(Consumer<QueueInfo.Builder> queueInfo) {
            return queueInfo(QueueInfo.builder().applyMutation(queueInfo).build());
        }

        /**
         * <p>
         * The time that this ingestion started.
         * </p>
         * 
         * @param createdTime
         *        The time that this ingestion started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The time that this ingestion took, measured in seconds.
         * </p>
         * 
         * @param ingestionTimeInSeconds
         *        The time that this ingestion took, measured in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionTimeInSeconds(Long ingestionTimeInSeconds);

        /**
         * <p>
         * The size of the data ingested, in bytes.
         * </p>
         * 
         * @param ingestionSizeInBytes
         *        The size of the data ingested, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionSizeInBytes(Long ingestionSizeInBytes);

        /**
         * <p>
         * Event source for this ingestion.
         * </p>
         * 
         * @param requestSource
         *        Event source for this ingestion.
         * @see IngestionRequestSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionRequestSource
         */
        Builder requestSource(String requestSource);

        /**
         * <p>
         * Event source for this ingestion.
         * </p>
         * 
         * @param requestSource
         *        Event source for this ingestion.
         * @see IngestionRequestSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionRequestSource
         */
        Builder requestSource(IngestionRequestSource requestSource);

        /**
         * <p>
         * Type of this ingestion.
         * </p>
         * 
         * @param requestType
         *        Type of this ingestion.
         * @see IngestionRequestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionRequestType
         */
        Builder requestType(String requestType);

        /**
         * <p>
         * Type of this ingestion.
         * </p>
         * 
         * @param requestType
         *        Type of this ingestion.
         * @see IngestionRequestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionRequestType
         */
        Builder requestType(IngestionRequestType requestType);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String ingestionId;

        private String ingestionStatus;

        private ErrorInfo errorInfo;

        private RowInfo rowInfo;

        private QueueInfo queueInfo;

        private Instant createdTime;

        private Long ingestionTimeInSeconds;

        private Long ingestionSizeInBytes;

        private String requestSource;

        private String requestType;

        private BuilderImpl() {
        }

        private BuilderImpl(Ingestion model) {
            arn(model.arn);
            ingestionId(model.ingestionId);
            ingestionStatus(model.ingestionStatus);
            errorInfo(model.errorInfo);
            rowInfo(model.rowInfo);
            queueInfo(model.queueInfo);
            createdTime(model.createdTime);
            ingestionTimeInSeconds(model.ingestionTimeInSeconds);
            ingestionSizeInBytes(model.ingestionSizeInBytes);
            requestSource(model.requestSource);
            requestType(model.requestType);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getIngestionId() {
            return ingestionId;
        }

        @Override
        public final Builder ingestionId(String ingestionId) {
            this.ingestionId = ingestionId;
            return this;
        }

        public final void setIngestionId(String ingestionId) {
            this.ingestionId = ingestionId;
        }

        public final String getIngestionStatus() {
            return ingestionStatus;
        }

        @Override
        public final Builder ingestionStatus(String ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
            return this;
        }

        @Override
        public final Builder ingestionStatus(IngestionStatus ingestionStatus) {
            this.ingestionStatus(ingestionStatus == null ? null : ingestionStatus.toString());
            return this;
        }

        public final void setIngestionStatus(String ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        public final RowInfo.Builder getRowInfo() {
            return rowInfo != null ? rowInfo.toBuilder() : null;
        }

        @Override
        public final Builder rowInfo(RowInfo rowInfo) {
            this.rowInfo = rowInfo;
            return this;
        }

        public final void setRowInfo(RowInfo.BuilderImpl rowInfo) {
            this.rowInfo = rowInfo != null ? rowInfo.build() : null;
        }

        public final QueueInfo.Builder getQueueInfo() {
            return queueInfo != null ? queueInfo.toBuilder() : null;
        }

        @Override
        public final Builder queueInfo(QueueInfo queueInfo) {
            this.queueInfo = queueInfo;
            return this;
        }

        public final void setQueueInfo(QueueInfo.BuilderImpl queueInfo) {
            this.queueInfo = queueInfo != null ? queueInfo.build() : null;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Long getIngestionTimeInSeconds() {
            return ingestionTimeInSeconds;
        }

        @Override
        public final Builder ingestionTimeInSeconds(Long ingestionTimeInSeconds) {
            this.ingestionTimeInSeconds = ingestionTimeInSeconds;
            return this;
        }

        public final void setIngestionTimeInSeconds(Long ingestionTimeInSeconds) {
            this.ingestionTimeInSeconds = ingestionTimeInSeconds;
        }

        public final Long getIngestionSizeInBytes() {
            return ingestionSizeInBytes;
        }

        @Override
        public final Builder ingestionSizeInBytes(Long ingestionSizeInBytes) {
            this.ingestionSizeInBytes = ingestionSizeInBytes;
            return this;
        }

        public final void setIngestionSizeInBytes(Long ingestionSizeInBytes) {
            this.ingestionSizeInBytes = ingestionSizeInBytes;
        }

        public final String getRequestSource() {
            return requestSource;
        }

        @Override
        public final Builder requestSource(String requestSource) {
            this.requestSource = requestSource;
            return this;
        }

        @Override
        public final Builder requestSource(IngestionRequestSource requestSource) {
            this.requestSource(requestSource == null ? null : requestSource.toString());
            return this;
        }

        public final void setRequestSource(String requestSource) {
            this.requestSource = requestSource;
        }

        public final String getRequestType() {
            return requestType;
        }

        @Override
        public final Builder requestType(String requestType) {
            this.requestType = requestType;
            return this;
        }

        @Override
        public final Builder requestType(IngestionRequestType requestType) {
            this.requestType(requestType == null ? null : requestType.toString());
            return this;
        }

        public final void setRequestType(String requestType) {
            this.requestType = requestType;
        }

        @Override
        public Ingestion build() {
            return new Ingestion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
