/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterUserRequest extends QuickSightRequest implements
        ToCopyableBuilder<RegisterUserRequest.Builder, RegisterUserRequest> {
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityType").getter(getter(RegisterUserRequest::identityTypeAsString))
            .setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(RegisterUserRequest::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> USER_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserRole").getter(getter(RegisterUserRequest::userRoleAsString)).setter(setter(Builder::userRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRole").build()).build();

    private static final SdkField<String> IAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("IamArn")
            .getter(getter(RegisterUserRequest::iamArn)).setter(setter(Builder::iamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamArn").build()).build();

    private static final SdkField<String> SESSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionName").getter(getter(RegisterUserRequest::sessionName)).setter(setter(Builder::sessionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionName").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(RegisterUserRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(RegisterUserRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(RegisterUserRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> CUSTOM_PERMISSIONS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomPermissionsName").getter(getter(RegisterUserRequest::customPermissionsName))
            .setter(setter(Builder::customPermissionsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPermissionsName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_TYPE_FIELD,
            EMAIL_FIELD, USER_ROLE_FIELD, IAM_ARN_FIELD, SESSION_NAME_FIELD, AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD,
            USER_NAME_FIELD, CUSTOM_PERMISSIONS_NAME_FIELD));

    private final String identityType;

    private final String email;

    private final String userRole;

    private final String iamArn;

    private final String sessionName;

    private final String awsAccountId;

    private final String namespace;

    private final String userName;

    private final String customPermissionsName;

    private RegisterUserRequest(BuilderImpl builder) {
        super(builder);
        this.identityType = builder.identityType;
        this.email = builder.email;
        this.userRole = builder.userRole;
        this.iamArn = builder.iamArn;
        this.sessionName = builder.sessionName;
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.userName = builder.userName;
        this.customPermissionsName = builder.customPermissionsName;
    }

    /**
     * <p>
     * Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
     *         </p>
     *         </li>
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
     *         </p>
     *         </li>
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * The email address of the user that you want to register.
     * </p>
     * 
     * @return The email address of the user that you want to register.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The Amazon QuickSight role for the user. The user role can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READER</code>: A user who has read-only access to dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userRole} will
     * return {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userRoleAsString}.
     * </p>
     * 
     * @return The Amazon QuickSight role for the user. The user role can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READER</code>: A user who has read-only access to dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     * @see UserRole
     */
    public final UserRole userRole() {
        return UserRole.fromValue(userRole);
    }

    /**
     * <p>
     * The Amazon QuickSight role for the user. The user role can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READER</code>: A user who has read-only access to dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userRole} will
     * return {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userRoleAsString}.
     * </p>
     * 
     * @return The Amazon QuickSight role for the user. The user role can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READER</code>: A user who has read-only access to dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     * @see UserRole
     */
    public final String userRoleAsString() {
        return userRole;
    }

    /**
     * <p>
     * The ARN of the IAM user or role that you are registering with Amazon QuickSight.
     * </p>
     * 
     * @return The ARN of the IAM user or role that you are registering with Amazon QuickSight.
     */
    public final String iamArn() {
        return iamArn;
    }

    /**
     * <p>
     * You need to use this parameter only when you register one or more users using an assumed IAM role. You don't need
     * to provide the session name for other scenarios, for example when you are registering an IAM user or an Amazon
     * QuickSight user. You can register multiple users using the same IAM role if each user has a different session
     * name. For more information on assuming IAM roles, see <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code> </a> in
     * the <i>AWS CLI Reference.</i>
     * </p>
     * 
     * @return You need to use this parameter only when you register one or more users using an assumed IAM role. You
     *         don't need to provide the session name for other scenarios, for example when you are registering an IAM
     *         user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each user
     *         has a different session name. For more information on assuming IAM roles, see <a
     *         href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code>
     *         </a> in the <i>AWS CLI Reference.</i>
     */
    public final String sessionName() {
        return sessionName;
    }

    /**
     * <p>
     * The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your
     * Amazon QuickSight account.
     * </p>
     * 
     * @return The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that
     *         contains your Amazon QuickSight account.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The namespace. Currently, you should set this to <code>default</code>.
     * </p>
     * 
     * @return The namespace. Currently, you should set this to <code>default</code>.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The Amazon QuickSight user name that you want to create for the user you are registering.
     * </p>
     * 
     * @return The Amazon QuickSight user name that you want to create for the user you are registering.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user.
     * Customized permissions allows you to control a user's access by restricting access the following operations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create and update data sources
     * </p>
     * </li>
     * <li>
     * <p>
     * Create and update datasets
     * </p>
     * </li>
     * <li>
     * <p>
     * Create and update email reports
     * </p>
     * </li>
     * <li>
     * <p>
     * Subscribe to email reports
     * </p>
     * </li>
     * </ul>
     * <p>
     * To add custom permissions to an existing user, use <code> <a>UpdateUser</a> </code> instead.
     * </p>
     * <p>
     * A set of custom permissions includes any combination of these restrictions. Currently, you need to create the
     * profile names for custom permission sets by using the QuickSight console. Then, you use the
     * <code>RegisterUser</code> API operation to assign the named set of permissions to a QuickSight user.
     * </p>
     * <p>
     * QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions
     * typically granted by assigning QuickSight users to one of the default security cohorts in QuickSight (admin,
     * author, reader).
     * </p>
     * <p>
     * This feature is available only to QuickSight Enterprise edition subscriptions that use SAML 2.0-Based Federation
     * for Single Sign-On (SSO).
     * </p>
     * 
     * @return (Enterprise edition only) The name of the custom permissions profile that you want to assign to this
     *         user. Customized permissions allows you to control a user's access by restricting access the following
     *         operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Create and update data sources
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Create and update datasets
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Create and update email reports
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Subscribe to email reports
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To add custom permissions to an existing user, use <code> <a>UpdateUser</a> </code> instead.
     *         </p>
     *         <p>
     *         A set of custom permissions includes any combination of these restrictions. Currently, you need to create
     *         the profile names for custom permission sets by using the QuickSight console. Then, you use the
     *         <code>RegisterUser</code> API operation to assign the named set of permissions to a QuickSight user.
     *         </p>
     *         <p>
     *         QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions
     *         typically granted by assigning QuickSight users to one of the default security cohorts in QuickSight
     *         (admin, author, reader).
     *         </p>
     *         <p>
     *         This feature is available only to QuickSight Enterprise edition subscriptions that use SAML 2.0-Based
     *         Federation for Single Sign-On (SSO).
     */
    public final String customPermissionsName() {
        return customPermissionsName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(userRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iamArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionName());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(customPermissionsName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterUserRequest)) {
            return false;
        }
        RegisterUserRequest other = (RegisterUserRequest) obj;
        return Objects.equals(identityTypeAsString(), other.identityTypeAsString()) && Objects.equals(email(), other.email())
                && Objects.equals(userRoleAsString(), other.userRoleAsString()) && Objects.equals(iamArn(), other.iamArn())
                && Objects.equals(sessionName(), other.sessionName()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(userName(), other.userName())
                && Objects.equals(customPermissionsName(), other.customPermissionsName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterUserRequest").add("IdentityType", identityTypeAsString()).add("Email", email())
                .add("UserRole", userRoleAsString()).add("IamArn", iamArn()).add("SessionName", sessionName())
                .add("AwsAccountId", awsAccountId()).add("Namespace", namespace()).add("UserName", userName())
                .add("CustomPermissionsName", customPermissionsName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "UserRole":
            return Optional.ofNullable(clazz.cast(userRoleAsString()));
        case "IamArn":
            return Optional.ofNullable(clazz.cast(iamArn()));
        case "SessionName":
            return Optional.ofNullable(clazz.cast(sessionName()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "CustomPermissionsName":
            return Optional.ofNullable(clazz.cast(customPermissionsName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterUserRequest, T> g) {
        return obj -> g.apply((RegisterUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterUserRequest> {
        /**
         * <p>
         * Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
         * </p>
         * </li>
         * </ul>
         * 
         * @param identityType
         *        Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
         *        </p>
         *        </li>
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
         * </p>
         * </li>
         * </ul>
         * 
         * @param identityType
         *        Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
         *        </p>
         *        </li>
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The email address of the user that you want to register.
         * </p>
         * 
         * @param email
         *        The email address of the user that you want to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The Amazon QuickSight role for the user. The user role can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READER</code>: A user who has read-only access to dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param userRole
         *        The Amazon QuickSight role for the user. The user role can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READER</code>: A user who has read-only access to dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder userRole(String userRole);

        /**
         * <p>
         * The Amazon QuickSight role for the user. The user role can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READER</code>: A user who has read-only access to dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param userRole
         *        The Amazon QuickSight role for the user. The user role can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READER</code>: A user who has read-only access to dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder userRole(UserRole userRole);

        /**
         * <p>
         * The ARN of the IAM user or role that you are registering with Amazon QuickSight.
         * </p>
         * 
         * @param iamArn
         *        The ARN of the IAM user or role that you are registering with Amazon QuickSight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamArn(String iamArn);

        /**
         * <p>
         * You need to use this parameter only when you register one or more users using an assumed IAM role. You don't
         * need to provide the session name for other scenarios, for example when you are registering an IAM user or an
         * Amazon QuickSight user. You can register multiple users using the same IAM role if each user has a different
         * session name. For more information on assuming IAM roles, see <a
         * href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code> </a>
         * in the <i>AWS CLI Reference.</i>
         * </p>
         * 
         * @param sessionName
         *        You need to use this parameter only when you register one or more users using an assumed IAM role. You
         *        don't need to provide the session name for other scenarios, for example when you are registering an
         *        IAM user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each
         *        user has a different session name. For more information on assuming IAM roles, see <a
         *        href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code>
         *        </a> in the <i>AWS CLI Reference.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionName(String sessionName);

        /**
         * <p>
         * The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains
         * your Amazon QuickSight account.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that
         *        contains your Amazon QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The namespace. Currently, you should set this to <code>default</code>.
         * </p>
         * 
         * @param namespace
         *        The namespace. Currently, you should set this to <code>default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The Amazon QuickSight user name that you want to create for the user you are registering.
         * </p>
         * 
         * @param userName
         *        The Amazon QuickSight user name that you want to create for the user you are registering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user.
         * Customized permissions allows you to control a user's access by restricting access the following operations:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Create and update data sources
         * </p>
         * </li>
         * <li>
         * <p>
         * Create and update datasets
         * </p>
         * </li>
         * <li>
         * <p>
         * Create and update email reports
         * </p>
         * </li>
         * <li>
         * <p>
         * Subscribe to email reports
         * </p>
         * </li>
         * </ul>
         * <p>
         * To add custom permissions to an existing user, use <code> <a>UpdateUser</a> </code> instead.
         * </p>
         * <p>
         * A set of custom permissions includes any combination of these restrictions. Currently, you need to create the
         * profile names for custom permission sets by using the QuickSight console. Then, you use the
         * <code>RegisterUser</code> API operation to assign the named set of permissions to a QuickSight user.
         * </p>
         * <p>
         * QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions
         * typically granted by assigning QuickSight users to one of the default security cohorts in QuickSight (admin,
         * author, reader).
         * </p>
         * <p>
         * This feature is available only to QuickSight Enterprise edition subscriptions that use SAML 2.0-Based
         * Federation for Single Sign-On (SSO).
         * </p>
         * 
         * @param customPermissionsName
         *        (Enterprise edition only) The name of the custom permissions profile that you want to assign to this
         *        user. Customized permissions allows you to control a user's access by restricting access the following
         *        operations:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Create and update data sources
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Create and update datasets
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Create and update email reports
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Subscribe to email reports
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To add custom permissions to an existing user, use <code> <a>UpdateUser</a> </code> instead.
         *        </p>
         *        <p>
         *        A set of custom permissions includes any combination of these restrictions. Currently, you need to
         *        create the profile names for custom permission sets by using the QuickSight console. Then, you use the
         *        <code>RegisterUser</code> API operation to assign the named set of permissions to a QuickSight user.
         *        </p>
         *        <p>
         *        QuickSight custom permissions are applied through IAM policies. Therefore, they override the
         *        permissions typically granted by assigning QuickSight users to one of the default security cohorts in
         *        QuickSight (admin, author, reader).
         *        </p>
         *        <p>
         *        This feature is available only to QuickSight Enterprise edition subscriptions that use SAML 2.0-Based
         *        Federation for Single Sign-On (SSO).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPermissionsName(String customPermissionsName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String identityType;

        private String email;

        private String userRole;

        private String iamArn;

        private String sessionName;

        private String awsAccountId;

        private String namespace;

        private String userName;

        private String customPermissionsName;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterUserRequest model) {
            super(model);
            identityType(model.identityType);
            email(model.email);
            userRole(model.userRole);
            iamArn(model.iamArn);
            sessionName(model.sessionName);
            awsAccountId(model.awsAccountId);
            namespace(model.namespace);
            userName(model.userName);
            customPermissionsName(model.customPermissionsName);
        }

        public final String getIdentityType() {
            return identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public final String getEmail() {
            return email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getUserRole() {
            return userRole;
        }

        @Override
        public final Builder userRole(String userRole) {
            this.userRole = userRole;
            return this;
        }

        @Override
        public final Builder userRole(UserRole userRole) {
            this.userRole(userRole == null ? null : userRole.toString());
            return this;
        }

        public final void setUserRole(String userRole) {
            this.userRole = userRole;
        }

        public final String getIamArn() {
            return iamArn;
        }

        @Override
        public final Builder iamArn(String iamArn) {
            this.iamArn = iamArn;
            return this;
        }

        public final void setIamArn(String iamArn) {
            this.iamArn = iamArn;
        }

        public final String getSessionName() {
            return sessionName;
        }

        @Override
        public final Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public final void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getCustomPermissionsName() {
            return customPermissionsName;
        }

        @Override
        public final Builder customPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
            return this;
        }

        public final void setCustomPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterUserRequest build() {
            return new RegisterUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
