/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDashboardResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeDashboardResponse.Builder, DescribeDashboardResponse> {
    private static final SdkField<Dashboard> DASHBOARD_FIELD = SdkField.<Dashboard> builder(MarshallingType.SDK_POJO)
            .memberName("Dashboard").getter(getter(DescribeDashboardResponse::dashboard)).setter(setter(Builder::dashboard))
            .constructor(Dashboard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dashboard").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeDashboardResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeDashboardResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_FIELD, STATUS_FIELD,
            REQUEST_ID_FIELD));

    private final Dashboard dashboard;

    private final Integer status;

    private final String requestId;

    private DescribeDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboard = builder.dashboard;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * Information about the dashboard.
     * </p>
     * 
     * @return Information about the dashboard.
     */
    public final Dashboard dashboard() {
        return dashboard;
    }

    /**
     * <p>
     * The HTTP status of this request.
     * </p>
     * 
     * @return The HTTP status of this request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboard());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDashboardResponse)) {
            return false;
        }
        DescribeDashboardResponse other = (DescribeDashboardResponse) obj;
        return Objects.equals(dashboard(), other.dashboard()) && Objects.equals(status(), other.status())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDashboardResponse").add("Dashboard", dashboard()).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dashboard":
            return Optional.ofNullable(clazz.cast(dashboard()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDashboardResponse, T> g) {
        return obj -> g.apply((DescribeDashboardResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDashboardResponse> {
        /**
         * <p>
         * Information about the dashboard.
         * </p>
         * 
         * @param dashboard
         *        Information about the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboard(Dashboard dashboard);

        /**
         * <p>
         * Information about the dashboard.
         * </p>
         * This is a convenience that creates an instance of the {@link Dashboard.Builder} avoiding the need to create
         * one manually via {@link Dashboard#builder()}.
         *
         * When the {@link Consumer} completes, {@link Dashboard.Builder#build()} is called immediately and its result
         * is passed to {@link #dashboard(Dashboard)}.
         * 
         * @param dashboard
         *        a consumer that will call methods on {@link Dashboard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboard(Dashboard)
         */
        default Builder dashboard(Consumer<Dashboard.Builder> dashboard) {
            return dashboard(Dashboard.builder().applyMutation(dashboard).build());
        }

        /**
         * <p>
         * The HTTP status of this request.
         * </p>
         * 
         * @param status
         *        The HTTP status of this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private Dashboard dashboard;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDashboardResponse model) {
            super(model);
            dashboard(model.dashboard);
            status(model.status);
            requestId(model.requestId);
        }

        public final Dashboard.Builder getDashboard() {
            return dashboard != null ? dashboard.toBuilder() : null;
        }

        @Override
        public final Builder dashboard(Dashboard dashboard) {
            this.dashboard = dashboard;
            return this;
        }

        public final void setDashboard(Dashboard.BuilderImpl dashboard) {
            this.dashboard = dashboard != null ? dashboard.build() : null;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public DescribeDashboardResponse build() {
            return new DescribeDashboardResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
