/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a dataset that contains permissions for row-level security (RLS). The permissions dataset maps
 * fields to users or groups. For more information, see <a href=
 * "https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html"
 * >Using Row-Level Security (RLS) to Restrict Access to a Dataset</a> in the <i>Amazon QuickSight User Guide</i>.
 * </p>
 * <p>
 * The option to deny permissions by setting <code>PermissionPolicy</code> to <code>DENY_ACCESS</code> is not supported
 * for new RLS datasets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowLevelPermissionDataSet implements SdkPojo, Serializable,
        ToCopyableBuilder<RowLevelPermissionDataSet.Builder, RowLevelPermissionDataSet> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(RowLevelPermissionDataSet::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(RowLevelPermissionDataSet::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> PERMISSION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionPolicy").getter(getter(RowLevelPermissionDataSet::permissionPolicyAsString))
            .setter(setter(Builder::permissionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, ARN_FIELD,
            PERMISSION_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String namespace;

    private final String arn;

    private final String permissionPolicy;

    private RowLevelPermissionDataSet(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.arn = builder.arn;
        this.permissionPolicy = builder.permissionPolicy;
    }

    /**
     * <p>
     * The namespace associated with the dataset that contains permissions for RLS.
     * </p>
     * 
     * @return The namespace associated with the dataset that contains permissions for RLS.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of permissions to use when interpretting the permissions for RLS. <code>DENY_ACCESS</code> is included
     * for backward compatibility only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionPolicy}
     * will return {@link RowLevelPermissionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionPolicyAsString}.
     * </p>
     * 
     * @return The type of permissions to use when interpretting the permissions for RLS. <code>DENY_ACCESS</code> is
     *         included for backward compatibility only.
     * @see RowLevelPermissionPolicy
     */
    public final RowLevelPermissionPolicy permissionPolicy() {
        return RowLevelPermissionPolicy.fromValue(permissionPolicy);
    }

    /**
     * <p>
     * The type of permissions to use when interpretting the permissions for RLS. <code>DENY_ACCESS</code> is included
     * for backward compatibility only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionPolicy}
     * will return {@link RowLevelPermissionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionPolicyAsString}.
     * </p>
     * 
     * @return The type of permissions to use when interpretting the permissions for RLS. <code>DENY_ACCESS</code> is
     *         included for backward compatibility only.
     * @see RowLevelPermissionPolicy
     */
    public final String permissionPolicyAsString() {
        return permissionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionPolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowLevelPermissionDataSet)) {
            return false;
        }
        RowLevelPermissionDataSet other = (RowLevelPermissionDataSet) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(arn(), other.arn())
                && Objects.equals(permissionPolicyAsString(), other.permissionPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RowLevelPermissionDataSet").add("Namespace", namespace()).add("Arn", arn())
                .add("PermissionPolicy", permissionPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "PermissionPolicy":
            return Optional.ofNullable(clazz.cast(permissionPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RowLevelPermissionDataSet, T> g) {
        return obj -> g.apply((RowLevelPermissionDataSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowLevelPermissionDataSet> {
        /**
         * <p>
         * The namespace associated with the dataset that contains permissions for RLS.
         * </p>
         * 
         * @param namespace
         *        The namespace associated with the dataset that contains permissions for RLS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of permissions to use when interpretting the permissions for RLS. <code>DENY_ACCESS</code> is
         * included for backward compatibility only.
         * </p>
         * 
         * @param permissionPolicy
         *        The type of permissions to use when interpretting the permissions for RLS. <code>DENY_ACCESS</code> is
         *        included for backward compatibility only.
         * @see RowLevelPermissionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RowLevelPermissionPolicy
         */
        Builder permissionPolicy(String permissionPolicy);

        /**
         * <p>
         * The type of permissions to use when interpretting the permissions for RLS. <code>DENY_ACCESS</code> is
         * included for backward compatibility only.
         * </p>
         * 
         * @param permissionPolicy
         *        The type of permissions to use when interpretting the permissions for RLS. <code>DENY_ACCESS</code> is
         *        included for backward compatibility only.
         * @see RowLevelPermissionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RowLevelPermissionPolicy
         */
        Builder permissionPolicy(RowLevelPermissionPolicy permissionPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String namespace;

        private String arn;

        private String permissionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(RowLevelPermissionDataSet model) {
            namespace(model.namespace);
            arn(model.arn);
            permissionPolicy(model.permissionPolicy);
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPermissionPolicy() {
            return permissionPolicy;
        }

        @Override
        public final Builder permissionPolicy(String permissionPolicy) {
            this.permissionPolicy = permissionPolicy;
            return this;
        }

        @Override
        public final Builder permissionPolicy(RowLevelPermissionPolicy permissionPolicy) {
            this.permissionPolicy(permissionPolicy == null ? null : permissionPolicy.toString());
            return this;
        }

        public final void setPermissionPolicy(String permissionPolicy) {
            this.permissionPolicy = permissionPolicy;
        }

        @Override
        public RowLevelPermissionDataSet build() {
            return new RowLevelPermissionDataSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
