/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.FileFormat;
import software.amazon.awssdk.services.quicksight.model.TextQualifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UploadSettings> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(UploadSettings.getter(UploadSettings::formatAsString)).setter(UploadSettings.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<Integer> START_FROM_ROW_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartFromRow").getter(UploadSettings.getter(UploadSettings::startFromRow)).setter(UploadSettings.setter(Builder::startFromRow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartFromRow").build()}).build();
    private static final SdkField<Boolean> CONTAINS_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ContainsHeader").getter(UploadSettings.getter(UploadSettings::containsHeader)).setter(UploadSettings.setter(Builder::containsHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsHeader").build()}).build();
    private static final SdkField<String> TEXT_QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextQualifier").getter(UploadSettings.getter(UploadSettings::textQualifierAsString)).setter(UploadSettings.setter(Builder::textQualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextQualifier").build()}).build();
    private static final SdkField<String> DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Delimiter").getter(UploadSettings.getter(UploadSettings::delimiter)).setter(UploadSettings.setter(Builder::delimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, START_FROM_ROW_FIELD, CONTAINS_HEADER_FIELD, TEXT_QUALIFIER_FIELD, DELIMITER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String format;
    private final Integer startFromRow;
    private final Boolean containsHeader;
    private final String textQualifier;
    private final String delimiter;

    private UploadSettings(BuilderImpl builder) {
        this.format = builder.format;
        this.startFromRow = builder.startFromRow;
        this.containsHeader = builder.containsHeader;
        this.textQualifier = builder.textQualifier;
        this.delimiter = builder.delimiter;
    }

    public final FileFormat format() {
        return FileFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final Integer startFromRow() {
        return this.startFromRow;
    }

    public final Boolean containsHeader() {
        return this.containsHeader;
    }

    public final TextQualifier textQualifier() {
        return TextQualifier.fromValue(this.textQualifier);
    }

    public final String textQualifierAsString() {
        return this.textQualifier;
    }

    public final String delimiter() {
        return this.delimiter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startFromRow());
        hashCode = 31 * hashCode + Objects.hashCode(this.containsHeader());
        hashCode = 31 * hashCode + Objects.hashCode(this.textQualifierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadSettings)) {
            return false;
        }
        UploadSettings other = (UploadSettings)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.startFromRow(), other.startFromRow()) && Objects.equals(this.containsHeader(), other.containsHeader()) && Objects.equals(this.textQualifierAsString(), other.textQualifierAsString()) && Objects.equals(this.delimiter(), other.delimiter());
    }

    public final String toString() {
        return ToString.builder((String)"UploadSettings").add("Format", (Object)this.formatAsString()).add("StartFromRow", (Object)this.startFromRow()).add("ContainsHeader", (Object)this.containsHeader()).add("TextQualifier", (Object)this.textQualifierAsString()).add("Delimiter", (Object)this.delimiter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "StartFromRow": {
                return Optional.ofNullable(clazz.cast(this.startFromRow()));
            }
            case "ContainsHeader": {
                return Optional.ofNullable(clazz.cast(this.containsHeader()));
            }
            case "TextQualifier": {
                return Optional.ofNullable(clazz.cast(this.textQualifierAsString()));
            }
            case "Delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadSettings, T> g) {
        return obj -> g.apply((UploadSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private Integer startFromRow;
        private Boolean containsHeader;
        private String textQualifier;
        private String delimiter;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadSettings model) {
            this.format(model.format);
            this.startFromRow(model.startFromRow);
            this.containsHeader(model.containsHeader);
            this.textQualifier(model.textQualifier);
            this.delimiter(model.delimiter);
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(FileFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Integer getStartFromRow() {
            return this.startFromRow;
        }

        @Override
        public final Builder startFromRow(Integer startFromRow) {
            this.startFromRow = startFromRow;
            return this;
        }

        public final void setStartFromRow(Integer startFromRow) {
            this.startFromRow = startFromRow;
        }

        public final Boolean getContainsHeader() {
            return this.containsHeader;
        }

        @Override
        public final Builder containsHeader(Boolean containsHeader) {
            this.containsHeader = containsHeader;
            return this;
        }

        public final void setContainsHeader(Boolean containsHeader) {
            this.containsHeader = containsHeader;
        }

        public final String getTextQualifier() {
            return this.textQualifier;
        }

        @Override
        public final Builder textQualifier(String textQualifier) {
            this.textQualifier = textQualifier;
            return this;
        }

        @Override
        public final Builder textQualifier(TextQualifier textQualifier) {
            this.textQualifier(textQualifier == null ? null : textQualifier.toString());
            return this;
        }

        public final void setTextQualifier(String textQualifier) {
            this.textQualifier = textQualifier;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public UploadSettings build() {
            return new UploadSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UploadSettings> {
        public Builder format(String var1);

        public Builder format(FileFormat var1);

        public Builder startFromRow(Integer var1);

        public Builder containsHeader(Boolean var1);

        public Builder textQualifier(String var1);

        public Builder textQualifier(TextQualifier var1);

        public Builder delimiter(String var1);
    }
}

