/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTemplateResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateTemplateResponse> {
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateId").getter(UpdateTemplateResponse.getter(UpdateTemplateResponse::templateId)).setter(UpdateTemplateResponse.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateTemplateResponse.getter(UpdateTemplateResponse::arn)).setter(UpdateTemplateResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionArn").getter(UpdateTemplateResponse.getter(UpdateTemplateResponse::versionArn)).setter(UpdateTemplateResponse.setter(Builder::versionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionArn").build()}).build();
    private static final SdkField<String> CREATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationStatus").getter(UpdateTemplateResponse.getter(UpdateTemplateResponse::creationStatusAsString)).setter(UpdateTemplateResponse.setter(Builder::creationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationStatus").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(UpdateTemplateResponse.getter(UpdateTemplateResponse::status)).setter(UpdateTemplateResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateTemplateResponse.getter(UpdateTemplateResponse::requestId)).setter(UpdateTemplateResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ID_FIELD, ARN_FIELD, VERSION_ARN_FIELD, CREATION_STATUS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private final String templateId;
    private final String arn;
    private final String versionArn;
    private final String creationStatus;
    private final Integer status;
    private final String requestId;

    private UpdateTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateId = builder.templateId;
        this.arn = builder.arn;
        this.versionArn = builder.versionArn;
        this.creationStatus = builder.creationStatus;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String versionArn() {
        return this.versionArn;
    }

    public final ResourceStatus creationStatus() {
        return ResourceStatus.fromValue(this.creationStatus);
    }

    public final String creationStatusAsString() {
        return this.creationStatus;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTemplateResponse)) {
            return false;
        }
        UpdateTemplateResponse other = (UpdateTemplateResponse)((Object)obj);
        return Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.versionArn(), other.versionArn()) && Objects.equals(this.creationStatusAsString(), other.creationStatusAsString()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTemplateResponse").add("TemplateId", (Object)this.templateId()).add("Arn", (Object)this.arn()).add("VersionArn", (Object)this.versionArn()).add("CreationStatus", (Object)this.creationStatusAsString()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "VersionArn": {
                return Optional.ofNullable(clazz.cast(this.versionArn()));
            }
            case "CreationStatus": {
                return Optional.ofNullable(clazz.cast(this.creationStatusAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTemplateResponse, T> g) {
        return obj -> g.apply((UpdateTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String templateId;
        private String arn;
        private String versionArn;
        private String creationStatus;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTemplateResponse model) {
            super(model);
            this.templateId(model.templateId);
            this.arn(model.arn);
            this.versionArn(model.versionArn);
            this.creationStatus(model.creationStatus);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getVersionArn() {
            return this.versionArn;
        }

        @Override
        public final Builder versionArn(String versionArn) {
            this.versionArn = versionArn;
            return this;
        }

        public final void setVersionArn(String versionArn) {
            this.versionArn = versionArn;
        }

        public final String getCreationStatus() {
            return this.creationStatus;
        }

        @Override
        public final Builder creationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
            return this;
        }

        @Override
        public final Builder creationStatus(ResourceStatus creationStatus) {
            this.creationStatus(creationStatus == null ? null : creationStatus.toString());
            return this;
        }

        public final void setCreationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public UpdateTemplateResponse build() {
            return new UpdateTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTemplateResponse> {
        public Builder templateId(String var1);

        public Builder arn(String var1);

        public Builder versionArn(String var1);

        public Builder creationStatus(String var1);

        public Builder creationStatus(ResourceStatus var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

