/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dataset configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetConfiguration.Builder, DataSetConfiguration> {
    private static final SdkField<String> PLACEHOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Placeholder").getter(getter(DataSetConfiguration::placeholder)).setter(setter(Builder::placeholder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placeholder").build()).build();

    private static final SdkField<DataSetSchema> DATA_SET_SCHEMA_FIELD = SdkField
            .<DataSetSchema> builder(MarshallingType.SDK_POJO).memberName("DataSetSchema")
            .getter(getter(DataSetConfiguration::dataSetSchema)).setter(setter(Builder::dataSetSchema))
            .constructor(DataSetSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetSchema").build()).build();

    private static final SdkField<List<ColumnGroupSchema>> COLUMN_GROUP_SCHEMA_LIST_FIELD = SdkField
            .<List<ColumnGroupSchema>> builder(MarshallingType.LIST)
            .memberName("ColumnGroupSchemaList")
            .getter(getter(DataSetConfiguration::columnGroupSchemaList))
            .setter(setter(Builder::columnGroupSchemaList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnGroupSchemaList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnGroupSchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnGroupSchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEHOLDER_FIELD,
            DATA_SET_SCHEMA_FIELD, COLUMN_GROUP_SCHEMA_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String placeholder;

    private final DataSetSchema dataSetSchema;

    private final List<ColumnGroupSchema> columnGroupSchemaList;

    private DataSetConfiguration(BuilderImpl builder) {
        this.placeholder = builder.placeholder;
        this.dataSetSchema = builder.dataSetSchema;
        this.columnGroupSchemaList = builder.columnGroupSchemaList;
    }

    /**
     * <p>
     * Placeholder.
     * </p>
     * 
     * @return Placeholder.
     */
    public final String placeholder() {
        return placeholder;
    }

    /**
     * <p>
     * Dataset schema.
     * </p>
     * 
     * @return Dataset schema.
     */
    public final DataSetSchema dataSetSchema() {
        return dataSetSchema;
    }

    /**
     * Returns true if the ColumnGroupSchemaList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasColumnGroupSchemaList() {
        return columnGroupSchemaList != null && !(columnGroupSchemaList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure containing the list of column group schemas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasColumnGroupSchemaList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A structure containing the list of column group schemas.
     */
    public final List<ColumnGroupSchema> columnGroupSchemaList() {
        return columnGroupSchemaList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(placeholder());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetSchema());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnGroupSchemaList() ? columnGroupSchemaList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetConfiguration)) {
            return false;
        }
        DataSetConfiguration other = (DataSetConfiguration) obj;
        return Objects.equals(placeholder(), other.placeholder()) && Objects.equals(dataSetSchema(), other.dataSetSchema())
                && hasColumnGroupSchemaList() == other.hasColumnGroupSchemaList()
                && Objects.equals(columnGroupSchemaList(), other.columnGroupSchemaList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetConfiguration").add("Placeholder", placeholder()).add("DataSetSchema", dataSetSchema())
                .add("ColumnGroupSchemaList", hasColumnGroupSchemaList() ? columnGroupSchemaList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Placeholder":
            return Optional.ofNullable(clazz.cast(placeholder()));
        case "DataSetSchema":
            return Optional.ofNullable(clazz.cast(dataSetSchema()));
        case "ColumnGroupSchemaList":
            return Optional.ofNullable(clazz.cast(columnGroupSchemaList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSetConfiguration, T> g) {
        return obj -> g.apply((DataSetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetConfiguration> {
        /**
         * <p>
         * Placeholder.
         * </p>
         * 
         * @param placeholder
         *        Placeholder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placeholder(String placeholder);

        /**
         * <p>
         * Dataset schema.
         * </p>
         * 
         * @param dataSetSchema
         *        Dataset schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetSchema(DataSetSchema dataSetSchema);

        /**
         * <p>
         * Dataset schema.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSetSchema.Builder} avoiding the need to
         * create one manually via {@link DataSetSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSetSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSetSchema(DataSetSchema)}.
         * 
         * @param dataSetSchema
         *        a consumer that will call methods on {@link DataSetSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSetSchema(DataSetSchema)
         */
        default Builder dataSetSchema(Consumer<DataSetSchema.Builder> dataSetSchema) {
            return dataSetSchema(DataSetSchema.builder().applyMutation(dataSetSchema).build());
        }

        /**
         * <p>
         * A structure containing the list of column group schemas.
         * </p>
         * 
         * @param columnGroupSchemaList
         *        A structure containing the list of column group schemas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnGroupSchemaList(Collection<ColumnGroupSchema> columnGroupSchemaList);

        /**
         * <p>
         * A structure containing the list of column group schemas.
         * </p>
         * 
         * @param columnGroupSchemaList
         *        A structure containing the list of column group schemas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnGroupSchemaList(ColumnGroupSchema... columnGroupSchemaList);

        /**
         * <p>
         * A structure containing the list of column group schemas.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ColumnGroupSchema>.Builder} avoiding the
         * need to create one manually via {@link List<ColumnGroupSchema>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnGroupSchema>.Builder#build()} is called immediately
         * and its result is passed to {@link #columnGroupSchemaList(List<ColumnGroupSchema>)}.
         * 
         * @param columnGroupSchemaList
         *        a consumer that will call methods on {@link List<ColumnGroupSchema>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnGroupSchemaList(List<ColumnGroupSchema>)
         */
        Builder columnGroupSchemaList(Consumer<ColumnGroupSchema.Builder>... columnGroupSchemaList);
    }

    static final class BuilderImpl implements Builder {
        private String placeholder;

        private DataSetSchema dataSetSchema;

        private List<ColumnGroupSchema> columnGroupSchemaList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetConfiguration model) {
            placeholder(model.placeholder);
            dataSetSchema(model.dataSetSchema);
            columnGroupSchemaList(model.columnGroupSchemaList);
        }

        public final String getPlaceholder() {
            return placeholder;
        }

        @Override
        public final Builder placeholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
        }

        public final DataSetSchema.Builder getDataSetSchema() {
            return dataSetSchema != null ? dataSetSchema.toBuilder() : null;
        }

        @Override
        public final Builder dataSetSchema(DataSetSchema dataSetSchema) {
            this.dataSetSchema = dataSetSchema;
            return this;
        }

        public final void setDataSetSchema(DataSetSchema.BuilderImpl dataSetSchema) {
            this.dataSetSchema = dataSetSchema != null ? dataSetSchema.build() : null;
        }

        public final List<ColumnGroupSchema.Builder> getColumnGroupSchemaList() {
            List<ColumnGroupSchema.Builder> result = ColumnGroupSchemaListCopier.copyToBuilder(this.columnGroupSchemaList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder columnGroupSchemaList(Collection<ColumnGroupSchema> columnGroupSchemaList) {
            this.columnGroupSchemaList = ColumnGroupSchemaListCopier.copy(columnGroupSchemaList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroupSchemaList(ColumnGroupSchema... columnGroupSchemaList) {
            columnGroupSchemaList(Arrays.asList(columnGroupSchemaList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroupSchemaList(Consumer<ColumnGroupSchema.Builder>... columnGroupSchemaList) {
            columnGroupSchemaList(Stream.of(columnGroupSchemaList).map(c -> ColumnGroupSchema.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setColumnGroupSchemaList(Collection<ColumnGroupSchema.BuilderImpl> columnGroupSchemaList) {
            this.columnGroupSchemaList = ColumnGroupSchemaListCopier.copyFromBuilder(columnGroupSchemaList);
        }

        @Override
        public DataSetConfiguration build() {
            return new DataSetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
