/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThemeRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateThemeRequest.Builder, CreateThemeRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateThemeRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> THEME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeId").getter(getter(CreateThemeRequest::themeId)).setter(setter(Builder::themeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ThemeId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateThemeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> BASE_THEME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseThemeId").getter(getter(CreateThemeRequest::baseThemeId)).setter(setter(Builder::baseThemeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseThemeId").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionDescription").getter(getter(CreateThemeRequest::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final SdkField<ThemeConfiguration> CONFIGURATION_FIELD = SdkField
            .<ThemeConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(CreateThemeRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(ThemeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(CreateThemeRequest::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateThemeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            THEME_ID_FIELD, NAME_FIELD, BASE_THEME_ID_FIELD, VERSION_DESCRIPTION_FIELD, CONFIGURATION_FIELD, PERMISSIONS_FIELD,
            TAGS_FIELD));

    private final String awsAccountId;

    private final String themeId;

    private final String name;

    private final String baseThemeId;

    private final String versionDescription;

    private final ThemeConfiguration configuration;

    private final List<ResourcePermission> permissions;

    private final List<Tag> tags;

    private CreateThemeRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.themeId = builder.themeId;
        this.name = builder.name;
        this.baseThemeId = builder.baseThemeId;
        this.versionDescription = builder.versionDescription;
        this.configuration = builder.configuration;
        this.permissions = builder.permissions;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the AWS account where you want to store the new theme.
     * </p>
     * 
     * @return The ID of the AWS account where you want to store the new theme.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * An ID for the theme that you want to create. The theme ID is unique per AWS Region in each AWS account.
     * </p>
     * 
     * @return An ID for the theme that you want to create. The theme ID is unique per AWS Region in each AWS account.
     */
    public final String themeId() {
        return themeId;
    }

    /**
     * <p>
     * A display name for the theme.
     * </p>
     * 
     * @return A display name for the theme.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes
     * defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose
     * <b>Themes</b> from within a QuickSight analysis.
     * </p>
     * 
     * @return The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting
     *         themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or
     *         choose <b>Themes</b> from within a QuickSight analysis.
     */
    public final String baseThemeId() {
        return baseThemeId;
    }

    /**
     * <p>
     * A description of the first version of the theme that you're creating. Every time <code>UpdateTheme</code> is
     * called, a new version is created. Each version of the theme has a description of the version in the
     * <code>VersionDescription</code> field.
     * </p>
     * 
     * @return A description of the first version of the theme that you're creating. Every time <code>UpdateTheme</code>
     *         is called, a new version is created. Each version of the theme has a description of the version in the
     *         <code>VersionDescription</code> field.
     */
    public final String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * The theme configuration, which contains the theme display properties.
     * </p>
     * 
     * @return The theme configuration, which contains the theme display properties.
     */
    public final ThemeConfiguration configuration() {
        return configuration;
    }

    /**
     * Returns true if the Permissions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A valid grouping of resource permissions to apply to the new theme.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A valid grouping of resource permissions to apply to the new theme.
     */
    public final List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(themeId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(baseThemeId());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThemeRequest)) {
            return false;
        }
        CreateThemeRequest other = (CreateThemeRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(themeId(), other.themeId())
                && Objects.equals(name(), other.name()) && Objects.equals(baseThemeId(), other.baseThemeId())
                && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(configuration(), other.configuration()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissions(), other.permissions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateThemeRequest").add("AwsAccountId", awsAccountId()).add("ThemeId", themeId())
                .add("Name", name()).add("BaseThemeId", baseThemeId()).add("VersionDescription", versionDescription())
                .add("Configuration", configuration()).add("Permissions", hasPermissions() ? permissions() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "ThemeId":
            return Optional.ofNullable(clazz.cast(themeId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "BaseThemeId":
            return Optional.ofNullable(clazz.cast(baseThemeId()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThemeRequest, T> g) {
        return obj -> g.apply((CreateThemeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateThemeRequest> {
        /**
         * <p>
         * The ID of the AWS account where you want to store the new theme.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the AWS account where you want to store the new theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * An ID for the theme that you want to create. The theme ID is unique per AWS Region in each AWS account.
         * </p>
         * 
         * @param themeId
         *        An ID for the theme that you want to create. The theme ID is unique per AWS Region in each AWS
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeId(String themeId);

        /**
         * <p>
         * A display name for the theme.
         * </p>
         * 
         * @param name
         *        A display name for the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes
         * defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose
         * <b>Themes</b> from within a QuickSight analysis.
         * </p>
         * 
         * @param baseThemeId
         *        The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting
         *        themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or
         *        choose <b>Themes</b> from within a QuickSight analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseThemeId(String baseThemeId);

        /**
         * <p>
         * A description of the first version of the theme that you're creating. Every time <code>UpdateTheme</code> is
         * called, a new version is created. Each version of the theme has a description of the version in the
         * <code>VersionDescription</code> field.
         * </p>
         * 
         * @param versionDescription
         *        A description of the first version of the theme that you're creating. Every time
         *        <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a
         *        description of the version in the <code>VersionDescription</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * The theme configuration, which contains the theme display properties.
         * </p>
         * 
         * @param configuration
         *        The theme configuration, which contains the theme display properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ThemeConfiguration configuration);

        /**
         * <p>
         * The theme configuration, which contains the theme display properties.
         * </p>
         * This is a convenience that creates an instance of the {@link ThemeConfiguration.Builder} avoiding the need to
         * create one manually via {@link ThemeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThemeConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(ThemeConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ThemeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ThemeConfiguration)
         */
        default Builder configuration(Consumer<ThemeConfiguration.Builder> configuration) {
            return configuration(ThemeConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * A valid grouping of resource permissions to apply to the new theme.
         * </p>
         * 
         * @param permissions
         *        A valid grouping of resource permissions to apply to the new theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * A valid grouping of resource permissions to apply to the new theme.
         * </p>
         * 
         * @param permissions
         *        A valid grouping of resource permissions to apply to the new theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * A valid grouping of resource permissions to apply to the new theme.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
         * </p>
         * 
         * @param tags
         *        A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
         * </p>
         * 
         * @param tags
         *        A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String themeId;

        private String name;

        private String baseThemeId;

        private String versionDescription;

        private ThemeConfiguration configuration;

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThemeRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            themeId(model.themeId);
            name(model.name);
            baseThemeId(model.baseThemeId);
            versionDescription(model.versionDescription);
            configuration(model.configuration);
            permissions(model.permissions);
            tags(model.tags);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getThemeId() {
            return themeId;
        }

        @Override
        public final Builder themeId(String themeId) {
            this.themeId = themeId;
            return this;
        }

        public final void setThemeId(String themeId) {
            this.themeId = themeId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getBaseThemeId() {
            return baseThemeId;
        }

        @Override
        public final Builder baseThemeId(String baseThemeId) {
            this.baseThemeId = baseThemeId;
            return this;
        }

        public final void setBaseThemeId(String baseThemeId) {
            this.baseThemeId = baseThemeId;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        public final ThemeConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ThemeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ThemeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateThemeRequest build() {
            return new CreateThemeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
