/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFolderMembershipRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateFolderMembershipRequest.Builder, CreateFolderMembershipRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateFolderMembershipRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FolderId").getter(getter(CreateFolderMembershipRequest::folderId)).setter(setter(Builder::folderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FolderId").build()).build();

    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberId").getter(getter(CreateFolderMembershipRequest::memberId)).setter(setter(Builder::memberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MemberId").build()).build();

    private static final SdkField<String> MEMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberType").getter(getter(CreateFolderMembershipRequest::memberTypeAsString))
            .setter(setter(Builder::memberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MemberType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            FOLDER_ID_FIELD, MEMBER_ID_FIELD, MEMBER_TYPE_FIELD));

    private final String awsAccountId;

    private final String folderId;

    private final String memberId;

    private final String memberType;

    private CreateFolderMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.folderId = builder.folderId;
        this.memberId = builder.memberId;
        this.memberType = builder.memberType;
    }

    /**
     * <p>
     * The AWS Account ID.
     * </p>
     * 
     * @return The AWS Account ID.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The folder ID.
     * </p>
     * 
     * @return The folder ID.
     */
    public final String folderId() {
        return folderId;
    }

    /**
     * <p>
     * The ID of the asset (the dashboard, analysis, or dataset).
     * </p>
     * 
     * @return The ID of the asset (the dashboard, analysis, or dataset).
     */
    public final String memberId() {
        return memberId;
    }

    /**
     * <p>
     * The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberType} will
     * return {@link MemberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memberTypeAsString}.
     * </p>
     * 
     * @return The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>
     *         .
     * @see MemberType
     */
    public final MemberType memberType() {
        return MemberType.fromValue(memberType);
    }

    /**
     * <p>
     * The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberType} will
     * return {@link MemberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memberTypeAsString}.
     * </p>
     * 
     * @return The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>
     *         .
     * @see MemberType
     */
    public final String memberTypeAsString() {
        return memberType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(folderId());
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        hashCode = 31 * hashCode + Objects.hashCode(memberTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFolderMembershipRequest)) {
            return false;
        }
        CreateFolderMembershipRequest other = (CreateFolderMembershipRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(folderId(), other.folderId())
                && Objects.equals(memberId(), other.memberId())
                && Objects.equals(memberTypeAsString(), other.memberTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFolderMembershipRequest").add("AwsAccountId", awsAccountId()).add("FolderId", folderId())
                .add("MemberId", memberId()).add("MemberType", memberTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "FolderId":
            return Optional.ofNullable(clazz.cast(folderId()));
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        case "MemberType":
            return Optional.ofNullable(clazz.cast(memberTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFolderMembershipRequest, T> g) {
        return obj -> g.apply((CreateFolderMembershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFolderMembershipRequest> {
        /**
         * <p>
         * The AWS Account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS Account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The folder ID.
         * </p>
         * 
         * @param folderId
         *        The folder ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderId(String folderId);

        /**
         * <p>
         * The ID of the asset (the dashboard, analysis, or dataset).
         * </p>
         * 
         * @param memberId
         *        The ID of the asset (the dashboard, analysis, or dataset).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(String memberId);

        /**
         * <p>
         * The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>.
         * </p>
         * 
         * @param memberType
         *        The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and
         *        <code>DATASET</code>.
         * @see MemberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberType
         */
        Builder memberType(String memberType);

        /**
         * <p>
         * The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>.
         * </p>
         * 
         * @param memberType
         *        The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and
         *        <code>DATASET</code>.
         * @see MemberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberType
         */
        Builder memberType(MemberType memberType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String folderId;

        private String memberId;

        private String memberType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFolderMembershipRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            folderId(model.folderId);
            memberId(model.memberId);
            memberType(model.memberType);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getFolderId() {
            return folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        public final String getMemberId() {
            return memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        public final String getMemberType() {
            return memberType;
        }

        @Override
        public final Builder memberType(String memberType) {
            this.memberType = memberType;
            return this;
        }

        @Override
        public final Builder memberType(MemberType memberType) {
            this.memberType(memberType == null ? null : memberType.toString());
            return this;
        }

        public final void setMemberType(String memberType) {
            this.memberType = memberType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFolderMembershipRequest build() {
            return new CreateFolderMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
