/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of rules associated with a tag.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowLevelPermissionTagRule implements SdkPojo, Serializable,
        ToCopyableBuilder<RowLevelPermissionTagRule.Builder, RowLevelPermissionTagRule> {
    private static final SdkField<String> TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TagKey")
            .getter(getter(RowLevelPermissionTagRule::tagKey)).setter(setter(Builder::tagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()).build();

    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(RowLevelPermissionTagRule::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<String> TAG_MULTI_VALUE_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TagMultiValueDelimiter").getter(getter(RowLevelPermissionTagRule::tagMultiValueDelimiter))
            .setter(setter(Builder::tagMultiValueDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagMultiValueDelimiter").build())
            .build();

    private static final SdkField<String> MATCH_ALL_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchAllValue").getter(getter(RowLevelPermissionTagRule::matchAllValue))
            .setter(setter(Builder::matchAllValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAllValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_KEY_FIELD,
            COLUMN_NAME_FIELD, TAG_MULTI_VALUE_DELIMITER_FIELD, MATCH_ALL_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tagKey;

    private final String columnName;

    private final String tagMultiValueDelimiter;

    private final String matchAllValue;

    private RowLevelPermissionTagRule(BuilderImpl builder) {
        this.tagKey = builder.tagKey;
        this.columnName = builder.columnName;
        this.tagMultiValueDelimiter = builder.tagMultiValueDelimiter;
        this.matchAllValue = builder.matchAllValue;
    }

    /**
     * <p>
     * The unique key for a tag.
     * </p>
     * 
     * @return The unique key for a tag.
     */
    public final String tagKey() {
        return tagKey;
    }

    /**
     * <p>
     * The column name that a tag key is assigned to.
     * </p>
     * 
     * @return The column name that a tag key is assigned to.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * A string that you want to use to delimit the values when you pass the values at run time. For example, you can
     * delimit the values with a comma.
     * </p>
     * 
     * @return A string that you want to use to delimit the values when you pass the values at run time. For example,
     *         you can delimit the values with a comma.
     */
    public final String tagMultiValueDelimiter() {
        return tagMultiValueDelimiter;
    }

    /**
     * <p>
     * A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the
     * values one by one. For example, you can use an asterisk as your match all value.
     * </p>
     * 
     * @return A string that you want to use to filter by all the values in a column in the dataset and don’t want to
     *         list the values one by one. For example, you can use an asterisk as your match all value.
     */
    public final String matchAllValue() {
        return matchAllValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(tagMultiValueDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(matchAllValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowLevelPermissionTagRule)) {
            return false;
        }
        RowLevelPermissionTagRule other = (RowLevelPermissionTagRule) obj;
        return Objects.equals(tagKey(), other.tagKey()) && Objects.equals(columnName(), other.columnName())
                && Objects.equals(tagMultiValueDelimiter(), other.tagMultiValueDelimiter())
                && Objects.equals(matchAllValue(), other.matchAllValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RowLevelPermissionTagRule").add("TagKey", tagKey()).add("ColumnName", columnName())
                .add("TagMultiValueDelimiter", tagMultiValueDelimiter())
                .add("MatchAllValue", matchAllValue() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagKey":
            return Optional.ofNullable(clazz.cast(tagKey()));
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "TagMultiValueDelimiter":
            return Optional.ofNullable(clazz.cast(tagMultiValueDelimiter()));
        case "MatchAllValue":
            return Optional.ofNullable(clazz.cast(matchAllValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RowLevelPermissionTagRule, T> g) {
        return obj -> g.apply((RowLevelPermissionTagRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowLevelPermissionTagRule> {
        /**
         * <p>
         * The unique key for a tag.
         * </p>
         * 
         * @param tagKey
         *        The unique key for a tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * <p>
         * The column name that a tag key is assigned to.
         * </p>
         * 
         * @param columnName
         *        The column name that a tag key is assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * A string that you want to use to delimit the values when you pass the values at run time. For example, you
         * can delimit the values with a comma.
         * </p>
         * 
         * @param tagMultiValueDelimiter
         *        A string that you want to use to delimit the values when you pass the values at run time. For example,
         *        you can delimit the values with a comma.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagMultiValueDelimiter(String tagMultiValueDelimiter);

        /**
         * <p>
         * A string that you want to use to filter by all the values in a column in the dataset and don’t want to list
         * the values one by one. For example, you can use an asterisk as your match all value.
         * </p>
         * 
         * @param matchAllValue
         *        A string that you want to use to filter by all the values in a column in the dataset and don’t want to
         *        list the values one by one. For example, you can use an asterisk as your match all value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAllValue(String matchAllValue);
    }

    static final class BuilderImpl implements Builder {
        private String tagKey;

        private String columnName;

        private String tagMultiValueDelimiter;

        private String matchAllValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RowLevelPermissionTagRule model) {
            tagKey(model.tagKey);
            columnName(model.columnName);
            tagMultiValueDelimiter(model.tagMultiValueDelimiter);
            matchAllValue(model.matchAllValue);
        }

        public final String getTagKey() {
            return tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public final String getColumnName() {
            return columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public final String getTagMultiValueDelimiter() {
            return tagMultiValueDelimiter;
        }

        @Override
        public final Builder tagMultiValueDelimiter(String tagMultiValueDelimiter) {
            this.tagMultiValueDelimiter = tagMultiValueDelimiter;
            return this;
        }

        public final void setTagMultiValueDelimiter(String tagMultiValueDelimiter) {
            this.tagMultiValueDelimiter = tagMultiValueDelimiter;
        }

        public final String getMatchAllValue() {
            return matchAllValue;
        }

        @Override
        public final Builder matchAllValue(String matchAllValue) {
            this.matchAllValue = matchAllValue;
            return this;
        }

        public final void setMatchAllValue(String matchAllValue) {
            this.matchAllValue = matchAllValue;
        }

        @Override
        public RowLevelPermissionTagRule build() {
            return new RowLevelPermissionTagRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
