/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source entity of an analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisSourceEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisSourceEntity.Builder, AnalysisSourceEntity> {
    private static final SdkField<AnalysisSourceTemplate> SOURCE_TEMPLATE_FIELD = SdkField
            .<AnalysisSourceTemplate> builder(MarshallingType.SDK_POJO).memberName("SourceTemplate")
            .getter(getter(AnalysisSourceEntity::sourceTemplate)).setter(setter(Builder::sourceTemplate))
            .constructor(AnalysisSourceTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AnalysisSourceTemplate sourceTemplate;

    private AnalysisSourceEntity(BuilderImpl builder) {
        this.sourceTemplate = builder.sourceTemplate;
    }

    /**
     * <p>
     * The source template for the source entity of the analysis.
     * </p>
     * 
     * @return The source template for the source entity of the analysis.
     */
    public final AnalysisSourceTemplate sourceTemplate() {
        return sourceTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisSourceEntity)) {
            return false;
        }
        AnalysisSourceEntity other = (AnalysisSourceEntity) obj;
        return Objects.equals(sourceTemplate(), other.sourceTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisSourceEntity").add("SourceTemplate", sourceTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceTemplate":
            return Optional.ofNullable(clazz.cast(sourceTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisSourceEntity, T> g) {
        return obj -> g.apply((AnalysisSourceEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisSourceEntity> {
        /**
         * <p>
         * The source template for the source entity of the analysis.
         * </p>
         * 
         * @param sourceTemplate
         *        The source template for the source entity of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTemplate(AnalysisSourceTemplate sourceTemplate);

        /**
         * <p>
         * The source template for the source entity of the analysis.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisSourceTemplate.Builder} avoiding the
         * need to create one manually via {@link AnalysisSourceTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisSourceTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceTemplate(AnalysisSourceTemplate)}.
         * 
         * @param sourceTemplate
         *        a consumer that will call methods on {@link AnalysisSourceTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceTemplate(AnalysisSourceTemplate)
         */
        default Builder sourceTemplate(Consumer<AnalysisSourceTemplate.Builder> sourceTemplate) {
            return sourceTemplate(AnalysisSourceTemplate.builder().applyMutation(sourceTemplate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AnalysisSourceTemplate sourceTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisSourceEntity model) {
            sourceTemplate(model.sourceTemplate);
        }

        public final AnalysisSourceTemplate.Builder getSourceTemplate() {
            return sourceTemplate != null ? sourceTemplate.toBuilder() : null;
        }

        public final void setSourceTemplate(AnalysisSourceTemplate.BuilderImpl sourceTemplate) {
            this.sourceTemplate = sourceTemplate != null ? sourceTemplate.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceTemplate(AnalysisSourceTemplate sourceTemplate) {
            this.sourceTemplate = sourceTemplate;
            return this;
        }

        @Override
        public AnalysisSourceEntity build() {
            return new AnalysisSourceEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
