/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a theme.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Theme implements SdkPojo, Serializable, ToCopyableBuilder<Theme.Builder, Theme> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Theme::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Theme::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> THEME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeId").getter(getter(Theme::themeId)).setter(setter(Builder::themeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeId").build()).build();

    private static final SdkField<ThemeVersion> VERSION_FIELD = SdkField.<ThemeVersion> builder(MarshallingType.SDK_POJO)
            .memberName("Version").getter(getter(Theme::version)).setter(setter(Builder::version))
            .constructor(ThemeVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Theme::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(Theme::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Theme::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            THEME_ID_FIELD, VERSION_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String themeId;

    private final ThemeVersion version;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String type;

    private Theme(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.themeId = builder.themeId;
        this.version = builder.version;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the theme.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the theme.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name that the user gives to the theme.
     * </p>
     * 
     * @return The name that the user gives to the theme.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier that the user gives to the theme.
     * </p>
     * 
     * @return The identifier that the user gives to the theme.
     */
    public final String themeId() {
        return themeId;
    }

    /**
     * Returns the value of the Version property for this object.
     * 
     * @return The value of the Version property for this object.
     */
    public final ThemeVersion version() {
        return version;
    }

    /**
     * <p>
     * The date and time that the theme was created.
     * </p>
     * 
     * @return The date and time that the theme was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date and time that the theme was last updated.
     * </p>
     * 
     * @return The date and time that the theme was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The type of theme, based on how it was created. Valid values include: <code>QUICKSIGHT</code> and
     * <code>CUSTOM</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThemeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of theme, based on how it was created. Valid values include: <code>QUICKSIGHT</code> and
     *         <code>CUSTOM</code>.
     * @see ThemeType
     */
    public final ThemeType type() {
        return ThemeType.fromValue(type);
    }

    /**
     * <p>
     * The type of theme, based on how it was created. Valid values include: <code>QUICKSIGHT</code> and
     * <code>CUSTOM</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThemeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of theme, based on how it was created. Valid values include: <code>QUICKSIGHT</code> and
     *         <code>CUSTOM</code>.
     * @see ThemeType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(themeId());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Theme)) {
            return false;
        }
        Theme other = (Theme) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(themeId(), other.themeId()) && Objects.equals(version(), other.version())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Theme").add("Arn", arn()).add("Name", name()).add("ThemeId", themeId())
                .add("Version", version()).add("CreatedTime", createdTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ThemeId":
            return Optional.ofNullable(clazz.cast(themeId()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Theme, T> g) {
        return obj -> g.apply((Theme) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Theme> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the theme.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name that the user gives to the theme.
         * </p>
         * 
         * @param name
         *        The name that the user gives to the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier that the user gives to the theme.
         * </p>
         * 
         * @param themeId
         *        The identifier that the user gives to the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeId(String themeId);

        /**
         * Sets the value of the Version property for this object.
         *
         * @param version
         *        The new value for the Version property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(ThemeVersion version);

        /**
         * Sets the value of the Version property for this object.
         *
         * This is a convenience that creates an instance of the {@link ThemeVersion.Builder} avoiding the need to
         * create one manually via {@link ThemeVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThemeVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #version(ThemeVersion)}.
         * 
         * @param version
         *        a consumer that will call methods on {@link ThemeVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #version(ThemeVersion)
         */
        default Builder version(Consumer<ThemeVersion.Builder> version) {
            return version(ThemeVersion.builder().applyMutation(version).build());
        }

        /**
         * <p>
         * The date and time that the theme was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time that the theme was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The date and time that the theme was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time that the theme was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The type of theme, based on how it was created. Valid values include: <code>QUICKSIGHT</code> and
         * <code>CUSTOM</code>.
         * </p>
         * 
         * @param type
         *        The type of theme, based on how it was created. Valid values include: <code>QUICKSIGHT</code> and
         *        <code>CUSTOM</code>.
         * @see ThemeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThemeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of theme, based on how it was created. Valid values include: <code>QUICKSIGHT</code> and
         * <code>CUSTOM</code>.
         * </p>
         * 
         * @param type
         *        The type of theme, based on how it was created. Valid values include: <code>QUICKSIGHT</code> and
         *        <code>CUSTOM</code>.
         * @see ThemeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThemeType
         */
        Builder type(ThemeType type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String themeId;

        private ThemeVersion version;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Theme model) {
            arn(model.arn);
            name(model.name);
            themeId(model.themeId);
            version(model.version);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getThemeId() {
            return themeId;
        }

        public final void setThemeId(String themeId) {
            this.themeId = themeId;
        }

        @Override
        @Transient
        public final Builder themeId(String themeId) {
            this.themeId = themeId;
            return this;
        }

        public final ThemeVersion.Builder getVersion() {
            return version != null ? version.toBuilder() : null;
        }

        public final void setVersion(ThemeVersion.BuilderImpl version) {
            this.version = version != null ? version.build() : null;
        }

        @Override
        @Transient
        public final Builder version(ThemeVersion version) {
            this.version = version;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ThemeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Theme build() {
            return new Theme(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
