/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A version of a theme.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThemeVersion implements SdkPojo, Serializable, ToCopyableBuilder<ThemeVersion.Builder, ThemeVersion> {
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(ThemeVersion::versionNumber)).setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ThemeVersion::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ThemeVersion::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> BASE_THEME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseThemeId").getter(getter(ThemeVersion::baseThemeId)).setter(setter(Builder::baseThemeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseThemeId").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(ThemeVersion::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<ThemeConfiguration> CONFIGURATION_FIELD = SdkField
            .<ThemeConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(ThemeVersion::configuration)).setter(setter(Builder::configuration))
            .constructor(ThemeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<List<ThemeError>> ERRORS_FIELD = SdkField
            .<List<ThemeError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(ThemeVersion::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThemeError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThemeError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ThemeVersion::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_NUMBER_FIELD,
            ARN_FIELD, DESCRIPTION_FIELD, BASE_THEME_ID_FIELD, CREATED_TIME_FIELD, CONFIGURATION_FIELD, ERRORS_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long versionNumber;

    private final String arn;

    private final String description;

    private final String baseThemeId;

    private final Instant createdTime;

    private final ThemeConfiguration configuration;

    private final List<ThemeError> errors;

    private final String status;

    private ThemeVersion(BuilderImpl builder) {
        this.versionNumber = builder.versionNumber;
        this.arn = builder.arn;
        this.description = builder.description;
        this.baseThemeId = builder.baseThemeId;
        this.createdTime = builder.createdTime;
        this.configuration = builder.configuration;
        this.errors = builder.errors;
        this.status = builder.status;
    }

    /**
     * <p>
     * The version number of the theme.
     * </p>
     * 
     * @return The version number of the theme.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The description of the theme.
     * </p>
     * 
     * @return The description of the theme.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All themes initially inherit
     * from a default QuickSight theme.
     * </p>
     * 
     * @return The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All themes initially
     *         inherit from a default QuickSight theme.
     */
    public final String baseThemeId() {
        return baseThemeId;
    }

    /**
     * <p>
     * The date and time that this theme version was created.
     * </p>
     * 
     * @return The date and time that this theme version was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The theme configuration, which contains all the theme display properties.
     * </p>
     * 
     * @return The theme configuration, which contains all the theme display properties.
     */
    public final ThemeConfiguration configuration() {
        return configuration;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Errors associated with the theme.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Errors associated with the theme.
     */
    public final List<ThemeError> errors() {
        return errors;
    }

    /**
     * <p>
     * The status of the theme version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the theme version.
     * @see ResourceStatus
     */
    public final ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the theme version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the theme version.
     * @see ResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(baseThemeId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThemeVersion)) {
            return false;
        }
        ThemeVersion other = (ThemeVersion) obj;
        return Objects.equals(versionNumber(), other.versionNumber()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description()) && Objects.equals(baseThemeId(), other.baseThemeId())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(configuration(), other.configuration())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThemeVersion").add("VersionNumber", versionNumber()).add("Arn", arn())
                .add("Description", description()).add("BaseThemeId", baseThemeId()).add("CreatedTime", createdTime())
                .add("Configuration", configuration()).add("Errors", hasErrors() ? errors() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "BaseThemeId":
            return Optional.ofNullable(clazz.cast(baseThemeId()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThemeVersion, T> g) {
        return obj -> g.apply((ThemeVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThemeVersion> {
        /**
         * <p>
         * The version number of the theme.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The description of the theme.
         * </p>
         * 
         * @param description
         *        The description of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All themes initially inherit
         * from a default QuickSight theme.
         * </p>
         * 
         * @param baseThemeId
         *        The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All themes initially
         *        inherit from a default QuickSight theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseThemeId(String baseThemeId);

        /**
         * <p>
         * The date and time that this theme version was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time that this theme version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The theme configuration, which contains all the theme display properties.
         * </p>
         * 
         * @param configuration
         *        The theme configuration, which contains all the theme display properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ThemeConfiguration configuration);

        /**
         * <p>
         * The theme configuration, which contains all the theme display properties.
         * </p>
         * This is a convenience that creates an instance of the {@link ThemeConfiguration.Builder} avoiding the need to
         * create one manually via {@link ThemeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThemeConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(ThemeConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ThemeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ThemeConfiguration)
         */
        default Builder configuration(Consumer<ThemeConfiguration.Builder> configuration) {
            return configuration(ThemeConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Errors associated with the theme.
         * </p>
         * 
         * @param errors
         *        Errors associated with the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<ThemeError> errors);

        /**
         * <p>
         * Errors associated with the theme.
         * </p>
         * 
         * @param errors
         *        Errors associated with the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(ThemeError... errors);

        /**
         * <p>
         * Errors associated with the theme.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ThemeError>.Builder} avoiding the need to
         * create one manually via {@link List<ThemeError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ThemeError>.Builder#build()} is called immediately and its
         * result is passed to {@link #errors(List<ThemeError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<ThemeError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<ThemeError>)
         */
        Builder errors(Consumer<ThemeError.Builder>... errors);

        /**
         * <p>
         * The status of the theme version.
         * </p>
         * 
         * @param status
         *        The status of the theme version.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the theme version.
         * </p>
         * 
         * @param status
         *        The status of the theme version.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Long versionNumber;

        private String arn;

        private String description;

        private String baseThemeId;

        private Instant createdTime;

        private ThemeConfiguration configuration;

        private List<ThemeError> errors = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ThemeVersion model) {
            versionNumber(model.versionNumber);
            arn(model.arn);
            description(model.description);
            baseThemeId(model.baseThemeId);
            createdTime(model.createdTime);
            configuration(model.configuration);
            errors(model.errors);
            status(model.status);
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        @Transient
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBaseThemeId() {
            return baseThemeId;
        }

        public final void setBaseThemeId(String baseThemeId) {
            this.baseThemeId = baseThemeId;
        }

        @Override
        @Transient
        public final Builder baseThemeId(String baseThemeId) {
            this.baseThemeId = baseThemeId;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final ThemeConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ThemeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder configuration(ThemeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<ThemeError.Builder> getErrors() {
            List<ThemeError.Builder> result = ThemeErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<ThemeError.BuilderImpl> errors) {
            this.errors = ThemeErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        @Transient
        public final Builder errors(Collection<ThemeError> errors) {
            this.errors = ThemeErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(ThemeError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(Consumer<ThemeError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> ThemeError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ThemeVersion build() {
            return new ThemeVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
