/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for MySQL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MySqlParameters implements SdkPojo, Serializable, ToCopyableBuilder<MySqlParameters.Builder, MySqlParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(MySqlParameters::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(MySqlParameters::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(MySqlParameters::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, PORT_FIELD,
            DATABASE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String host;

    private final Integer port;

    private final String database;

    private MySqlParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.database = builder.database;
    }

    /**
     * <p>
     * Host.
     * </p>
     * 
     * @return Host.
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * Port.
     * </p>
     * 
     * @return Port.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Database.
     * </p>
     * 
     * @return Database.
     */
    public final String database() {
        return database;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MySqlParameters)) {
            return false;
        }
        MySqlParameters other = (MySqlParameters) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(port(), other.port())
                && Objects.equals(database(), other.database());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MySqlParameters").add("Host", host()).add("Port", port()).add("Database", database()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MySqlParameters, T> g) {
        return obj -> g.apply((MySqlParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MySqlParameters> {
        /**
         * <p>
         * Host.
         * </p>
         * 
         * @param host
         *        Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * Port.
         * </p>
         * 
         * @param port
         *        Port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Database.
         * </p>
         * 
         * @param database
         *        Database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);
    }

    static final class BuilderImpl implements Builder {
        private String host;

        private Integer port;

        private String database;

        private BuilderImpl() {
        }

        private BuilderImpl(MySqlParameters model) {
            host(model.host);
            port(model.port);
            database(model.database);
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        @Transient
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        @Transient
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        @Override
        public MySqlParameters build() {
            return new MySqlParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
