/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFolderRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateFolderRequest.Builder, CreateFolderRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateFolderRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FolderId").getter(getter(CreateFolderRequest::folderId)).setter(setter(Builder::folderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FolderId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateFolderRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> FOLDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FolderType").getter(getter(CreateFolderRequest::folderTypeAsString)).setter(setter(Builder::folderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderType").build()).build();

    private static final SdkField<String> PARENT_FOLDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentFolderArn").getter(getter(CreateFolderRequest::parentFolderArn))
            .setter(setter(Builder::parentFolderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentFolderArn").build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(CreateFolderRequest::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFolderRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            FOLDER_ID_FIELD, NAME_FIELD, FOLDER_TYPE_FIELD, PARENT_FOLDER_ARN_FIELD, PERMISSIONS_FIELD, TAGS_FIELD));

    private final String awsAccountId;

    private final String folderId;

    private final String name;

    private final String folderType;

    private final String parentFolderArn;

    private final List<ResourcePermission> permissions;

    private final List<Tag> tags;

    private CreateFolderRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.folderId = builder.folderId;
        this.name = builder.name;
        this.folderType = builder.folderType;
        this.parentFolderArn = builder.parentFolderArn;
        this.permissions = builder.permissions;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID for the Amazon Web Services account where you want to create the folder.
     * </p>
     * 
     * @return The ID for the Amazon Web Services account where you want to create the folder.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the folder.
     * </p>
     * 
     * @return The ID of the folder.
     */
    public final String folderId() {
        return folderId;
    }

    /**
     * <p>
     * The name of the folder.
     * </p>
     * 
     * @return The name of the folder.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #folderType} will
     * return {@link FolderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #folderTypeAsString}.
     * </p>
     * 
     * @return The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.
     * @see FolderType
     */
    public final FolderType folderType() {
        return FolderType.fromValue(folderType);
    }

    /**
     * <p>
     * The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #folderType} will
     * return {@link FolderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #folderTypeAsString}.
     * </p>
     * 
     * @return The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.
     * @see FolderType
     */
    public final String folderTypeAsString() {
        return folderType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the parent folder.
     * </p>
     * <p>
     * <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level folder.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the parent folder.</p>
     *         <p>
     *         <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level
     *         folder.
     */
    public final String parentFolderArn() {
        return parentFolderArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that describes the principals and the resource-level permissions of a folder.
     * </p>
     * <p>
     * To specify no permissions, omit <code>Permissions</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return A structure that describes the principals and the resource-level permissions of a folder.</p>
     *         <p>
     *         To specify no permissions, omit <code>Permissions</code>.
     */
    public final List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags for the folder.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the folder.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(folderId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(folderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parentFolderArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFolderRequest)) {
            return false;
        }
        CreateFolderRequest other = (CreateFolderRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(folderId(), other.folderId())
                && Objects.equals(name(), other.name()) && Objects.equals(folderTypeAsString(), other.folderTypeAsString())
                && Objects.equals(parentFolderArn(), other.parentFolderArn()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissions(), other.permissions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFolderRequest").add("AwsAccountId", awsAccountId()).add("FolderId", folderId())
                .add("Name", name()).add("FolderType", folderTypeAsString()).add("ParentFolderArn", parentFolderArn())
                .add("Permissions", hasPermissions() ? permissions() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "FolderId":
            return Optional.ofNullable(clazz.cast(folderId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "FolderType":
            return Optional.ofNullable(clazz.cast(folderTypeAsString()));
        case "ParentFolderArn":
            return Optional.ofNullable(clazz.cast(parentFolderArn()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFolderRequest, T> g) {
        return obj -> g.apply((CreateFolderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFolderRequest> {
        /**
         * <p>
         * The ID for the Amazon Web Services account where you want to create the folder.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the Amazon Web Services account where you want to create the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the folder.
         * </p>
         * 
         * @param folderId
         *        The ID of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderId(String folderId);

        /**
         * <p>
         * The name of the folder.
         * </p>
         * 
         * @param name
         *        The name of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.
         * </p>
         * 
         * @param folderType
         *        The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.
         * @see FolderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FolderType
         */
        Builder folderType(String folderType);

        /**
         * <p>
         * The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.
         * </p>
         * 
         * @param folderType
         *        The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.
         * @see FolderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FolderType
         */
        Builder folderType(FolderType folderType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the parent folder.
         * </p>
         * <p>
         * <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level folder.
         * </p>
         * 
         * @param parentFolderArn
         *        The Amazon Resource Name (ARN) for the parent folder.</p>
         *        <p>
         *        <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level
         *        folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentFolderArn(String parentFolderArn);

        /**
         * <p>
         * A structure that describes the principals and the resource-level permissions of a folder.
         * </p>
         * <p>
         * To specify no permissions, omit <code>Permissions</code>.
         * </p>
         * 
         * @param permissions
         *        A structure that describes the principals and the resource-level permissions of a folder.</p>
         *        <p>
         *        To specify no permissions, omit <code>Permissions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * A structure that describes the principals and the resource-level permissions of a folder.
         * </p>
         * <p>
         * To specify no permissions, omit <code>Permissions</code>.
         * </p>
         * 
         * @param permissions
         *        A structure that describes the principals and the resource-level permissions of a folder.</p>
         *        <p>
         *        To specify no permissions, omit <code>Permissions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * A structure that describes the principals and the resource-level permissions of a folder.
         * </p>
         * <p>
         * To specify no permissions, omit <code>Permissions</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * Tags for the folder.
         * </p>
         * 
         * @param tags
         *        Tags for the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags for the folder.
         * </p>
         * 
         * @param tags
         *        Tags for the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags for the folder.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String folderId;

        private String name;

        private String folderType;

        private String parentFolderArn;

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFolderRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            folderId(model.folderId);
            name(model.name);
            folderType(model.folderType);
            parentFolderArn(model.parentFolderArn);
            permissions(model.permissions);
            tags(model.tags);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getFolderId() {
            return folderId;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        @Override
        @Transient
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFolderType() {
            return folderType;
        }

        public final void setFolderType(String folderType) {
            this.folderType = folderType;
        }

        @Override
        @Transient
        public final Builder folderType(String folderType) {
            this.folderType = folderType;
            return this;
        }

        @Override
        @Transient
        public final Builder folderType(FolderType folderType) {
            this.folderType(folderType == null ? null : folderType.toString());
            return this;
        }

        public final String getParentFolderArn() {
            return parentFolderArn;
        }

        public final void setParentFolderArn(String parentFolderArn) {
            this.parentFolderArn = parentFolderArn;
        }

        @Override
        @Transient
        public final Builder parentFolderArn(String parentFolderArn) {
            this.parentFolderArn = parentFolderArn;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        @Transient
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFolderRequest build() {
            return new CreateFolderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
