/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFolderResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeFolderResponse.Builder, DescribeFolderResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeFolderResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<Folder> FOLDER_FIELD = SdkField.<Folder> builder(MarshallingType.SDK_POJO).memberName("Folder")
            .getter(getter(DescribeFolderResponse::folder)).setter(setter(Builder::folder)).constructor(Folder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folder").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeFolderResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FOLDER_FIELD,
            REQUEST_ID_FIELD));

    private final Integer status;

    private final Folder folder;

    private final String requestId;

    private DescribeFolderResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.folder = builder.folder;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * Information about the folder.
     * </p>
     * 
     * @return Information about the folder.
     */
    public final Folder folder() {
        return folder;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(folder());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFolderResponse)) {
            return false;
        }
        DescribeFolderResponse other = (DescribeFolderResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(folder(), other.folder())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFolderResponse").add("Status", status()).add("Folder", folder())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Folder":
            return Optional.ofNullable(clazz.cast(folder()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFolderResponse, T> g) {
        return obj -> g.apply((DescribeFolderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFolderResponse> {
        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * Information about the folder.
         * </p>
         * 
         * @param folder
         *        Information about the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folder(Folder folder);

        /**
         * <p>
         * Information about the folder.
         * </p>
         * This is a convenience that creates an instance of the {@link Folder.Builder} avoiding the need to create one
         * manually via {@link Folder#builder()}.
         *
         * When the {@link Consumer} completes, {@link Folder.Builder#build()} is called immediately and its result is
         * passed to {@link #folder(Folder)}.
         * 
         * @param folder
         *        a consumer that will call methods on {@link Folder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #folder(Folder)
         */
        default Builder folder(Consumer<Folder.Builder> folder) {
            return folder(Folder.builder().applyMutation(folder).build());
        }

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private Integer status;

        private Folder folder;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFolderResponse model) {
            super(model);
            status(model.status);
            folder(model.folder);
            requestId(model.requestId);
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final Folder.Builder getFolder() {
            return folder != null ? folder.toBuilder() : null;
        }

        public final void setFolder(Folder.BuilderImpl folder) {
            this.folder = folder != null ? folder.build() : null;
        }

        @Override
        @Transient
        public final Builder folder(Folder folder) {
            this.folder = folder;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        @Transient
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeFolderResponse build() {
            return new DescribeFolderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
