/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Identity and Access Management (IAM) policy assignment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IAMPolicyAssignment implements SdkPojo, Serializable,
        ToCopyableBuilder<IAMPolicyAssignment.Builder, IAMPolicyAssignment> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(IAMPolicyAssignment::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ASSIGNMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentId").getter(getter(IAMPolicyAssignment::assignmentId)).setter(setter(Builder::assignmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentId").build()).build();

    private static final SdkField<String> ASSIGNMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentName").getter(getter(IAMPolicyAssignment::assignmentName))
            .setter(setter(Builder::assignmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentName").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyArn").getter(getter(IAMPolicyAssignment::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()).build();

    private static final SdkField<Map<String, List<String>>> IDENTITIES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Identities")
            .getter(getter(IAMPolicyAssignment::identities))
            .setter(setter(Builder::identities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identities").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentStatus").getter(getter(IAMPolicyAssignment::assignmentStatusAsString))
            .setter(setter(Builder::assignmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            ASSIGNMENT_ID_FIELD, ASSIGNMENT_NAME_FIELD, POLICY_ARN_FIELD, IDENTITIES_FIELD, ASSIGNMENT_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final String assignmentId;

    private final String assignmentName;

    private final String policyArn;

    private final Map<String, List<String>> identities;

    private final String assignmentStatus;

    private IAMPolicyAssignment(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.assignmentId = builder.assignmentId;
        this.assignmentName = builder.assignmentName;
        this.policyArn = builder.policyArn;
        this.identities = builder.identities;
        this.assignmentStatus = builder.assignmentStatus;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * Assignment ID.
     * </p>
     * 
     * @return Assignment ID.
     */
    public final String assignmentId() {
        return assignmentId;
    }

    /**
     * <p>
     * Assignment name.
     * </p>
     * 
     * @return Assignment name.
     */
    public final String assignmentName() {
        return assignmentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the IAM policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the IAM policy.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Identities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIdentities() {
        return identities != null && !(identities instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Identities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentities} method.
     * </p>
     * 
     * @return Identities.
     */
    public final Map<String, List<String>> identities() {
        return identities;
    }

    /**
     * <p>
     * Assignment status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return Assignment status.
     * @see AssignmentStatus
     */
    public final AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(assignmentStatus);
    }

    /**
     * <p>
     * Assignment status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return Assignment status.
     * @see AssignmentStatus
     */
    public final String assignmentStatusAsString() {
        return assignmentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentName());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentities() ? identities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assignmentStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IAMPolicyAssignment)) {
            return false;
        }
        IAMPolicyAssignment other = (IAMPolicyAssignment) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(assignmentId(), other.assignmentId())
                && Objects.equals(assignmentName(), other.assignmentName()) && Objects.equals(policyArn(), other.policyArn())
                && hasIdentities() == other.hasIdentities() && Objects.equals(identities(), other.identities())
                && Objects.equals(assignmentStatusAsString(), other.assignmentStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IAMPolicyAssignment").add("AwsAccountId", awsAccountId()).add("AssignmentId", assignmentId())
                .add("AssignmentName", assignmentName()).add("PolicyArn", policyArn())
                .add("Identities", hasIdentities() ? identities() : null).add("AssignmentStatus", assignmentStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AssignmentId":
            return Optional.ofNullable(clazz.cast(assignmentId()));
        case "AssignmentName":
            return Optional.ofNullable(clazz.cast(assignmentName()));
        case "PolicyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "Identities":
            return Optional.ofNullable(clazz.cast(identities()));
        case "AssignmentStatus":
            return Optional.ofNullable(clazz.cast(assignmentStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IAMPolicyAssignment, T> g) {
        return obj -> g.apply((IAMPolicyAssignment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IAMPolicyAssignment> {
        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * Assignment ID.
         * </p>
         * 
         * @param assignmentId
         *        Assignment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentId(String assignmentId);

        /**
         * <p>
         * Assignment name.
         * </p>
         * 
         * @param assignmentName
         *        Assignment name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentName(String assignmentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the IAM policy.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) for the IAM policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * Identities.
         * </p>
         * 
         * @param identities
         *        Identities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(Map<String, ? extends Collection<String>> identities);

        /**
         * <p>
         * Assignment status.
         * </p>
         * 
         * @param assignmentStatus
         *        Assignment status.
         * @see AssignmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatus
         */
        Builder assignmentStatus(String assignmentStatus);

        /**
         * <p>
         * Assignment status.
         * </p>
         * 
         * @param assignmentStatus
         *        Assignment status.
         * @see AssignmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatus
         */
        Builder assignmentStatus(AssignmentStatus assignmentStatus);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String assignmentId;

        private String assignmentName;

        private String policyArn;

        private Map<String, List<String>> identities = DefaultSdkAutoConstructMap.getInstance();

        private String assignmentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(IAMPolicyAssignment model) {
            awsAccountId(model.awsAccountId);
            assignmentId(model.assignmentId);
            assignmentName(model.assignmentName);
            policyArn(model.policyArn);
            identities(model.identities);
            assignmentStatus(model.assignmentStatus);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAssignmentId() {
            return assignmentId;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        @Override
        @Transient
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final String getAssignmentName() {
            return assignmentName;
        }

        public final void setAssignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
        }

        @Override
        @Transient
        public final Builder assignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        @Transient
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getIdentities() {
            if (identities instanceof SdkAutoConstructMap) {
                return null;
            }
            return identities;
        }

        public final void setIdentities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
        }

        @Override
        @Transient
        public final Builder identities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
            return this;
        }

        public final String getAssignmentStatus() {
            return assignmentStatus;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        @Override
        @Transient
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        @Override
        public IAMPolicyAssignment build() {
            return new IAMPolicyAssignment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
