/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RowInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RowInfo> {
    private static final SdkField<Long> ROWS_INGESTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RowsIngested").getter(RowInfo.getter(RowInfo::rowsIngested)).setter(RowInfo.setter(Builder::rowsIngested)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowsIngested").build()}).build();
    private static final SdkField<Long> ROWS_DROPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RowsDropped").getter(RowInfo.getter(RowInfo::rowsDropped)).setter(RowInfo.setter(Builder::rowsDropped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowsDropped").build()}).build();
    private static final SdkField<Long> TOTAL_ROWS_IN_DATASET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalRowsInDataset").getter(RowInfo.getter(RowInfo::totalRowsInDataset)).setter(RowInfo.setter(Builder::totalRowsInDataset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRowsInDataset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_INGESTED_FIELD, ROWS_DROPPED_FIELD, TOTAL_ROWS_IN_DATASET_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long rowsIngested;
    private final Long rowsDropped;
    private final Long totalRowsInDataset;

    private RowInfo(BuilderImpl builder) {
        this.rowsIngested = builder.rowsIngested;
        this.rowsDropped = builder.rowsDropped;
        this.totalRowsInDataset = builder.totalRowsInDataset;
    }

    public final Long rowsIngested() {
        return this.rowsIngested;
    }

    public final Long rowsDropped() {
        return this.rowsDropped;
    }

    public final Long totalRowsInDataset() {
        return this.totalRowsInDataset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rowsIngested());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowsDropped());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRowsInDataset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowInfo)) {
            return false;
        }
        RowInfo other = (RowInfo)obj;
        return Objects.equals(this.rowsIngested(), other.rowsIngested()) && Objects.equals(this.rowsDropped(), other.rowsDropped()) && Objects.equals(this.totalRowsInDataset(), other.totalRowsInDataset());
    }

    public final String toString() {
        return ToString.builder((String)"RowInfo").add("RowsIngested", (Object)this.rowsIngested()).add("RowsDropped", (Object)this.rowsDropped()).add("TotalRowsInDataset", (Object)this.totalRowsInDataset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RowsIngested": {
                return Optional.ofNullable(clazz.cast(this.rowsIngested()));
            }
            case "RowsDropped": {
                return Optional.ofNullable(clazz.cast(this.rowsDropped()));
            }
            case "TotalRowsInDataset": {
                return Optional.ofNullable(clazz.cast(this.totalRowsInDataset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RowInfo, T> g) {
        return obj -> g.apply((RowInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long rowsIngested;
        private Long rowsDropped;
        private Long totalRowsInDataset;

        private BuilderImpl() {
        }

        private BuilderImpl(RowInfo model) {
            this.rowsIngested(model.rowsIngested);
            this.rowsDropped(model.rowsDropped);
            this.totalRowsInDataset(model.totalRowsInDataset);
        }

        public final Long getRowsIngested() {
            return this.rowsIngested;
        }

        public final void setRowsIngested(Long rowsIngested) {
            this.rowsIngested = rowsIngested;
        }

        @Override
        @Transient
        public final Builder rowsIngested(Long rowsIngested) {
            this.rowsIngested = rowsIngested;
            return this;
        }

        public final Long getRowsDropped() {
            return this.rowsDropped;
        }

        public final void setRowsDropped(Long rowsDropped) {
            this.rowsDropped = rowsDropped;
        }

        @Override
        @Transient
        public final Builder rowsDropped(Long rowsDropped) {
            this.rowsDropped = rowsDropped;
            return this;
        }

        public final Long getTotalRowsInDataset() {
            return this.totalRowsInDataset;
        }

        public final void setTotalRowsInDataset(Long totalRowsInDataset) {
            this.totalRowsInDataset = totalRowsInDataset;
        }

        @Override
        @Transient
        public final Builder totalRowsInDataset(Long totalRowsInDataset) {
            this.totalRowsInDataset = totalRowsInDataset;
            return this;
        }

        public RowInfo build() {
            return new RowInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RowInfo> {
        public Builder rowsIngested(Long var1);

        public Builder rowsDropped(Long var1);

        public Builder totalRowsInDataset(Long var1);
    }
}

