/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A physical table type built from the results of the custom SQL query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomSql implements SdkPojo, Serializable, ToCopyableBuilder<CustomSql.Builder, CustomSql> {
    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceArn").getter(getter(CustomSql::dataSourceArn)).setter(setter(Builder::dataSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CustomSql::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SQL_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SqlQuery").getter(getter(CustomSql::sqlQuery)).setter(setter(Builder::sqlQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlQuery").build()).build();

    private static final SdkField<List<InputColumn>> COLUMNS_FIELD = SdkField
            .<List<InputColumn>> builder(MarshallingType.LIST)
            .memberName("Columns")
            .getter(getter(CustomSql::columns))
            .setter(setter(Builder::columns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ARN_FIELD,
            NAME_FIELD, SQL_QUERY_FIELD, COLUMNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSourceArn;

    private final String name;

    private final String sqlQuery;

    private final List<InputColumn> columns;

    private CustomSql(BuilderImpl builder) {
        this.dataSourceArn = builder.dataSourceArn;
        this.name = builder.name;
        this.sqlQuery = builder.sqlQuery;
        this.columns = builder.columns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the data source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the data source.
     */
    public final String dataSourceArn() {
        return dataSourceArn;
    }

    /**
     * <p>
     * A display name for the SQL query result.
     * </p>
     * 
     * @return A display name for the SQL query result.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The SQL query.
     * </p>
     * 
     * @return The SQL query.
     */
    public final String sqlQuery() {
        return sqlQuery;
    }

    /**
     * Returns true if the Columns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasColumns() {
        return columns != null && !(columns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The column schema from the SQL query result set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasColumns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The column schema from the SQL query result set.
     */
    public final List<InputColumn> columns() {
        return columns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumns() ? columns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomSql)) {
            return false;
        }
        CustomSql other = (CustomSql) obj;
        return Objects.equals(dataSourceArn(), other.dataSourceArn()) && Objects.equals(name(), other.name())
                && Objects.equals(sqlQuery(), other.sqlQuery()) && hasColumns() == other.hasColumns()
                && Objects.equals(columns(), other.columns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomSql").add("DataSourceArn", dataSourceArn()).add("Name", name())
                .add("SqlQuery", sqlQuery()).add("Columns", hasColumns() ? columns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceArn":
            return Optional.ofNullable(clazz.cast(dataSourceArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SqlQuery":
            return Optional.ofNullable(clazz.cast(sqlQuery()));
        case "Columns":
            return Optional.ofNullable(clazz.cast(columns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomSql, T> g) {
        return obj -> g.apply((CustomSql) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomSql> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the data source.
         * </p>
         * 
         * @param dataSourceArn
         *        The Amazon Resource Name (ARN) of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceArn(String dataSourceArn);

        /**
         * <p>
         * A display name for the SQL query result.
         * </p>
         * 
         * @param name
         *        A display name for the SQL query result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The SQL query.
         * </p>
         * 
         * @param sqlQuery
         *        The SQL query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlQuery(String sqlQuery);

        /**
         * <p>
         * The column schema from the SQL query result set.
         * </p>
         * 
         * @param columns
         *        The column schema from the SQL query result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Collection<InputColumn> columns);

        /**
         * <p>
         * The column schema from the SQL query result set.
         * </p>
         * 
         * @param columns
         *        The column schema from the SQL query result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(InputColumn... columns);

        /**
         * <p>
         * The column schema from the SQL query result set.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InputColumn>.Builder} avoiding the need to
         * create one manually via {@link List<InputColumn>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputColumn>.Builder#build()} is called immediately and its
         * result is passed to {@link #columns(List<InputColumn>)}.
         * 
         * @param columns
         *        a consumer that will call methods on {@link List<InputColumn>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columns(List<InputColumn>)
         */
        Builder columns(Consumer<InputColumn.Builder>... columns);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceArn;

        private String name;

        private String sqlQuery;

        private List<InputColumn> columns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomSql model) {
            dataSourceArn(model.dataSourceArn);
            name(model.name);
            sqlQuery(model.sqlQuery);
            columns(model.columns);
        }

        public final String getDataSourceArn() {
            return dataSourceArn;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        @Override
        @Transient
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSqlQuery() {
            return sqlQuery;
        }

        public final void setSqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
        }

        @Override
        @Transient
        public final Builder sqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
            return this;
        }

        public final List<InputColumn.Builder> getColumns() {
            List<InputColumn.Builder> result = InputColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<InputColumn.BuilderImpl> columns) {
            this.columns = InputColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        @Transient
        public final Builder columns(Collection<InputColumn> columns) {
            this.columns = InputColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columns(InputColumn... columns) {
            columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columns(Consumer<InputColumn.Builder>... columns) {
            columns(Stream.of(columns).map(c -> InputColumn.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CustomSql build() {
            return new CustomSql(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
