/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The usage configuration to apply to child datasets that reference this dataset as a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetUsageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetUsageConfiguration.Builder, DataSetUsageConfiguration> {
    private static final SdkField<Boolean> DISABLE_USE_AS_DIRECT_QUERY_SOURCE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableUseAsDirectQuerySource")
            .getter(getter(DataSetUsageConfiguration::disableUseAsDirectQuerySource))
            .setter(setter(Builder::disableUseAsDirectQuerySource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableUseAsDirectQuerySource")
                    .build()).build();

    private static final SdkField<Boolean> DISABLE_USE_AS_IMPORTED_SOURCE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableUseAsImportedSource")
            .getter(getter(DataSetUsageConfiguration::disableUseAsImportedSource))
            .setter(setter(Builder::disableUseAsImportedSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableUseAsImportedSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DISABLE_USE_AS_DIRECT_QUERY_SOURCE_FIELD, DISABLE_USE_AS_IMPORTED_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean disableUseAsDirectQuerySource;

    private final Boolean disableUseAsImportedSource;

    private DataSetUsageConfiguration(BuilderImpl builder) {
        this.disableUseAsDirectQuerySource = builder.disableUseAsDirectQuerySource;
        this.disableUseAsImportedSource = builder.disableUseAsImportedSource;
    }

    /**
     * <p>
     * An option that controls whether a child dataset of a direct query can use this dataset as a source.
     * </p>
     * 
     * @return An option that controls whether a child dataset of a direct query can use this dataset as a source.
     */
    public final Boolean disableUseAsDirectQuerySource() {
        return disableUseAsDirectQuerySource;
    }

    /**
     * <p>
     * An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a source.
     * </p>
     * 
     * @return An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a
     *         source.
     */
    public final Boolean disableUseAsImportedSource() {
        return disableUseAsImportedSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disableUseAsDirectQuerySource());
        hashCode = 31 * hashCode + Objects.hashCode(disableUseAsImportedSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetUsageConfiguration)) {
            return false;
        }
        DataSetUsageConfiguration other = (DataSetUsageConfiguration) obj;
        return Objects.equals(disableUseAsDirectQuerySource(), other.disableUseAsDirectQuerySource())
                && Objects.equals(disableUseAsImportedSource(), other.disableUseAsImportedSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetUsageConfiguration")
                .add("DisableUseAsDirectQuerySource", disableUseAsDirectQuerySource())
                .add("DisableUseAsImportedSource", disableUseAsImportedSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisableUseAsDirectQuerySource":
            return Optional.ofNullable(clazz.cast(disableUseAsDirectQuerySource()));
        case "DisableUseAsImportedSource":
            return Optional.ofNullable(clazz.cast(disableUseAsImportedSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSetUsageConfiguration, T> g) {
        return obj -> g.apply((DataSetUsageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetUsageConfiguration> {
        /**
         * <p>
         * An option that controls whether a child dataset of a direct query can use this dataset as a source.
         * </p>
         * 
         * @param disableUseAsDirectQuerySource
         *        An option that controls whether a child dataset of a direct query can use this dataset as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableUseAsDirectQuerySource(Boolean disableUseAsDirectQuerySource);

        /**
         * <p>
         * An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a source.
         * </p>
         * 
         * @param disableUseAsImportedSource
         *        An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a
         *        source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableUseAsImportedSource(Boolean disableUseAsImportedSource);
    }

    static final class BuilderImpl implements Builder {
        private Boolean disableUseAsDirectQuerySource;

        private Boolean disableUseAsImportedSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetUsageConfiguration model) {
            disableUseAsDirectQuerySource(model.disableUseAsDirectQuerySource);
            disableUseAsImportedSource(model.disableUseAsImportedSource);
        }

        public final Boolean getDisableUseAsDirectQuerySource() {
            return disableUseAsDirectQuerySource;
        }

        public final void setDisableUseAsDirectQuerySource(Boolean disableUseAsDirectQuerySource) {
            this.disableUseAsDirectQuerySource = disableUseAsDirectQuerySource;
        }

        @Override
        @Transient
        public final Builder disableUseAsDirectQuerySource(Boolean disableUseAsDirectQuerySource) {
            this.disableUseAsDirectQuerySource = disableUseAsDirectQuerySource;
            return this;
        }

        public final Boolean getDisableUseAsImportedSource() {
            return disableUseAsImportedSource;
        }

        public final void setDisableUseAsImportedSource(Boolean disableUseAsImportedSource) {
            this.disableUseAsImportedSource = disableUseAsImportedSource;
        }

        @Override
        @Transient
        public final Builder disableUseAsImportedSource(Boolean disableUseAsImportedSource) {
            this.disableUseAsImportedSource = disableUseAsImportedSource;
            return this;
        }

        @Override
        public DataSetUsageConfiguration build() {
            return new DataSetUsageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
