/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterUserResponse extends QuickSightResponse implements
        ToCopyableBuilder<RegisterUserResponse.Builder, RegisterUserResponse> {
    private static final SdkField<User> USER_FIELD = SdkField.<User> builder(MarshallingType.SDK_POJO).memberName("User")
            .getter(getter(RegisterUserResponse::user)).setter(setter(Builder::user)).constructor(User::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final SdkField<String> USER_INVITATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserInvitationUrl").getter(getter(RegisterUserResponse::userInvitationUrl))
            .setter(setter(Builder::userInvitationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInvitationUrl").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(RegisterUserResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(RegisterUserResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD,
            USER_INVITATION_URL_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final User user;

    private final String userInvitationUrl;

    private final String requestId;

    private final Integer status;

    private RegisterUserResponse(BuilderImpl builder) {
        super(builder);
        this.user = builder.user;
        this.userInvitationUrl = builder.userInvitationUrl;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The user's user name.
     * </p>
     * 
     * @return The user's user name.
     */
    public final User user() {
        return user;
    }

    /**
     * <p>
     * The URL the user visits to complete registration and provide a password. This is returned only for users with an
     * identity type of <code>QUICKSIGHT</code>.
     * </p>
     * 
     * @return The URL the user visits to complete registration and provide a password. This is returned only for users
     *         with an identity type of <code>QUICKSIGHT</code>.
     */
    public final String userInvitationUrl() {
        return userInvitationUrl;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(userInvitationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterUserResponse)) {
            return false;
        }
        RegisterUserResponse other = (RegisterUserResponse) obj;
        return Objects.equals(user(), other.user()) && Objects.equals(userInvitationUrl(), other.userInvitationUrl())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterUserResponse").add("User", user()).add("UserInvitationUrl", userInvitationUrl())
                .add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "UserInvitationUrl":
            return Optional.ofNullable(clazz.cast(userInvitationUrl()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterUserResponse, T> g) {
        return obj -> g.apply((RegisterUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, RegisterUserResponse> {
        /**
         * <p>
         * The user's user name.
         * </p>
         * 
         * @param user
         *        The user's user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(User user);

        /**
         * <p>
         * The user's user name.
         * </p>
         * This is a convenience that creates an instance of the {@link User.Builder} avoiding the need to create one
         * manually via {@link User#builder()}.
         *
         * When the {@link Consumer} completes, {@link User.Builder#build()} is called immediately and its result is
         * passed to {@link #user(User)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link User.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(User)
         */
        default Builder user(Consumer<User.Builder> user) {
            return user(User.builder().applyMutation(user).build());
        }

        /**
         * <p>
         * The URL the user visits to complete registration and provide a password. This is returned only for users with
         * an identity type of <code>QUICKSIGHT</code>.
         * </p>
         * 
         * @param userInvitationUrl
         *        The URL the user visits to complete registration and provide a password. This is returned only for
         *        users with an identity type of <code>QUICKSIGHT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInvitationUrl(String userInvitationUrl);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private User user;

        private String userInvitationUrl;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterUserResponse model) {
            super(model);
            user(model.user);
            userInvitationUrl(model.userInvitationUrl);
            requestId(model.requestId);
            status(model.status);
        }

        public final User.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(User.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        @Transient
        public final Builder user(User user) {
            this.user = user;
            return this;
        }

        public final String getUserInvitationUrl() {
            return userInvitationUrl;
        }

        public final void setUserInvitationUrl(String userInvitationUrl) {
            this.userInvitationUrl = userInvitationUrl;
        }

        @Override
        @Transient
        public final Builder userInvitationUrl(String userInvitationUrl) {
            this.userInvitationUrl = userInvitationUrl;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        @Transient
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public RegisterUserResponse build() {
            return new RegisterUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
