/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The column group schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnGroupSchema implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnGroupSchema.Builder, ColumnGroupSchema> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ColumnGroupSchema::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<ColumnGroupColumnSchema>> COLUMN_GROUP_COLUMN_SCHEMA_LIST_FIELD = SdkField
            .<List<ColumnGroupColumnSchema>> builder(MarshallingType.LIST)
            .memberName("ColumnGroupColumnSchemaList")
            .getter(getter(ColumnGroupSchema::columnGroupColumnSchemaList))
            .setter(setter(Builder::columnGroupColumnSchemaList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnGroupColumnSchemaList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnGroupColumnSchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnGroupColumnSchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            COLUMN_GROUP_COLUMN_SCHEMA_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<ColumnGroupColumnSchema> columnGroupColumnSchemaList;

    private ColumnGroupSchema(BuilderImpl builder) {
        this.name = builder.name;
        this.columnGroupColumnSchemaList = builder.columnGroupColumnSchemaList;
    }

    /**
     * <p>
     * The name of the column group schema.
     * </p>
     * 
     * @return The name of the column group schema.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the ColumnGroupColumnSchemaList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasColumnGroupColumnSchemaList() {
        return columnGroupColumnSchemaList != null && !(columnGroupColumnSchemaList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure containing the list of schemas for column group columns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasColumnGroupColumnSchemaList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A structure containing the list of schemas for column group columns.
     */
    public final List<ColumnGroupColumnSchema> columnGroupColumnSchemaList() {
        return columnGroupColumnSchemaList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnGroupColumnSchemaList() ? columnGroupColumnSchemaList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnGroupSchema)) {
            return false;
        }
        ColumnGroupSchema other = (ColumnGroupSchema) obj;
        return Objects.equals(name(), other.name()) && hasColumnGroupColumnSchemaList() == other.hasColumnGroupColumnSchemaList()
                && Objects.equals(columnGroupColumnSchemaList(), other.columnGroupColumnSchemaList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnGroupSchema").add("Name", name())
                .add("ColumnGroupColumnSchemaList", hasColumnGroupColumnSchemaList() ? columnGroupColumnSchemaList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ColumnGroupColumnSchemaList":
            return Optional.ofNullable(clazz.cast(columnGroupColumnSchemaList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnGroupSchema, T> g) {
        return obj -> g.apply((ColumnGroupSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnGroupSchema> {
        /**
         * <p>
         * The name of the column group schema.
         * </p>
         * 
         * @param name
         *        The name of the column group schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A structure containing the list of schemas for column group columns.
         * </p>
         * 
         * @param columnGroupColumnSchemaList
         *        A structure containing the list of schemas for column group columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnGroupColumnSchemaList(Collection<ColumnGroupColumnSchema> columnGroupColumnSchemaList);

        /**
         * <p>
         * A structure containing the list of schemas for column group columns.
         * </p>
         * 
         * @param columnGroupColumnSchemaList
         *        A structure containing the list of schemas for column group columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnGroupColumnSchemaList(ColumnGroupColumnSchema... columnGroupColumnSchemaList);

        /**
         * <p>
         * A structure containing the list of schemas for column group columns.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ColumnGroupColumnSchema>.Builder} avoiding
         * the need to create one manually via {@link List<ColumnGroupColumnSchema>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnGroupColumnSchema>.Builder#build()} is called
         * immediately and its result is passed to {@link #columnGroupColumnSchemaList(List<ColumnGroupColumnSchema>)}.
         * 
         * @param columnGroupColumnSchemaList
         *        a consumer that will call methods on {@link List<ColumnGroupColumnSchema>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnGroupColumnSchemaList(List<ColumnGroupColumnSchema>)
         */
        Builder columnGroupColumnSchemaList(Consumer<ColumnGroupColumnSchema.Builder>... columnGroupColumnSchemaList);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<ColumnGroupColumnSchema> columnGroupColumnSchemaList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnGroupSchema model) {
            name(model.name);
            columnGroupColumnSchemaList(model.columnGroupColumnSchemaList);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ColumnGroupColumnSchema.Builder> getColumnGroupColumnSchemaList() {
            List<ColumnGroupColumnSchema.Builder> result = ColumnGroupColumnSchemaListCopier
                    .copyToBuilder(this.columnGroupColumnSchemaList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnGroupColumnSchemaList(
                Collection<ColumnGroupColumnSchema.BuilderImpl> columnGroupColumnSchemaList) {
            this.columnGroupColumnSchemaList = ColumnGroupColumnSchemaListCopier.copyFromBuilder(columnGroupColumnSchemaList);
        }

        @Override
        @Transient
        public final Builder columnGroupColumnSchemaList(Collection<ColumnGroupColumnSchema> columnGroupColumnSchemaList) {
            this.columnGroupColumnSchemaList = ColumnGroupColumnSchemaListCopier.copy(columnGroupColumnSchemaList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnGroupColumnSchemaList(ColumnGroupColumnSchema... columnGroupColumnSchemaList) {
            columnGroupColumnSchemaList(Arrays.asList(columnGroupColumnSchemaList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnGroupColumnSchemaList(Consumer<ColumnGroupColumnSchema.Builder>... columnGroupColumnSchemaList) {
            columnGroupColumnSchemaList(Stream.of(columnGroupColumnSchemaList)
                    .map(c -> ColumnGroupColumnSchema.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ColumnGroupSchema build() {
            return new ColumnGroupSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
