/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTemplateAliasRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateTemplateAliasRequest.Builder, CreateTemplateAliasRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateTemplateAliasRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(CreateTemplateAliasRequest::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateId").build()).build();

    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasName").getter(getter(CreateTemplateAliasRequest::aliasName)).setter(setter(Builder::aliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AliasName").build()).build();

    private static final SdkField<Long> TEMPLATE_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TemplateVersionNumber").getter(getter(CreateTemplateAliasRequest::templateVersionNumber))
            .setter(setter(Builder::templateVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            TEMPLATE_ID_FIELD, ALIAS_NAME_FIELD, TEMPLATE_VERSION_NUMBER_FIELD));

    private final String awsAccountId;

    private final String templateId;

    private final String aliasName;

    private final Long templateVersionNumber;

    private CreateTemplateAliasRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.templateId = builder.templateId;
        this.aliasName = builder.aliasName;
        this.templateVersionNumber = builder.templateVersionNumber;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account; that contains the template that you creating an alias for.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account; that contains the template that you creating an alias for.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * An ID for the template.
     * </p>
     * 
     * @return An ID for the template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The name that you want to give to the template alias that you're creating. Don't start the alias name with the
     * <code>$</code> character. Alias names that start with <code>$</code> are reserved by Amazon QuickSight.
     * </p>
     * 
     * @return The name that you want to give to the template alias that you're creating. Don't start the alias name
     *         with the <code>$</code> character. Alias names that start with <code>$</code> are reserved by Amazon
     *         QuickSight.
     */
    public final String aliasName() {
        return aliasName;
    }

    /**
     * <p>
     * The version number of the template.
     * </p>
     * 
     * @return The version number of the template.
     */
    public final Long templateVersionNumber() {
        return templateVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(templateVersionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTemplateAliasRequest)) {
            return false;
        }
        CreateTemplateAliasRequest other = (CreateTemplateAliasRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(aliasName(), other.aliasName())
                && Objects.equals(templateVersionNumber(), other.templateVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTemplateAliasRequest").add("AwsAccountId", awsAccountId()).add("TemplateId", templateId())
                .add("AliasName", aliasName()).add("TemplateVersionNumber", templateVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "AliasName":
            return Optional.ofNullable(clazz.cast(aliasName()));
        case "TemplateVersionNumber":
            return Optional.ofNullable(clazz.cast(templateVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTemplateAliasRequest, T> g) {
        return obj -> g.apply((CreateTemplateAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTemplateAliasRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account; that contains the template that you creating an alias for.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account; that contains the template that you creating an alias for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * An ID for the template.
         * </p>
         * 
         * @param templateId
         *        An ID for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The name that you want to give to the template alias that you're creating. Don't start the alias name with
         * the <code>$</code> character. Alias names that start with <code>$</code> are reserved by Amazon QuickSight.
         * </p>
         * 
         * @param aliasName
         *        The name that you want to give to the template alias that you're creating. Don't start the alias name
         *        with the <code>$</code> character. Alias names that start with <code>$</code> are reserved by Amazon
         *        QuickSight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);

        /**
         * <p>
         * The version number of the template.
         * </p>
         * 
         * @param templateVersionNumber
         *        The version number of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateVersionNumber(Long templateVersionNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String templateId;

        private String aliasName;

        private Long templateVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTemplateAliasRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            templateId(model.templateId);
            aliasName(model.aliasName);
            templateVersionNumber(model.templateVersionNumber);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        @Transient
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getAliasName() {
            return aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        @Transient
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final Long getTemplateVersionNumber() {
            return templateVersionNumber;
        }

        public final void setTemplateVersionNumber(Long templateVersionNumber) {
            this.templateVersionNumber = templateVersionNumber;
        }

        @Override
        @Transient
        public final Builder templateVersionNumber(Long templateVersionNumber) {
            this.templateVersionNumber = templateVersionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTemplateAliasRequest build() {
            return new CreateTemplateAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
