/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of Amazon QuickSight parameters and the list's override values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Parameters implements SdkPojo, Serializable, ToCopyableBuilder<Parameters.Builder, Parameters> {
    private static final SdkField<List<StringParameter>> STRING_PARAMETERS_FIELD = SdkField
            .<List<StringParameter>> builder(MarshallingType.LIST)
            .memberName("StringParameters")
            .getter(getter(Parameters::stringParameters))
            .setter(setter(Builder::stringParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IntegerParameter>> INTEGER_PARAMETERS_FIELD = SdkField
            .<List<IntegerParameter>> builder(MarshallingType.LIST)
            .memberName("IntegerParameters")
            .getter(getter(Parameters::integerParameters))
            .setter(setter(Builder::integerParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntegerParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegerParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DecimalParameter>> DECIMAL_PARAMETERS_FIELD = SdkField
            .<List<DecimalParameter>> builder(MarshallingType.LIST)
            .memberName("DecimalParameters")
            .getter(getter(Parameters::decimalParameters))
            .setter(setter(Builder::decimalParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DecimalParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DecimalParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateTimeParameter>> DATE_TIME_PARAMETERS_FIELD = SdkField
            .<List<DateTimeParameter>> builder(MarshallingType.LIST)
            .memberName("DateTimeParameters")
            .getter(getter(Parameters::dateTimeParameters))
            .setter(setter(Builder::dateTimeParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateTimeParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateTimeParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_PARAMETERS_FIELD,
            INTEGER_PARAMETERS_FIELD, DECIMAL_PARAMETERS_FIELD, DATE_TIME_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StringParameter> stringParameters;

    private final List<IntegerParameter> integerParameters;

    private final List<DecimalParameter> decimalParameters;

    private final List<DateTimeParameter> dateTimeParameters;

    private Parameters(BuilderImpl builder) {
        this.stringParameters = builder.stringParameters;
        this.integerParameters = builder.integerParameters;
        this.decimalParameters = builder.decimalParameters;
        this.dateTimeParameters = builder.dateTimeParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringParameters() {
        return stringParameters != null && !(stringParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters that have a data type of string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringParameters} method.
     * </p>
     * 
     * @return The parameters that have a data type of string.
     */
    public final List<StringParameter> stringParameters() {
        return stringParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the IntegerParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntegerParameters() {
        return integerParameters != null && !(integerParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters that have a data type of integer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegerParameters} method.
     * </p>
     * 
     * @return The parameters that have a data type of integer.
     */
    public final List<IntegerParameter> integerParameters() {
        return integerParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the DecimalParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDecimalParameters() {
        return decimalParameters != null && !(decimalParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters that have a data type of decimal.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDecimalParameters} method.
     * </p>
     * 
     * @return The parameters that have a data type of decimal.
     */
    public final List<DecimalParameter> decimalParameters() {
        return decimalParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the DateTimeParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDateTimeParameters() {
        return dateTimeParameters != null && !(dateTimeParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters that have a data type of date-time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDateTimeParameters} method.
     * </p>
     * 
     * @return The parameters that have a data type of date-time.
     */
    public final List<DateTimeParameter> dateTimeParameters() {
        return dateTimeParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStringParameters() ? stringParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegerParameters() ? integerParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDecimalParameters() ? decimalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDateTimeParameters() ? dateTimeParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters) obj;
        return hasStringParameters() == other.hasStringParameters()
                && Objects.equals(stringParameters(), other.stringParameters())
                && hasIntegerParameters() == other.hasIntegerParameters()
                && Objects.equals(integerParameters(), other.integerParameters())
                && hasDecimalParameters() == other.hasDecimalParameters()
                && Objects.equals(decimalParameters(), other.decimalParameters())
                && hasDateTimeParameters() == other.hasDateTimeParameters()
                && Objects.equals(dateTimeParameters(), other.dateTimeParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Parameters").add("StringParameters", hasStringParameters() ? stringParameters() : null)
                .add("IntegerParameters", hasIntegerParameters() ? integerParameters() : null)
                .add("DecimalParameters", hasDecimalParameters() ? decimalParameters() : null)
                .add("DateTimeParameters", hasDateTimeParameters() ? dateTimeParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringParameters":
            return Optional.ofNullable(clazz.cast(stringParameters()));
        case "IntegerParameters":
            return Optional.ofNullable(clazz.cast(integerParameters()));
        case "DecimalParameters":
            return Optional.ofNullable(clazz.cast(decimalParameters()));
        case "DateTimeParameters":
            return Optional.ofNullable(clazz.cast(dateTimeParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Parameters, T> g) {
        return obj -> g.apply((Parameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Parameters> {
        /**
         * <p>
         * The parameters that have a data type of string.
         * </p>
         * 
         * @param stringParameters
         *        The parameters that have a data type of string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringParameters(Collection<StringParameter> stringParameters);

        /**
         * <p>
         * The parameters that have a data type of string.
         * </p>
         * 
         * @param stringParameters
         *        The parameters that have a data type of string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringParameters(StringParameter... stringParameters);

        /**
         * <p>
         * The parameters that have a data type of string.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringParameter>.Builder} avoiding the need
         * to create one manually via {@link List<StringParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringParameter>.Builder#build()} is called immediately and
         * its result is passed to {@link #stringParameters(List<StringParameter>)}.
         * 
         * @param stringParameters
         *        a consumer that will call methods on {@link List<StringParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringParameters(List<StringParameter>)
         */
        Builder stringParameters(Consumer<StringParameter.Builder>... stringParameters);

        /**
         * <p>
         * The parameters that have a data type of integer.
         * </p>
         * 
         * @param integerParameters
         *        The parameters that have a data type of integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerParameters(Collection<IntegerParameter> integerParameters);

        /**
         * <p>
         * The parameters that have a data type of integer.
         * </p>
         * 
         * @param integerParameters
         *        The parameters that have a data type of integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerParameters(IntegerParameter... integerParameters);

        /**
         * <p>
         * The parameters that have a data type of integer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IntegerParameter>.Builder} avoiding the
         * need to create one manually via {@link List<IntegerParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IntegerParameter>.Builder#build()} is called immediately and
         * its result is passed to {@link #integerParameters(List<IntegerParameter>)}.
         * 
         * @param integerParameters
         *        a consumer that will call methods on {@link List<IntegerParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integerParameters(List<IntegerParameter>)
         */
        Builder integerParameters(Consumer<IntegerParameter.Builder>... integerParameters);

        /**
         * <p>
         * The parameters that have a data type of decimal.
         * </p>
         * 
         * @param decimalParameters
         *        The parameters that have a data type of decimal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalParameters(Collection<DecimalParameter> decimalParameters);

        /**
         * <p>
         * The parameters that have a data type of decimal.
         * </p>
         * 
         * @param decimalParameters
         *        The parameters that have a data type of decimal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalParameters(DecimalParameter... decimalParameters);

        /**
         * <p>
         * The parameters that have a data type of decimal.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DecimalParameter>.Builder} avoiding the
         * need to create one manually via {@link List<DecimalParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DecimalParameter>.Builder#build()} is called immediately and
         * its result is passed to {@link #decimalParameters(List<DecimalParameter>)}.
         * 
         * @param decimalParameters
         *        a consumer that will call methods on {@link List<DecimalParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decimalParameters(List<DecimalParameter>)
         */
        Builder decimalParameters(Consumer<DecimalParameter.Builder>... decimalParameters);

        /**
         * <p>
         * The parameters that have a data type of date-time.
         * </p>
         * 
         * @param dateTimeParameters
         *        The parameters that have a data type of date-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeParameters(Collection<DateTimeParameter> dateTimeParameters);

        /**
         * <p>
         * The parameters that have a data type of date-time.
         * </p>
         * 
         * @param dateTimeParameters
         *        The parameters that have a data type of date-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeParameters(DateTimeParameter... dateTimeParameters);

        /**
         * <p>
         * The parameters that have a data type of date-time.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateTimeParameter>.Builder} avoiding the
         * need to create one manually via {@link List<DateTimeParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateTimeParameter>.Builder#build()} is called immediately
         * and its result is passed to {@link #dateTimeParameters(List<DateTimeParameter>)}.
         * 
         * @param dateTimeParameters
         *        a consumer that will call methods on {@link List<DateTimeParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateTimeParameters(List<DateTimeParameter>)
         */
        Builder dateTimeParameters(Consumer<DateTimeParameter.Builder>... dateTimeParameters);
    }

    static final class BuilderImpl implements Builder {
        private List<StringParameter> stringParameters = DefaultSdkAutoConstructList.getInstance();

        private List<IntegerParameter> integerParameters = DefaultSdkAutoConstructList.getInstance();

        private List<DecimalParameter> decimalParameters = DefaultSdkAutoConstructList.getInstance();

        private List<DateTimeParameter> dateTimeParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Parameters model) {
            stringParameters(model.stringParameters);
            integerParameters(model.integerParameters);
            decimalParameters(model.decimalParameters);
            dateTimeParameters(model.dateTimeParameters);
        }

        public final List<StringParameter.Builder> getStringParameters() {
            List<StringParameter.Builder> result = StringParameterListCopier.copyToBuilder(this.stringParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringParameters(Collection<StringParameter.BuilderImpl> stringParameters) {
            this.stringParameters = StringParameterListCopier.copyFromBuilder(stringParameters);
        }

        @Override
        @Transient
        public final Builder stringParameters(Collection<StringParameter> stringParameters) {
            this.stringParameters = StringParameterListCopier.copy(stringParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stringParameters(StringParameter... stringParameters) {
            stringParameters(Arrays.asList(stringParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stringParameters(Consumer<StringParameter.Builder>... stringParameters) {
            stringParameters(Stream.of(stringParameters).map(c -> StringParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<IntegerParameter.Builder> getIntegerParameters() {
            List<IntegerParameter.Builder> result = IntegerParameterListCopier.copyToBuilder(this.integerParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegerParameters(Collection<IntegerParameter.BuilderImpl> integerParameters) {
            this.integerParameters = IntegerParameterListCopier.copyFromBuilder(integerParameters);
        }

        @Override
        @Transient
        public final Builder integerParameters(Collection<IntegerParameter> integerParameters) {
            this.integerParameters = IntegerParameterListCopier.copy(integerParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder integerParameters(IntegerParameter... integerParameters) {
            integerParameters(Arrays.asList(integerParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder integerParameters(Consumer<IntegerParameter.Builder>... integerParameters) {
            integerParameters(Stream.of(integerParameters).map(c -> IntegerParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DecimalParameter.Builder> getDecimalParameters() {
            List<DecimalParameter.Builder> result = DecimalParameterListCopier.copyToBuilder(this.decimalParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDecimalParameters(Collection<DecimalParameter.BuilderImpl> decimalParameters) {
            this.decimalParameters = DecimalParameterListCopier.copyFromBuilder(decimalParameters);
        }

        @Override
        @Transient
        public final Builder decimalParameters(Collection<DecimalParameter> decimalParameters) {
            this.decimalParameters = DecimalParameterListCopier.copy(decimalParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder decimalParameters(DecimalParameter... decimalParameters) {
            decimalParameters(Arrays.asList(decimalParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder decimalParameters(Consumer<DecimalParameter.Builder>... decimalParameters) {
            decimalParameters(Stream.of(decimalParameters).map(c -> DecimalParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DateTimeParameter.Builder> getDateTimeParameters() {
            List<DateTimeParameter.Builder> result = DateTimeParameterListCopier.copyToBuilder(this.dateTimeParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDateTimeParameters(Collection<DateTimeParameter.BuilderImpl> dateTimeParameters) {
            this.dateTimeParameters = DateTimeParameterListCopier.copyFromBuilder(dateTimeParameters);
        }

        @Override
        @Transient
        public final Builder dateTimeParameters(Collection<DateTimeParameter> dateTimeParameters) {
            this.dateTimeParameters = DateTimeParameterListCopier.copy(dateTimeParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dateTimeParameters(DateTimeParameter... dateTimeParameters) {
            dateTimeParameters(Arrays.asList(dateTimeParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dateTimeParameters(Consumer<DateTimeParameter.Builder>... dateTimeParameters) {
            dateTimeParameters(Stream.of(dateTimeParameters).map(c -> DateTimeParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Parameters build() {
            return new Parameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
