/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.LinkSharingConfiguration;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;
import software.amazon.awssdk.services.quicksight.model.ResourcePermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDashboardPermissionsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateDashboardPermissionsResponse> {
    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardArn").getter(UpdateDashboardPermissionsResponse.getter(UpdateDashboardPermissionsResponse::dashboardArn)).setter(UpdateDashboardPermissionsResponse.setter(Builder::dashboardArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()}).build();
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(UpdateDashboardPermissionsResponse.getter(UpdateDashboardPermissionsResponse::dashboardId)).setter(UpdateDashboardPermissionsResponse.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()}).build();
    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(UpdateDashboardPermissionsResponse.getter(UpdateDashboardPermissionsResponse::permissions)).setter(UpdateDashboardPermissionsResponse.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateDashboardPermissionsResponse.getter(UpdateDashboardPermissionsResponse::requestId)).setter(UpdateDashboardPermissionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(UpdateDashboardPermissionsResponse.getter(UpdateDashboardPermissionsResponse::status)).setter(UpdateDashboardPermissionsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<LinkSharingConfiguration> LINK_SHARING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LinkSharingConfiguration").getter(UpdateDashboardPermissionsResponse.getter(UpdateDashboardPermissionsResponse::linkSharingConfiguration)).setter(UpdateDashboardPermissionsResponse.setter(Builder::linkSharingConfiguration)).constructor(LinkSharingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkSharingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ARN_FIELD, DASHBOARD_ID_FIELD, PERMISSIONS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD, LINK_SHARING_CONFIGURATION_FIELD));
    private final String dashboardArn;
    private final String dashboardId;
    private final List<ResourcePermission> permissions;
    private final String requestId;
    private final Integer status;
    private final LinkSharingConfiguration linkSharingConfiguration;

    private UpdateDashboardPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardArn = builder.dashboardArn;
        this.dashboardId = builder.dashboardId;
        this.permissions = builder.permissions;
        this.requestId = builder.requestId;
        this.status = builder.status;
        this.linkSharingConfiguration = builder.linkSharingConfiguration;
    }

    public final String dashboardArn() {
        return this.dashboardArn;
    }

    public final String dashboardId() {
        return this.dashboardId;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> permissions() {
        return this.permissions;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final LinkSharingConfiguration linkSharingConfiguration() {
        return this.linkSharingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkSharingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardPermissionsResponse)) {
            return false;
        }
        UpdateDashboardPermissionsResponse other = (UpdateDashboardPermissionsResponse)((Object)obj);
        return Objects.equals(this.dashboardArn(), other.dashboardArn()) && Objects.equals(this.dashboardId(), other.dashboardId()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.linkSharingConfiguration(), other.linkSharingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDashboardPermissionsResponse").add("DashboardArn", (Object)this.dashboardArn()).add("DashboardId", (Object)this.dashboardId()).add("Permissions", this.hasPermissions() ? this.permissions() : null).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).add("LinkSharingConfiguration", (Object)this.linkSharingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardArn": {
                return Optional.ofNullable(clazz.cast(this.dashboardArn()));
            }
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "LinkSharingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.linkSharingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardPermissionsResponse, T> g) {
        return obj -> g.apply((UpdateDashboardPermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String dashboardArn;
        private String dashboardId;
        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();
        private String requestId;
        private Integer status;
        private LinkSharingConfiguration linkSharingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardPermissionsResponse model) {
            super(model);
            this.dashboardArn(model.dashboardArn);
            this.dashboardId(model.dashboardId);
            this.permissions(model.permissions);
            this.requestId(model.requestId);
            this.status(model.status);
            this.linkSharingConfiguration(model.linkSharingConfiguration);
        }

        public final String getDashboardArn() {
            return this.dashboardArn;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        @Override
        @Transient
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        @Transient
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        @Transient
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissions(ResourcePermission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder> ... permissions) {
            this.permissions(Stream.of(permissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        @Transient
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final LinkSharingConfiguration.Builder getLinkSharingConfiguration() {
            return this.linkSharingConfiguration != null ? this.linkSharingConfiguration.toBuilder() : null;
        }

        public final void setLinkSharingConfiguration(LinkSharingConfiguration.BuilderImpl linkSharingConfiguration) {
            this.linkSharingConfiguration = linkSharingConfiguration != null ? linkSharingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder linkSharingConfiguration(LinkSharingConfiguration linkSharingConfiguration) {
            this.linkSharingConfiguration = linkSharingConfiguration;
            return this;
        }

        @Override
        public UpdateDashboardPermissionsResponse build() {
            return new UpdateDashboardPermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDashboardPermissionsResponse> {
        public Builder dashboardArn(String var1);

        public Builder dashboardId(String var1);

        public Builder permissions(Collection<ResourcePermission> var1);

        public Builder permissions(ResourcePermission ... var1);

        public Builder permissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);

        public Builder linkSharingConfiguration(LinkSharingConfiguration var1);

        default public Builder linkSharingConfiguration(Consumer<LinkSharingConfiguration.Builder> linkSharingConfiguration) {
            return this.linkSharingConfiguration((LinkSharingConfiguration)((LinkSharingConfiguration.Builder)LinkSharingConfiguration.builder().applyMutation(linkSharingConfiguration)).build());
        }
    }
}

