/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAnalysisRequest extends QuickSightRequest implements
        ToCopyableBuilder<DeleteAnalysisRequest.Builder, DeleteAnalysisRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(DeleteAnalysisRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisId").getter(getter(DeleteAnalysisRequest::analysisId)).setter(setter(Builder::analysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AnalysisId").build()).build();

    private static final SdkField<Long> RECOVERY_WINDOW_IN_DAYS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("RecoveryWindowInDays")
            .getter(getter(DeleteAnalysisRequest::recoveryWindowInDays))
            .setter(setter(Builder::recoveryWindowInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recovery-window-in-days")
                    .build()).build();

    private static final SdkField<Boolean> FORCE_DELETE_WITHOUT_RECOVERY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceDeleteWithoutRecovery")
            .getter(getter(DeleteAnalysisRequest::forceDeleteWithoutRecovery))
            .setter(setter(Builder::forceDeleteWithoutRecovery))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("force-delete-without-recovery")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            ANALYSIS_ID_FIELD, RECOVERY_WINDOW_IN_DAYS_FIELD, FORCE_DELETE_WITHOUT_RECOVERY_FIELD));

    private final String awsAccountId;

    private final String analysisId;

    private final Long recoveryWindowInDays;

    private final Boolean forceDeleteWithoutRecovery;

    private DeleteAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.analysisId = builder.analysisId;
        this.recoveryWindowInDays = builder.recoveryWindowInDays;
        this.forceDeleteWithoutRecovery = builder.forceDeleteWithoutRecovery;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account; where you want to delete an analysis.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account; where you want to delete an analysis.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the analysis that you're deleting.
     * </p>
     * 
     * @return The ID of the analysis that you're deleting.
     */
    public final String analysisId() {
        return analysisId;
    }

    /**
     * <p>
     * A value that specifies the number of days that QuickSight waits before it deletes the analysis. You can't use
     * this parameter with the <code>ForceDeleteWithoutRecovery</code> option in the same API call. The default value is
     * 30.
     * </p>
     * 
     * @return A value that specifies the number of days that QuickSight waits before it deletes the analysis. You can't
     *         use this parameter with the <code>ForceDeleteWithoutRecovery</code> option in the same API call. The
     *         default value is 30.
     */
    public final Long recoveryWindowInDays() {
        return recoveryWindowInDays;
    }

    /**
     * <p>
     * This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To immediately delete the analysis,
     * add the <code>ForceDeleteWithoutRecovery</code> option. You can't restore an analysis after it's deleted.
     * </p>
     * 
     * @return This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To immediately delete the
     *         analysis, add the <code>ForceDeleteWithoutRecovery</code> option. You can't restore an analysis after
     *         it's deleted.
     */
    public final Boolean forceDeleteWithoutRecovery() {
        return forceDeleteWithoutRecovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryWindowInDays());
        hashCode = 31 * hashCode + Objects.hashCode(forceDeleteWithoutRecovery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAnalysisRequest)) {
            return false;
        }
        DeleteAnalysisRequest other = (DeleteAnalysisRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(analysisId(), other.analysisId())
                && Objects.equals(recoveryWindowInDays(), other.recoveryWindowInDays())
                && Objects.equals(forceDeleteWithoutRecovery(), other.forceDeleteWithoutRecovery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAnalysisRequest").add("AwsAccountId", awsAccountId()).add("AnalysisId", analysisId())
                .add("RecoveryWindowInDays", recoveryWindowInDays())
                .add("ForceDeleteWithoutRecovery", forceDeleteWithoutRecovery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AnalysisId":
            return Optional.ofNullable(clazz.cast(analysisId()));
        case "RecoveryWindowInDays":
            return Optional.ofNullable(clazz.cast(recoveryWindowInDays()));
        case "ForceDeleteWithoutRecovery":
            return Optional.ofNullable(clazz.cast(forceDeleteWithoutRecovery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAnalysisRequest, T> g) {
        return obj -> g.apply((DeleteAnalysisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAnalysisRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account; where you want to delete an analysis.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account; where you want to delete an analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the analysis that you're deleting.
         * </p>
         * 
         * @param analysisId
         *        The ID of the analysis that you're deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisId(String analysisId);

        /**
         * <p>
         * A value that specifies the number of days that QuickSight waits before it deletes the analysis. You can't use
         * this parameter with the <code>ForceDeleteWithoutRecovery</code> option in the same API call. The default
         * value is 30.
         * </p>
         * 
         * @param recoveryWindowInDays
         *        A value that specifies the number of days that QuickSight waits before it deletes the analysis. You
         *        can't use this parameter with the <code>ForceDeleteWithoutRecovery</code> option in the same API call.
         *        The default value is 30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryWindowInDays(Long recoveryWindowInDays);

        /**
         * <p>
         * This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To immediately delete the
         * analysis, add the <code>ForceDeleteWithoutRecovery</code> option. You can't restore an analysis after it's
         * deleted.
         * </p>
         * 
         * @param forceDeleteWithoutRecovery
         *        This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To immediately delete the
         *        analysis, add the <code>ForceDeleteWithoutRecovery</code> option. You can't restore an analysis after
         *        it's deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDeleteWithoutRecovery(Boolean forceDeleteWithoutRecovery);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String analysisId;

        private Long recoveryWindowInDays;

        private Boolean forceDeleteWithoutRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAnalysisRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            analysisId(model.analysisId);
            recoveryWindowInDays(model.recoveryWindowInDays);
            forceDeleteWithoutRecovery(model.forceDeleteWithoutRecovery);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAnalysisId() {
            return analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        @Transient
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final Long getRecoveryWindowInDays() {
            return recoveryWindowInDays;
        }

        public final void setRecoveryWindowInDays(Long recoveryWindowInDays) {
            this.recoveryWindowInDays = recoveryWindowInDays;
        }

        @Override
        @Transient
        public final Builder recoveryWindowInDays(Long recoveryWindowInDays) {
            this.recoveryWindowInDays = recoveryWindowInDays;
            return this;
        }

        public final Boolean getForceDeleteWithoutRecovery() {
            return forceDeleteWithoutRecovery;
        }

        public final void setForceDeleteWithoutRecovery(Boolean forceDeleteWithoutRecovery) {
            this.forceDeleteWithoutRecovery = forceDeleteWithoutRecovery;
        }

        @Override
        @Transient
        public final Builder forceDeleteWithoutRecovery(Boolean forceDeleteWithoutRecovery) {
            this.forceDeleteWithoutRecovery = forceDeleteWithoutRecovery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAnalysisRequest build() {
            return new DeleteAnalysisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
