/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A tag for a column in a
 * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_TagColumnOperation.html">TagColumnOperation</a> </code>
 * structure. This is a variant type structure. For this structure to be valid, only one of the attributes can be
 * non-null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnTag implements SdkPojo, Serializable, ToCopyableBuilder<ColumnTag.Builder, ColumnTag> {
    private static final SdkField<String> COLUMN_GEOGRAPHIC_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnGeographicRole").getter(getter(ColumnTag::columnGeographicRoleAsString))
            .setter(setter(Builder::columnGeographicRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnGeographicRole").build())
            .build();

    private static final SdkField<ColumnDescription> COLUMN_DESCRIPTION_FIELD = SdkField
            .<ColumnDescription> builder(MarshallingType.SDK_POJO).memberName("ColumnDescription")
            .getter(getter(ColumnTag::columnDescription)).setter(setter(Builder::columnDescription))
            .constructor(ColumnDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_GEOGRAPHIC_ROLE_FIELD,
            COLUMN_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String columnGeographicRole;

    private final ColumnDescription columnDescription;

    private ColumnTag(BuilderImpl builder) {
        this.columnGeographicRole = builder.columnGeographicRole;
        this.columnDescription = builder.columnDescription;
    }

    /**
     * <p>
     * A geospatial role for a column.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #columnGeographicRole} will return {@link GeoSpatialDataRole#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #columnGeographicRoleAsString}.
     * </p>
     * 
     * @return A geospatial role for a column.
     * @see GeoSpatialDataRole
     */
    public final GeoSpatialDataRole columnGeographicRole() {
        return GeoSpatialDataRole.fromValue(columnGeographicRole);
    }

    /**
     * <p>
     * A geospatial role for a column.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #columnGeographicRole} will return {@link GeoSpatialDataRole#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #columnGeographicRoleAsString}.
     * </p>
     * 
     * @return A geospatial role for a column.
     * @see GeoSpatialDataRole
     */
    public final String columnGeographicRoleAsString() {
        return columnGeographicRole;
    }

    /**
     * <p>
     * A description for a column.
     * </p>
     * 
     * @return A description for a column.
     */
    public final ColumnDescription columnDescription() {
        return columnDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnGeographicRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(columnDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnTag)) {
            return false;
        }
        ColumnTag other = (ColumnTag) obj;
        return Objects.equals(columnGeographicRoleAsString(), other.columnGeographicRoleAsString())
                && Objects.equals(columnDescription(), other.columnDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnTag").add("ColumnGeographicRole", columnGeographicRoleAsString())
                .add("ColumnDescription", columnDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnGeographicRole":
            return Optional.ofNullable(clazz.cast(columnGeographicRoleAsString()));
        case "ColumnDescription":
            return Optional.ofNullable(clazz.cast(columnDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnTag, T> g) {
        return obj -> g.apply((ColumnTag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnTag> {
        /**
         * <p>
         * A geospatial role for a column.
         * </p>
         * 
         * @param columnGeographicRole
         *        A geospatial role for a column.
         * @see GeoSpatialDataRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeoSpatialDataRole
         */
        Builder columnGeographicRole(String columnGeographicRole);

        /**
         * <p>
         * A geospatial role for a column.
         * </p>
         * 
         * @param columnGeographicRole
         *        A geospatial role for a column.
         * @see GeoSpatialDataRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeoSpatialDataRole
         */
        Builder columnGeographicRole(GeoSpatialDataRole columnGeographicRole);

        /**
         * <p>
         * A description for a column.
         * </p>
         * 
         * @param columnDescription
         *        A description for a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnDescription(ColumnDescription columnDescription);

        /**
         * <p>
         * A description for a column.
         * </p>
         * This is a convenience that creates an instance of the {@link ColumnDescription.Builder} avoiding the need to
         * create one manually via {@link ColumnDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ColumnDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #columnDescription(ColumnDescription)}.
         * 
         * @param columnDescription
         *        a consumer that will call methods on {@link ColumnDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnDescription(ColumnDescription)
         */
        default Builder columnDescription(Consumer<ColumnDescription.Builder> columnDescription) {
            return columnDescription(ColumnDescription.builder().applyMutation(columnDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String columnGeographicRole;

        private ColumnDescription columnDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnTag model) {
            columnGeographicRole(model.columnGeographicRole);
            columnDescription(model.columnDescription);
        }

        public final String getColumnGeographicRole() {
            return columnGeographicRole;
        }

        public final void setColumnGeographicRole(String columnGeographicRole) {
            this.columnGeographicRole = columnGeographicRole;
        }

        @Override
        @Transient
        public final Builder columnGeographicRole(String columnGeographicRole) {
            this.columnGeographicRole = columnGeographicRole;
            return this;
        }

        @Override
        @Transient
        public final Builder columnGeographicRole(GeoSpatialDataRole columnGeographicRole) {
            this.columnGeographicRole(columnGeographicRole == null ? null : columnGeographicRole.toString());
            return this;
        }

        public final ColumnDescription.Builder getColumnDescription() {
            return columnDescription != null ? columnDescription.toBuilder() : null;
        }

        public final void setColumnDescription(ColumnDescription.BuilderImpl columnDescription) {
            this.columnDescription = columnDescription != null ? columnDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder columnDescription(ColumnDescription columnDescription) {
            this.columnDescription = columnDescription;
            return this;
        }

        @Override
        public ColumnTag build() {
            return new ColumnTag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
