/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that casts a column to a different type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CastColumnTypeOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<CastColumnTypeOperation.Builder, CastColumnTypeOperation> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(CastColumnTypeOperation::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<String> NEW_COLUMN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewColumnType").getter(getter(CastColumnTypeOperation::newColumnTypeAsString))
            .setter(setter(Builder::newColumnType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewColumnType").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(CastColumnTypeOperation::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            NEW_COLUMN_TYPE_FIELD, FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final String newColumnType;

    private final String format;

    private CastColumnTypeOperation(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.newColumnType = builder.newColumnType;
        this.format = builder.format;
    }

    /**
     * <p>
     * Column name.
     * </p>
     * 
     * @return Column name.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * New column data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #newColumnType}
     * will return {@link ColumnDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #newColumnTypeAsString}.
     * </p>
     * 
     * @return New column data type.
     * @see ColumnDataType
     */
    public final ColumnDataType newColumnType() {
        return ColumnDataType.fromValue(newColumnType);
    }

    /**
     * <p>
     * New column data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #newColumnType}
     * will return {@link ColumnDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #newColumnTypeAsString}.
     * </p>
     * 
     * @return New column data type.
     * @see ColumnDataType
     */
    public final String newColumnTypeAsString() {
        return newColumnType;
    }

    /**
     * <p>
     * When casting a column from string to datetime type, you can supply a string in a format supported by Amazon
     * QuickSight to denote the source data format.
     * </p>
     * 
     * @return When casting a column from string to datetime type, you can supply a string in a format supported by
     *         Amazon QuickSight to denote the source data format.
     */
    public final String format() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(newColumnTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CastColumnTypeOperation)) {
            return false;
        }
        CastColumnTypeOperation other = (CastColumnTypeOperation) obj;
        return Objects.equals(columnName(), other.columnName())
                && Objects.equals(newColumnTypeAsString(), other.newColumnTypeAsString())
                && Objects.equals(format(), other.format());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CastColumnTypeOperation").add("ColumnName", columnName())
                .add("NewColumnType", newColumnTypeAsString()).add("Format", format()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "NewColumnType":
            return Optional.ofNullable(clazz.cast(newColumnTypeAsString()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CastColumnTypeOperation, T> g) {
        return obj -> g.apply((CastColumnTypeOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CastColumnTypeOperation> {
        /**
         * <p>
         * Column name.
         * </p>
         * 
         * @param columnName
         *        Column name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * New column data type.
         * </p>
         * 
         * @param newColumnType
         *        New column data type.
         * @see ColumnDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnDataType
         */
        Builder newColumnType(String newColumnType);

        /**
         * <p>
         * New column data type.
         * </p>
         * 
         * @param newColumnType
         *        New column data type.
         * @see ColumnDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnDataType
         */
        Builder newColumnType(ColumnDataType newColumnType);

        /**
         * <p>
         * When casting a column from string to datetime type, you can supply a string in a format supported by Amazon
         * QuickSight to denote the source data format.
         * </p>
         * 
         * @param format
         *        When casting a column from string to datetime type, you can supply a string in a format supported by
         *        Amazon QuickSight to denote the source data format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private String newColumnType;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(CastColumnTypeOperation model) {
            columnName(model.columnName);
            newColumnType(model.newColumnType);
            format(model.format);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        @Transient
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getNewColumnType() {
            return newColumnType;
        }

        public final void setNewColumnType(String newColumnType) {
            this.newColumnType = newColumnType;
        }

        @Override
        @Transient
        public final Builder newColumnType(String newColumnType) {
            this.newColumnType = newColumnType;
            return this;
        }

        @Override
        @Transient
        public final Builder newColumnType(ColumnDataType newColumnType) {
            this.newColumnType(newColumnType == null ? null : newColumnType.toString());
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public CastColumnTypeOperation build() {
            return new CastColumnTypeOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
