/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that projects columns. Operations that come after a projection can only refer to projected
 * columns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<ProjectOperation.Builder, ProjectOperation> {
    private static final SdkField<List<String>> PROJECTED_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProjectedColumns")
            .getter(getter(ProjectOperation::projectedColumns))
            .setter(setter(Builder::projectedColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectedColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECTED_COLUMNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> projectedColumns;

    private ProjectOperation(BuilderImpl builder) {
        this.projectedColumns = builder.projectedColumns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProjectedColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProjectedColumns() {
        return projectedColumns != null && !(projectedColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Projected columns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjectedColumns} method.
     * </p>
     * 
     * @return Projected columns.
     */
    public final List<String> projectedColumns() {
        return projectedColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectedColumns() ? projectedColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectOperation)) {
            return false;
        }
        ProjectOperation other = (ProjectOperation) obj;
        return hasProjectedColumns() == other.hasProjectedColumns()
                && Objects.equals(projectedColumns(), other.projectedColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectOperation").add("ProjectedColumns", hasProjectedColumns() ? projectedColumns() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectedColumns":
            return Optional.ofNullable(clazz.cast(projectedColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectOperation, T> g) {
        return obj -> g.apply((ProjectOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectOperation> {
        /**
         * <p>
         * Projected columns.
         * </p>
         * 
         * @param projectedColumns
         *        Projected columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedColumns(Collection<String> projectedColumns);

        /**
         * <p>
         * Projected columns.
         * </p>
         * 
         * @param projectedColumns
         *        Projected columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedColumns(String... projectedColumns);
    }

    static final class BuilderImpl implements Builder {
        private List<String> projectedColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectOperation model) {
            projectedColumns(model.projectedColumns);
        }

        public final Collection<String> getProjectedColumns() {
            if (projectedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return projectedColumns;
        }

        public final void setProjectedColumns(Collection<String> projectedColumns) {
            this.projectedColumns = ProjectedColumnListCopier.copy(projectedColumns);
        }

        @Override
        @Transient
        public final Builder projectedColumns(Collection<String> projectedColumns) {
            this.projectedColumns = ProjectedColumnListCopier.copy(projectedColumns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder projectedColumns(String... projectedColumns) {
            projectedColumns(Arrays.asList(projectedColumns));
            return this;
        }

        @Override
        public ProjectOperation build() {
            return new ProjectOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
