/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterUserRequest extends QuickSightRequest implements
        ToCopyableBuilder<RegisterUserRequest.Builder, RegisterUserRequest> {
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityType").getter(getter(RegisterUserRequest::identityTypeAsString))
            .setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(RegisterUserRequest::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> USER_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserRole").getter(getter(RegisterUserRequest::userRoleAsString)).setter(setter(Builder::userRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRole").build()).build();

    private static final SdkField<String> IAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("IamArn")
            .getter(getter(RegisterUserRequest::iamArn)).setter(setter(Builder::iamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamArn").build()).build();

    private static final SdkField<String> SESSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionName").getter(getter(RegisterUserRequest::sessionName)).setter(setter(Builder::sessionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionName").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(RegisterUserRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(RegisterUserRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(RegisterUserRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> CUSTOM_PERMISSIONS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomPermissionsName").getter(getter(RegisterUserRequest::customPermissionsName))
            .setter(setter(Builder::customPermissionsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPermissionsName").build())
            .build();

    private static final SdkField<String> EXTERNAL_LOGIN_FEDERATION_PROVIDER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExternalLoginFederationProviderType")
            .getter(getter(RegisterUserRequest::externalLoginFederationProviderType))
            .setter(setter(Builder::externalLoginFederationProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ExternalLoginFederationProviderType").build()).build();

    private static final SdkField<String> CUSTOM_FEDERATION_PROVIDER_URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomFederationProviderUrl")
            .getter(getter(RegisterUserRequest::customFederationProviderUrl))
            .setter(setter(Builder::customFederationProviderUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomFederationProviderUrl")
                    .build()).build();

    private static final SdkField<String> EXTERNAL_LOGIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalLoginId").getter(getter(RegisterUserRequest::externalLoginId))
            .setter(setter(Builder::externalLoginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalLoginId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_TYPE_FIELD,
            EMAIL_FIELD, USER_ROLE_FIELD, IAM_ARN_FIELD, SESSION_NAME_FIELD, AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD,
            USER_NAME_FIELD, CUSTOM_PERMISSIONS_NAME_FIELD, EXTERNAL_LOGIN_FEDERATION_PROVIDER_TYPE_FIELD,
            CUSTOM_FEDERATION_PROVIDER_URL_FIELD, EXTERNAL_LOGIN_ID_FIELD));

    private final String identityType;

    private final String email;

    private final String userRole;

    private final String iamArn;

    private final String sessionName;

    private final String awsAccountId;

    private final String namespace;

    private final String userName;

    private final String customPermissionsName;

    private final String externalLoginFederationProviderType;

    private final String customFederationProviderUrl;

    private final String externalLoginId;

    private RegisterUserRequest(BuilderImpl builder) {
        super(builder);
        this.identityType = builder.identityType;
        this.email = builder.email;
        this.userRole = builder.userRole;
        this.iamArn = builder.iamArn;
        this.sessionName = builder.sessionName;
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.userName = builder.userName;
        this.customPermissionsName = builder.customPermissionsName;
        this.externalLoginFederationProviderType = builder.externalLoginFederationProviderType;
        this.customFederationProviderUrl = builder.customFederationProviderUrl;
        this.externalLoginId = builder.externalLoginId;
    }

    /**
     * <p>
     * Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
     *         </p>
     *         </li>
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
     *         </p>
     *         </li>
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * The email address of the user that you want to register.
     * </p>
     * 
     * @return The email address of the user that you want to register.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The Amazon QuickSight role for the user. The user role can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READER</code>: A user who has read-only access to dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userRole} will
     * return {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userRoleAsString}.
     * </p>
     * 
     * @return The Amazon QuickSight role for the user. The user role can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READER</code>: A user who has read-only access to dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     * @see UserRole
     */
    public final UserRole userRole() {
        return UserRole.fromValue(userRole);
    }

    /**
     * <p>
     * The Amazon QuickSight role for the user. The user role can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READER</code>: A user who has read-only access to dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userRole} will
     * return {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userRoleAsString}.
     * </p>
     * 
     * @return The Amazon QuickSight role for the user. The user role can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READER</code>: A user who has read-only access to dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     * @see UserRole
     */
    public final String userRoleAsString() {
        return userRole;
    }

    /**
     * <p>
     * The ARN of the IAM user or role that you are registering with Amazon QuickSight.
     * </p>
     * 
     * @return The ARN of the IAM user or role that you are registering with Amazon QuickSight.
     */
    public final String iamArn() {
        return iamArn;
    }

    /**
     * <p>
     * You need to use this parameter only when you register one or more users using an assumed IAM role. You don't need
     * to provide the session name for other scenarios, for example when you are registering an IAM user or an Amazon
     * QuickSight user. You can register multiple users using the same IAM role if each user has a different session
     * name. For more information on assuming IAM roles, see <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code> </a> in
     * the <i>CLI Reference.</i>
     * </p>
     * 
     * @return You need to use this parameter only when you register one or more users using an assumed IAM role. You
     *         don't need to provide the session name for other scenarios, for example when you are registering an IAM
     *         user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each user
     *         has a different session name. For more information on assuming IAM roles, see <a
     *         href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code>
     *         </a> in the <i>CLI Reference.</i>
     */
    public final String sessionName() {
        return sessionName;
    }

    /**
     * <p>
     * The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web
     * Services account that contains your Amazon QuickSight account.
     * </p>
     * 
     * @return The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon
     *         Web Services account that contains your Amazon QuickSight account.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The namespace. Currently, you should set this to <code>default</code>.
     * </p>
     * 
     * @return The namespace. Currently, you should set this to <code>default</code>.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The Amazon QuickSight user name that you want to create for the user you are registering.
     * </p>
     * 
     * @return The Amazon QuickSight user name that you want to create for the user you are registering.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user.
     * Customized permissions allows you to control a user's access by restricting access the following operations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create and update data sources
     * </p>
     * </li>
     * <li>
     * <p>
     * Create and update datasets
     * </p>
     * </li>
     * <li>
     * <p>
     * Create and update email reports
     * </p>
     * </li>
     * <li>
     * <p>
     * Subscribe to email reports
     * </p>
     * </li>
     * </ul>
     * <p>
     * To add custom permissions to an existing user, use
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code>
     * instead.
     * </p>
     * <p>
     * A set of custom permissions includes any combination of these restrictions. Currently, you need to create the
     * profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the
     * <code>RegisterUser</code> API operation to assign the named set of permissions to a Amazon QuickSight user.
     * </p>
     * <p>
     * Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions
     * typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon
     * QuickSight (admin, author, reader).
     * </p>
     * <p>
     * This feature is available only to Amazon QuickSight Enterprise edition subscriptions.
     * </p>
     * 
     * @return (Enterprise edition only) The name of the custom permissions profile that you want to assign to this
     *         user. Customized permissions allows you to control a user's access by restricting access the following
     *         operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Create and update data sources
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Create and update datasets
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Create and update email reports
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Subscribe to email reports
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To add custom permissions to an existing user, use
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code>
     *         instead.
     *         </p>
     *         <p>
     *         A set of custom permissions includes any combination of these restrictions. Currently, you need to create
     *         the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the
     *         <code>RegisterUser</code> API operation to assign the named set of permissions to a Amazon QuickSight
     *         user.
     *         </p>
     *         <p>
     *         Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the
     *         permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts
     *         in Amazon QuickSight (admin, author, reader).
     *         </p>
     *         <p>
     *         This feature is available only to Amazon QuickSight Enterprise edition subscriptions.
     */
    public final String customPermissionsName() {
        return customPermissionsName;
    }

    /**
     * <p>
     * The type of supported external login provider that provides identity to let a user federate into Amazon
     * QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login
     * provider can be one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the
     * <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed
     * when the external provider is custom.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use
     * the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of supported external login provider that provides identity to let a user federate into Amazon
     *         QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external
     *         login provider can be one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing
     *         the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is
     *         only needed when the external provider is custom.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code>
     *         type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.
     *         </p>
     *         </li>
     */
    public final String externalLoginFederationProviderType() {
        return externalLoginFederationProviderType;
    }

    /**
     * <p>
     * The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon
     * QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when
     * <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.
     * </p>
     * 
     * @return The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into
     *         Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only
     *         be used when <code>ExternalLoginFederationProviderType</code> parameter is set to
     *         <code>CUSTOM_OIDC</code>.
     */
    public final String customFederationProviderUrl() {
        return customFederationProviderUrl;
    }

    /**
     * <p>
     * The identity ID for a user in the external login provider.
     * </p>
     * 
     * @return The identity ID for a user in the external login provider.
     */
    public final String externalLoginId() {
        return externalLoginId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(userRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iamArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionName());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(customPermissionsName());
        hashCode = 31 * hashCode + Objects.hashCode(externalLoginFederationProviderType());
        hashCode = 31 * hashCode + Objects.hashCode(customFederationProviderUrl());
        hashCode = 31 * hashCode + Objects.hashCode(externalLoginId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterUserRequest)) {
            return false;
        }
        RegisterUserRequest other = (RegisterUserRequest) obj;
        return Objects.equals(identityTypeAsString(), other.identityTypeAsString()) && Objects.equals(email(), other.email())
                && Objects.equals(userRoleAsString(), other.userRoleAsString()) && Objects.equals(iamArn(), other.iamArn())
                && Objects.equals(sessionName(), other.sessionName()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(userName(), other.userName())
                && Objects.equals(customPermissionsName(), other.customPermissionsName())
                && Objects.equals(externalLoginFederationProviderType(), other.externalLoginFederationProviderType())
                && Objects.equals(customFederationProviderUrl(), other.customFederationProviderUrl())
                && Objects.equals(externalLoginId(), other.externalLoginId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterUserRequest").add("IdentityType", identityTypeAsString()).add("Email", email())
                .add("UserRole", userRoleAsString()).add("IamArn", iamArn()).add("SessionName", sessionName())
                .add("AwsAccountId", awsAccountId()).add("Namespace", namespace()).add("UserName", userName())
                .add("CustomPermissionsName", customPermissionsName())
                .add("ExternalLoginFederationProviderType", externalLoginFederationProviderType())
                .add("CustomFederationProviderUrl", customFederationProviderUrl()).add("ExternalLoginId", externalLoginId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "UserRole":
            return Optional.ofNullable(clazz.cast(userRoleAsString()));
        case "IamArn":
            return Optional.ofNullable(clazz.cast(iamArn()));
        case "SessionName":
            return Optional.ofNullable(clazz.cast(sessionName()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "CustomPermissionsName":
            return Optional.ofNullable(clazz.cast(customPermissionsName()));
        case "ExternalLoginFederationProviderType":
            return Optional.ofNullable(clazz.cast(externalLoginFederationProviderType()));
        case "CustomFederationProviderUrl":
            return Optional.ofNullable(clazz.cast(customFederationProviderUrl()));
        case "ExternalLoginId":
            return Optional.ofNullable(clazz.cast(externalLoginId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterUserRequest, T> g) {
        return obj -> g.apply((RegisterUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterUserRequest> {
        /**
         * <p>
         * Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
         * </p>
         * </li>
         * </ul>
         * 
         * @param identityType
         *        Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
         *        </p>
         *        </li>
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
         * </p>
         * </li>
         * </ul>
         * 
         * @param identityType
         *        Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IAM</code>: A user whose identity maps to an existing IAM user or role.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight.
         *        </p>
         *        </li>
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The email address of the user that you want to register.
         * </p>
         * 
         * @param email
         *        The email address of the user that you want to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The Amazon QuickSight role for the user. The user role can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READER</code>: A user who has read-only access to dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param userRole
         *        The Amazon QuickSight role for the user. The user role can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READER</code>: A user who has read-only access to dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder userRole(String userRole);

        /**
         * <p>
         * The Amazon QuickSight role for the user. The user role can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READER</code>: A user who has read-only access to dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param userRole
         *        The Amazon QuickSight role for the user. The user role can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READER</code>: A user who has read-only access to dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder userRole(UserRole userRole);

        /**
         * <p>
         * The ARN of the IAM user or role that you are registering with Amazon QuickSight.
         * </p>
         * 
         * @param iamArn
         *        The ARN of the IAM user or role that you are registering with Amazon QuickSight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamArn(String iamArn);

        /**
         * <p>
         * You need to use this parameter only when you register one or more users using an assumed IAM role. You don't
         * need to provide the session name for other scenarios, for example when you are registering an IAM user or an
         * Amazon QuickSight user. You can register multiple users using the same IAM role if each user has a different
         * session name. For more information on assuming IAM roles, see <a
         * href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code> </a>
         * in the <i>CLI Reference.</i>
         * </p>
         * 
         * @param sessionName
         *        You need to use this parameter only when you register one or more users using an assumed IAM role. You
         *        don't need to provide the session name for other scenarios, for example when you are registering an
         *        IAM user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each
         *        user has a different session name. For more information on assuming IAM roles, see <a
         *        href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code>
         *        </a> in the <i>CLI Reference.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionName(String sessionName);

        /**
         * <p>
         * The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web
         * Services account that contains your Amazon QuickSight account.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
         *        Amazon Web Services account that contains your Amazon QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The namespace. Currently, you should set this to <code>default</code>.
         * </p>
         * 
         * @param namespace
         *        The namespace. Currently, you should set this to <code>default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The Amazon QuickSight user name that you want to create for the user you are registering.
         * </p>
         * 
         * @param userName
         *        The Amazon QuickSight user name that you want to create for the user you are registering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user.
         * Customized permissions allows you to control a user's access by restricting access the following operations:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Create and update data sources
         * </p>
         * </li>
         * <li>
         * <p>
         * Create and update datasets
         * </p>
         * </li>
         * <li>
         * <p>
         * Create and update email reports
         * </p>
         * </li>
         * <li>
         * <p>
         * Subscribe to email reports
         * </p>
         * </li>
         * </ul>
         * <p>
         * To add custom permissions to an existing user, use
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code>
         * instead.
         * </p>
         * <p>
         * A set of custom permissions includes any combination of these restrictions. Currently, you need to create the
         * profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the
         * <code>RegisterUser</code> API operation to assign the named set of permissions to a Amazon QuickSight user.
         * </p>
         * <p>
         * Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the
         * permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in
         * Amazon QuickSight (admin, author, reader).
         * </p>
         * <p>
         * This feature is available only to Amazon QuickSight Enterprise edition subscriptions.
         * </p>
         * 
         * @param customPermissionsName
         *        (Enterprise edition only) The name of the custom permissions profile that you want to assign to this
         *        user. Customized permissions allows you to control a user's access by restricting access the following
         *        operations:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Create and update data sources
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Create and update datasets
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Create and update email reports
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Subscribe to email reports
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To add custom permissions to an existing user, use
         *        <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code>
         *        instead.
         *        </p>
         *        <p>
         *        A set of custom permissions includes any combination of these restrictions. Currently, you need to
         *        create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you
         *        use the <code>RegisterUser</code> API operation to assign the named set of permissions to a Amazon
         *        QuickSight user.
         *        </p>
         *        <p>
         *        Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the
         *        permissions typically granted by assigning Amazon QuickSight users to one of the default security
         *        cohorts in Amazon QuickSight (admin, author, reader).
         *        </p>
         *        <p>
         *        This feature is available only to Amazon QuickSight Enterprise edition subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPermissionsName(String customPermissionsName);

        /**
         * <p>
         * The type of supported external login provider that provides identity to let a user federate into Amazon
         * QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login
         * provider can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the
         * <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only
         * needed when the external provider is custom.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type,
         * use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.
         * </p>
         * </li>
         * </ul>
         * 
         * @param externalLoginFederationProviderType
         *        The type of supported external login provider that provides identity to let a user federate into
         *        Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported
         *        external login provider can be one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When
         *        choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter
         *        which is only needed when the external provider is custom.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing
         *        <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide
         *        the custom OIDC provider URL.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalLoginFederationProviderType(String externalLoginFederationProviderType);

        /**
         * <p>
         * The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into
         * Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be
         * used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.
         * </p>
         * 
         * @param customFederationProviderUrl
         *        The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate
         *        into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter
         *        should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to
         *        <code>CUSTOM_OIDC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFederationProviderUrl(String customFederationProviderUrl);

        /**
         * <p>
         * The identity ID for a user in the external login provider.
         * </p>
         * 
         * @param externalLoginId
         *        The identity ID for a user in the external login provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalLoginId(String externalLoginId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String identityType;

        private String email;

        private String userRole;

        private String iamArn;

        private String sessionName;

        private String awsAccountId;

        private String namespace;

        private String userName;

        private String customPermissionsName;

        private String externalLoginFederationProviderType;

        private String customFederationProviderUrl;

        private String externalLoginId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterUserRequest model) {
            super(model);
            identityType(model.identityType);
            email(model.email);
            userRole(model.userRole);
            iamArn(model.iamArn);
            sessionName(model.sessionName);
            awsAccountId(model.awsAccountId);
            namespace(model.namespace);
            userName(model.userName);
            customPermissionsName(model.customPermissionsName);
            externalLoginFederationProviderType(model.externalLoginFederationProviderType);
            customFederationProviderUrl(model.customFederationProviderUrl);
            externalLoginId(model.externalLoginId);
        }

        public final String getIdentityType() {
            return identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        @Transient
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        @Transient
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        @Transient
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getUserRole() {
            return userRole;
        }

        public final void setUserRole(String userRole) {
            this.userRole = userRole;
        }

        @Override
        @Transient
        public final Builder userRole(String userRole) {
            this.userRole = userRole;
            return this;
        }

        @Override
        @Transient
        public final Builder userRole(UserRole userRole) {
            this.userRole(userRole == null ? null : userRole.toString());
            return this;
        }

        public final String getIamArn() {
            return iamArn;
        }

        public final void setIamArn(String iamArn) {
            this.iamArn = iamArn;
        }

        @Override
        @Transient
        public final Builder iamArn(String iamArn) {
            this.iamArn = iamArn;
            return this;
        }

        public final String getSessionName() {
            return sessionName;
        }

        public final void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        @Override
        @Transient
        public final Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        @Transient
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        @Transient
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getCustomPermissionsName() {
            return customPermissionsName;
        }

        public final void setCustomPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
        }

        @Override
        @Transient
        public final Builder customPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
            return this;
        }

        public final String getExternalLoginFederationProviderType() {
            return externalLoginFederationProviderType;
        }

        public final void setExternalLoginFederationProviderType(String externalLoginFederationProviderType) {
            this.externalLoginFederationProviderType = externalLoginFederationProviderType;
        }

        @Override
        @Transient
        public final Builder externalLoginFederationProviderType(String externalLoginFederationProviderType) {
            this.externalLoginFederationProviderType = externalLoginFederationProviderType;
            return this;
        }

        public final String getCustomFederationProviderUrl() {
            return customFederationProviderUrl;
        }

        public final void setCustomFederationProviderUrl(String customFederationProviderUrl) {
            this.customFederationProviderUrl = customFederationProviderUrl;
        }

        @Override
        @Transient
        public final Builder customFederationProviderUrl(String customFederationProviderUrl) {
            this.customFederationProviderUrl = customFederationProviderUrl;
            return this;
        }

        public final String getExternalLoginId() {
            return externalLoginId;
        }

        public final void setExternalLoginId(String externalLoginId) {
            this.externalLoginId = externalLoginId;
        }

        @Override
        @Transient
        public final Builder externalLoginId(String externalLoginId) {
            this.externalLoginId = externalLoginId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterUserRequest build() {
            return new RegisterUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
