/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A folder in Amazon QuickSight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Folder implements SdkPojo, Serializable, ToCopyableBuilder<Folder.Builder, Folder> {
    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FolderId").getter(getter(Folder::folderId)).setter(setter(Builder::folderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Folder::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Folder::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> FOLDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FolderType").getter(getter(Folder::folderTypeAsString)).setter(setter(Builder::folderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderType").build()).build();

    private static final SdkField<List<String>> FOLDER_PATH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FolderPath")
            .getter(getter(Folder::folderPath))
            .setter(setter(Builder::folderPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderPath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Folder::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(Folder::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLDER_ID_FIELD, ARN_FIELD,
            NAME_FIELD, FOLDER_TYPE_FIELD, FOLDER_PATH_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String folderId;

    private final String arn;

    private final String name;

    private final String folderType;

    private final List<String> folderPath;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private Folder(BuilderImpl builder) {
        this.folderId = builder.folderId;
        this.arn = builder.arn;
        this.name = builder.name;
        this.folderType = builder.folderType;
        this.folderPath = builder.folderPath;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The ID of the folder.
     * </p>
     * 
     * @return The ID of the folder.
     */
    public final String folderId() {
        return folderId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the folder.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the folder.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A display name for the folder.
     * </p>
     * 
     * @return A display name for the folder.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of folder it is.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #folderType} will
     * return {@link FolderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #folderTypeAsString}.
     * </p>
     * 
     * @return The type of folder it is.
     * @see FolderType
     */
    public final FolderType folderType() {
        return FolderType.fromValue(folderType);
    }

    /**
     * <p>
     * The type of folder it is.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #folderType} will
     * return {@link FolderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #folderTypeAsString}.
     * </p>
     * 
     * @return The type of folder it is.
     * @see FolderType
     */
    public final String folderTypeAsString() {
        return folderType;
    }

    /**
     * For responses, this returns true if the service returned a value for the FolderPath property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFolderPath() {
        return folderPath != null && !(folderPath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of ancestor ARN strings for the folder.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFolderPath} method.
     * </p>
     * 
     * @return An array of ancestor ARN strings for the folder.
     */
    public final List<String> folderPath() {
        return folderPath;
    }

    /**
     * <p>
     * The time that the folder was created.
     * </p>
     * 
     * @return The time that the folder was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The time that the folder was last updated.
     * </p>
     * 
     * @return The time that the folder was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(folderId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(folderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFolderPath() ? folderPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Folder)) {
            return false;
        }
        Folder other = (Folder) obj;
        return Objects.equals(folderId(), other.folderId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(name(), other.name()) && Objects.equals(folderTypeAsString(), other.folderTypeAsString())
                && hasFolderPath() == other.hasFolderPath() && Objects.equals(folderPath(), other.folderPath())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Folder").add("FolderId", folderId()).add("Arn", arn()).add("Name", name())
                .add("FolderType", folderTypeAsString()).add("FolderPath", hasFolderPath() ? folderPath() : null)
                .add("CreatedTime", createdTime()).add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FolderId":
            return Optional.ofNullable(clazz.cast(folderId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "FolderType":
            return Optional.ofNullable(clazz.cast(folderTypeAsString()));
        case "FolderPath":
            return Optional.ofNullable(clazz.cast(folderPath()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Folder, T> g) {
        return obj -> g.apply((Folder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Folder> {
        /**
         * <p>
         * The ID of the folder.
         * </p>
         * 
         * @param folderId
         *        The ID of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderId(String folderId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the folder.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A display name for the folder.
         * </p>
         * 
         * @param name
         *        A display name for the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of folder it is.
         * </p>
         * 
         * @param folderType
         *        The type of folder it is.
         * @see FolderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FolderType
         */
        Builder folderType(String folderType);

        /**
         * <p>
         * The type of folder it is.
         * </p>
         * 
         * @param folderType
         *        The type of folder it is.
         * @see FolderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FolderType
         */
        Builder folderType(FolderType folderType);

        /**
         * <p>
         * An array of ancestor ARN strings for the folder.
         * </p>
         * 
         * @param folderPath
         *        An array of ancestor ARN strings for the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderPath(Collection<String> folderPath);

        /**
         * <p>
         * An array of ancestor ARN strings for the folder.
         * </p>
         * 
         * @param folderPath
         *        An array of ancestor ARN strings for the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderPath(String... folderPath);

        /**
         * <p>
         * The time that the folder was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the folder was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The time that the folder was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time that the folder was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String folderId;

        private String arn;

        private String name;

        private String folderType;

        private List<String> folderPath = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Folder model) {
            folderId(model.folderId);
            arn(model.arn);
            name(model.name);
            folderType(model.folderType);
            folderPath(model.folderPath);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getFolderId() {
            return folderId;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFolderType() {
            return folderType;
        }

        public final void setFolderType(String folderType) {
            this.folderType = folderType;
        }

        @Override
        public final Builder folderType(String folderType) {
            this.folderType = folderType;
            return this;
        }

        @Override
        public final Builder folderType(FolderType folderType) {
            this.folderType(folderType == null ? null : folderType.toString());
            return this;
        }

        public final Collection<String> getFolderPath() {
            if (folderPath instanceof SdkAutoConstructList) {
                return null;
            }
            return folderPath;
        }

        public final void setFolderPath(Collection<String> folderPath) {
            this.folderPath = PathCopier.copy(folderPath);
        }

        @Override
        public final Builder folderPath(Collection<String> folderPath) {
            this.folderPath = PathCopier.copy(folderPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderPath(String... folderPath) {
            folderPath(Arrays.asList(folderPath));
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public Folder build() {
            return new Folder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
