/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about rows for a data set SPICE ingestion.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowInfo implements SdkPojo, Serializable, ToCopyableBuilder<RowInfo.Builder, RowInfo> {
    private static final SdkField<Long> ROWS_INGESTED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RowsIngested").getter(getter(RowInfo::rowsIngested)).setter(setter(Builder::rowsIngested))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowsIngested").build()).build();

    private static final SdkField<Long> ROWS_DROPPED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RowsDropped").getter(getter(RowInfo::rowsDropped)).setter(setter(Builder::rowsDropped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowsDropped").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_INGESTED_FIELD,
            ROWS_DROPPED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long rowsIngested;

    private final Long rowsDropped;

    private RowInfo(BuilderImpl builder) {
        this.rowsIngested = builder.rowsIngested;
        this.rowsDropped = builder.rowsDropped;
    }

    /**
     * <p>
     * The number of rows that were ingested.
     * </p>
     * 
     * @return The number of rows that were ingested.
     */
    public final Long rowsIngested() {
        return rowsIngested;
    }

    /**
     * <p>
     * The number of rows that were not ingested.
     * </p>
     * 
     * @return The number of rows that were not ingested.
     */
    public final Long rowsDropped() {
        return rowsDropped;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rowsIngested());
        hashCode = 31 * hashCode + Objects.hashCode(rowsDropped());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowInfo)) {
            return false;
        }
        RowInfo other = (RowInfo) obj;
        return Objects.equals(rowsIngested(), other.rowsIngested()) && Objects.equals(rowsDropped(), other.rowsDropped());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RowInfo").add("RowsIngested", rowsIngested()).add("RowsDropped", rowsDropped()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RowsIngested":
            return Optional.ofNullable(clazz.cast(rowsIngested()));
        case "RowsDropped":
            return Optional.ofNullable(clazz.cast(rowsDropped()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RowInfo, T> g) {
        return obj -> g.apply((RowInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowInfo> {
        /**
         * <p>
         * The number of rows that were ingested.
         * </p>
         * 
         * @param rowsIngested
         *        The number of rows that were ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowsIngested(Long rowsIngested);

        /**
         * <p>
         * The number of rows that were not ingested.
         * </p>
         * 
         * @param rowsDropped
         *        The number of rows that were not ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowsDropped(Long rowsDropped);
    }

    static final class BuilderImpl implements Builder {
        private Long rowsIngested;

        private Long rowsDropped;

        private BuilderImpl() {
        }

        private BuilderImpl(RowInfo model) {
            rowsIngested(model.rowsIngested);
            rowsDropped(model.rowsDropped);
        }

        public final Long getRowsIngested() {
            return rowsIngested;
        }

        public final void setRowsIngested(Long rowsIngested) {
            this.rowsIngested = rowsIngested;
        }

        @Override
        @Transient
        public final Builder rowsIngested(Long rowsIngested) {
            this.rowsIngested = rowsIngested;
            return this;
        }

        public final Long getRowsDropped() {
            return rowsDropped;
        }

        public final void setRowsDropped(Long rowsDropped) {
            this.rowsDropped = rowsDropped;
        }

        @Override
        @Transient
        public final Builder rowsDropped(Long rowsDropped) {
            this.rowsDropped = rowsDropped;
            return this;
        }

        @Override
        public RowInfo build() {
            return new RowInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
